/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.tbox.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import openllet.aterm.AFun;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.DependencySet;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.rbox.Role;
import openllet.core.boxes.tbox.TBox;
import openllet.core.boxes.tbox.impl.BinaryTBox;
import openllet.core.boxes.tbox.impl.PrimitiveTBox;
import openllet.core.boxes.tbox.impl.UnaryTBox;
import openllet.core.boxes.tbox.impl.Unfolding;
import openllet.core.datatypes.Facet;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.rules.model.AtomDConstant;
import openllet.core.rules.model.AtomDObject;
import openllet.core.rules.model.AtomDVariable;
import openllet.core.rules.model.AtomIConstant;
import openllet.core.rules.model.AtomIObject;
import openllet.core.rules.model.AtomIVariable;
import openllet.core.rules.model.BuiltInAtom;
import openllet.core.rules.model.ClassAtom;
import openllet.core.rules.model.DataRangeAtom;
import openllet.core.rules.model.DatavaluedPropertyAtom;
import openllet.core.rules.model.IndividualPropertyAtom;
import openllet.core.rules.model.Rule;
import openllet.core.rules.model.RuleAtom;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.BinarySet;
import openllet.core.utils.CollectionUtils;
import openllet.core.utils.MultiMapUtils;
import openllet.core.utils.SetUtils;
import openllet.core.utils.TermFactory;
import openllet.core.utils.iterator.IteratorUtils;
import openllet.core.utils.iterator.MultiIterator;
import openllet.core.utils.iterator.MultiListIterator;
import openllet.shared.tools.Log;

public class TBoxImpl
implements TBox {
    public static final Logger _logger = Log.getLogger(TBoxImpl.class);
    private static final Map<ATermAppl, String> FACETS = new HashMap<ATermAppl, String>();
    private static final Set<Set<ATermAppl>> SINGLE_EMPTY_SET;
    private final KnowledgeBase _kb;
    private final Set<ATermAppl> _classes = CollectionUtils.makeIdentitySet();
    private final Set<ATermAppl> _allClasses = SetUtils.create();
    private final Map<ATermAppl, Set<Set<ATermAppl>>> _tboxAxioms = CollectionUtils.makeIdentityMap();
    private final Map<ATermAppl, Set<ATermAppl>> _reverseExplain = CollectionUtils.makeIdentityMap();
    private final Set<ATermAppl> _tboxAssertedAxioms = CollectionUtils.makeIdentitySet();
    private final Set<ATermAppl> _absorbedAxioms = SetUtils.create();
    private final PrimitiveTBox _primitiveTbox = new PrimitiveTBox();
    private final UnaryTBox _unaryTbox = new UnaryTBox();
    private final BinaryTBox _binaryTbox = new BinaryTBox();
    private final Absorption[] absorptions = new Absorption[]{new BinaryAbsorption(true), new DeterministicUnaryAbsorption(), new SimplifyAbsorption(), new OneOfAbsorption(), new HasValueAbsorption(), new RuleAbsorption(), new BinaryAbsorption(false), new ExistentialAbsorption(), new UnaryAbsorption(), new UnfoldAbsorption(), new DomainAbsorption(), new GeneralAbsorption()};
    private int freshConceptCount = 0;

    public TBoxImpl(KnowledgeBase kb) {
        this._kb = kb;
    }

    public KnowledgeBase getKB() {
        return this._kb;
    }

    @Override
    public Set<ATermAppl> getAllClasses() {
        if (this._allClasses.isEmpty()) {
            this._allClasses.addAll(this._classes);
            this._allClasses.add(ATermUtils.TOP);
            this._allClasses.add(ATermUtils.BOTTOM);
        }
        return this._allClasses;
    }

    @Override
    public Set<Set<ATermAppl>> getAxiomExplanations(ATermAppl axiom) {
        return this._tboxAxioms.get(axiom);
    }

    @Override
    public Set<ATermAppl> getAxiomExplanation(ATermAppl axiom) {
        Set<Set<ATermAppl>> explains = this._tboxAxioms.get(axiom);
        if (explains == null || explains.isEmpty()) {
            _logger.warning("No clashExplanation for " + axiom);
            return Collections.emptySet();
        }
        Iterator<Set<ATermAppl>> iterator = explains.iterator();
        if (iterator.hasNext()) {
            Set<ATermAppl> explain = iterator.next();
            return explain;
        }
        return Collections.emptySet();
    }

    private boolean addAxiomExplanation(ATermAppl axiom, Set<ATermAppl> explain) {
        _logger.fine(() -> "Add Axiom: " + ATermUtils.toString(axiom) + " Explanation: " + explain);
        boolean added = false;
        added = !OpenlletOptions.USE_TRACING ? this._tboxAxioms.put(axiom, SINGLE_EMPTY_SET) == null : MultiMapUtils.add(this._tboxAxioms, axiom, explain);
        if (added) {
            for (ATermAppl explainAxiom : explain) {
                if (axiom.equals(explainAxiom)) continue;
                MultiMapUtils.add(this._reverseExplain, explainAxiom, axiom);
            }
        }
        return added;
    }

    private static List<ATermAppl> normalizeDisjointAxiom(ATermAppl ... concepts) {
        List<ATermAppl> axioms = CollectionUtils.makeList();
        for (int i = 0; i < concepts.length - 1; ++i) {
            ATermAppl c1 = concepts[i];
            ATermAppl notC1 = ATermUtils.makeNot(c1);
            for (int j = i + 1; j < concepts.length; ++j) {
                ATermAppl c2 = concepts[j];
                ATermAppl notC2 = ATermUtils.makeNot(c2);
                axioms.add(ATermUtils.makeSub(c1, notC2));
                if (!ATermUtils.isPrimitive(c2)) continue;
                axioms.add(ATermUtils.makeSub(c2, notC1));
            }
        }
        return axioms;
    }

    @Override
    public boolean addAxiom(ATermAppl axiom) {
        Set<ATermAppl> explain;
        this._tboxAssertedAxioms.add(axiom);
        List<ATermAppl> axioms = null;
        Set<ATermAppl> set = explain = OpenlletOptions.USE_TRACING ? Collections.singleton(axiom) : Collections.emptySet();
        if (axiom.getAFun().equals(ATermUtils.EQCLASSFUN)) {
            axioms = Collections.singletonList(axiom);
        } else if (axiom.getAFun().equals(ATermUtils.SUBFUN)) {
            axioms = Collections.singletonList(axiom);
        } else if (axiom.getAFun().equals(ATermUtils.DISJOINTFUN)) {
            ATermAppl c1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl c2 = (ATermAppl)axiom.getArgument(1);
            axioms = TBoxImpl.normalizeDisjointAxiom(c1, c2);
        } else if (axiom.getAFun().equals(ATermUtils.DISJOINTSFUN)) {
            ATermList list = (ATermList)axiom.getArgument(0);
            ATermAppl[] concepts = ATermUtils.toArray(list);
            axioms = TBoxImpl.normalizeDisjointAxiom(concepts);
        } else {
            _logger.warning("Not a valid TBox axiom: " + axiom);
            return false;
        }
        boolean added = false;
        for (ATermAppl a : axioms) {
            added |= this.addAxiom(a, explain, false);
        }
        return added;
    }

    private boolean addAxiom(ATermAppl axiom, Set<ATermAppl> explanation, boolean forceAddition) {
        boolean added = this.addAxiomExplanation(axiom, explanation);
        if (added || forceAddition) {
            if (axiom.getAFun().equals(ATermUtils.EQCLASSFUN)) {
                ATermAppl c1 = (ATermAppl)axiom.getArgument(0);
                ATermAppl c2 = (ATermAppl)axiom.getArgument(1);
                boolean def = false;
                if (ATermUtils.isPrimitive(c1) && !this._unaryTbox.unfold(c1).hasNext() && !this._binaryTbox.unfold(c1).hasNext()) {
                    def = this._primitiveTbox.add(c1, c2, explanation);
                }
                if (!def && ATermUtils.isPrimitive(c2) && !this._unaryTbox.unfold(c2).hasNext() && !this._binaryTbox.unfold(c2).hasNext()) {
                    def = this._primitiveTbox.add(c2, c1, explanation);
                }
                if (!def) {
                    this.absorbSubClass(c1, c2, explanation);
                    this.absorbSubClass(c2, c1, explanation);
                }
            } else if (axiom.getAFun().equals(ATermUtils.SUBFUN)) {
                ATermAppl sub = (ATermAppl)axiom.getArgument(0);
                ATermAppl sup = (ATermAppl)axiom.getArgument(1);
                this.absorbSubClass(sub, sup, explanation);
            }
        }
        return added;
    }

    private void absorbSubClass(ATermAppl sub, ATermAppl sup, Set<ATermAppl> explanation) {
        _logger.fine(() -> "Absorb: subClassOf(" + ATermUtils.toString(sub) + ", " + ATermUtils.toString(sup) + ")");
        Set<ATermAppl> terms = SetUtils.create();
        terms.add(ATermUtils.nnf(sub));
        terms.add(ATermUtils.nnf(ATermUtils.negate(sup)));
        this.absorbAxiom(terms, SetUtils.create(explanation));
    }

    private void absorbAxiom(Set<ATermAppl> terms, Set<ATermAppl> explanation) {
        if (terms.size() == 1) {
            this._unaryTbox.add(TermFactory.TOP, TermFactory.not(terms.iterator().next()), explanation);
            return;
        }
        for (Absorption absorption : this.absorptions) {
            if (!absorption.absorb(terms, explanation)) continue;
            return;
        }
        throw new InternalReasonerException("Absorption failed");
    }

    private static ATermAppl disjunction(Set<ATermAppl> terms) {
        return TermFactory.not(TermFactory.and(terms.toArray(new ATermAppl[terms.size()])));
    }

    private ATermAppl freshConcept() {
        return TermFactory.term("_A" + ++this.freshConceptCount + "_");
    }

    @Override
    public boolean removeAxiom(ATermAppl axiom) {
        return this.removeAxiom(axiom, axiom);
    }

    @Override
    public boolean removeAxiom(ATermAppl dependantAxiom, ATermAppl explanationAxiom) {
        if (!OpenlletOptions.USE_TRACING) {
            _logger.fine("Cannot remove axioms when PelletOptions.USE_TRACING is false");
            return false;
        }
        if (this._absorbedAxioms.contains(dependantAxiom)) {
            _logger.fine("Cannot remove axioms that have been absorbed outside TBox");
            return false;
        }
        this._tboxAssertedAxioms.remove(dependantAxiom);
        HashSet<ATermAppl> sideEffects = new HashSet<ATermAppl>();
        boolean removed = this.removeExplanation(dependantAxiom, explanationAxiom, sideEffects);
        for (ATermAppl readdAxiom : sideEffects) {
            Set<Set<ATermAppl>> explanations = this._tboxAxioms.get(readdAxiom);
            if (explanations == null) continue;
            Iterator<Set<ATermAppl>> i = explanations.iterator();
            this.addAxiom(readdAxiom, i.next(), true);
            while (i.hasNext()) {
                this.addAxiomExplanation(readdAxiom, i.next());
            }
        }
        return removed;
    }

    private boolean removeExplanation(ATermAppl dependantAxiom, ATermAppl explanationAxiom, Set<ATermAppl> sideEffects) {
        Set<ATermAppl> otherDependants;
        boolean removed = false;
        if (!OpenlletOptions.USE_TRACING) {
            _logger.fine("Cannot remove axioms when PelletOptions.USE_TRACING is false");
            return false;
        }
        _logger.fine(() -> "Removing " + explanationAxiom);
        MultiMapUtils.remove(this._reverseExplain, explanationAxiom, dependantAxiom);
        Set<Set<ATermAppl>> explains = this._tboxAxioms.get(dependantAxiom);
        HashSet<Set<ATermAppl>> newExplains = new HashSet<Set<ATermAppl>>();
        if (explains != null) {
            for (Set<ATermAppl> explain : explains) {
                if (!explain.contains(explanationAxiom)) {
                    newExplains.add(explain);
                    continue;
                }
                sideEffects.addAll(explain);
                sideEffects.remove(explanationAxiom);
            }
        }
        if (!newExplains.isEmpty()) {
            this._tboxAxioms.put(dependantAxiom, newExplains);
            return true;
        }
        removed |= this._tboxAxioms.remove(dependantAxiom) != null;
        AFun fun = dependantAxiom.getAFun();
        if (fun.equals(ATermUtils.SUBFUN) || fun.equals(ATermUtils.EQCLASSFUN)) {
            // empty if block
        }
        if ((otherDependants = this._reverseExplain.remove(dependantAxiom)) != null) {
            for (ATermAppl otherDependant : otherDependants) {
                if (otherDependant.equals(dependantAxiom)) continue;
                removed |= this.removeExplanation(otherDependant, dependantAxiom, sideEffects);
            }
        }
        return removed;
    }

    @Override
    public Collection<ATermAppl> getAxioms() {
        return this._tboxAxioms.keySet();
    }

    @Override
    public Collection<ATermAppl> getAssertedAxioms() {
        return this._tboxAssertedAxioms;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.print(sb);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public void print(Appendable str) throws IOException {
        this._primitiveTbox.print(str);
        this._unaryTbox.print(str);
        this._binaryTbox.print(str);
        str.append("Explain: [\n");
        for (ATermAppl axiom : this._tboxAxioms.keySet()) {
            str.append(ATermUtils.toString(axiom));
            str.append(" -> ");
            str.append(this._tboxAxioms.get(axiom).toString());
            str.append("\n");
        }
        str.append("]\nReverseExplain: [\n");
        for (ATermAppl axiom : this._reverseExplain.keySet()) {
            str.append(ATermUtils.toString(axiom));
            str.append(" -> ");
            str.append(this._reverseExplain.get(axiom).toString());
            str.append("\n");
        }
        str.append("]\n");
    }

    @Override
    public boolean addClass(ATermAppl term) {
        boolean added = this._classes.add(term);
        if (added) {
            this._allClasses.clear();
        }
        return added;
    }

    @Override
    public Set<ATermAppl> getClasses() {
        return this._classes;
    }

    @Override
    public Collection<ATermAppl> getAxioms(ATermAppl term) {
        ArrayList<ATermAppl> axioms = new ArrayList<ATermAppl>();
        return axioms;
    }

    @Override
    public Iterator<Unfolding> unfold(ATermAppl c) {
        if (ATermUtils.isPrimitive(c)) {
            MultiIterator<Unfolding> result = new MultiIterator<Unfolding>(this._primitiveTbox.unfold(c));
            result.append(this._unaryTbox.unfold(c));
            result.append(this._binaryTbox.unfold(c));
            return result;
        }
        if (ATermUtils.isNot(c)) {
            return this._primitiveTbox.unfold(c);
        }
        return IteratorUtils.emptyIterator();
    }

    @Override
    public boolean isPrimitive(ATermAppl c) {
        return ATermUtils.isPrimitive(c) && !this._primitiveTbox.contains(c);
    }

    @Override
    public void prepare() {
    }

    static {
        FACETS.put(Facet.XSD.MIN_INCLUSIVE.getName(), "http://www.w3.org/2003/11/swrlb#greaterThanOrEqual");
        FACETS.put(Facet.XSD.MIN_EXCLUSIVE.getName(), "http://www.w3.org/2003/11/swrlb#greaterThan");
        FACETS.put(Facet.XSD.MAX_INCLUSIVE.getName(), "http://www.w3.org/2003/11/swrlb#lessThanOrEqual");
        FACETS.put(Facet.XSD.MAX_EXCLUSIVE.getName(), "http://www.w3.org/2003/11/swrlb#lessThan");
        SINGLE_EMPTY_SET = Collections.singleton(Collections.emptySet());
    }

    private class GeneralAbsorption
    implements Absorption {
        private GeneralAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> terms, Set<ATermAppl> explanation) {
            ATermAppl disjunction = TBoxImpl.disjunction(terms);
            TBoxImpl.this._unaryTbox.add(TermFactory.TOP, disjunction, explanation);
            return true;
        }
    }

    private class DomainAbsorption
    implements Absorption {
        private DomainAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> terms, Set<ATermAppl> explanation) {
            for (ATermAppl term : terms) {
                if (!ATermUtils.isSomeValues(term)) continue;
                ATermAppl p = (ATermAppl)term.getArgument(0);
                Role role = TBoxImpl.this._kb.getRole(p);
                if (role == null || role.hasComplexSubRole()) continue;
                ATermAppl disjunction = TBoxImpl.disjunction(terms);
                TBoxImpl.this._kb.addDomain(p, disjunction, explanation);
                _logger.fine(() -> "Add dom: " + ATermUtils.toString(p) + " " + ATermUtils.toString(disjunction));
                TBoxImpl.this._absorbedAxioms.addAll(explanation);
                return true;
            }
            return false;
        }
    }

    private class UnaryAbsorption
    extends AbstractUnaryAbsorption {
        private UnaryAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> terms, Set<ATermAppl> explanation) {
            for (ATermAppl term : terms) {
                if (!this.absorbIntoTerm(term, terms, explanation)) continue;
                return true;
            }
            return false;
        }
    }

    private class DeterministicUnaryAbsorption
    extends AbstractUnaryAbsorption {
        private DeterministicUnaryAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> terms, Set<ATermAppl> explanation) {
            if (terms.size() != 2) {
                return false;
            }
            Iterator<ATermAppl> i = terms.iterator();
            ATermAppl first = i.next();
            if (this.absorbIntoTerm(first, terms, explanation)) {
                return true;
            }
            ATermAppl second = i.next();
            return this.absorbIntoTerm(second, terms, explanation);
        }
    }

    private abstract class AbstractUnaryAbsorption
    implements Absorption {
        private AbstractUnaryAbsorption() {
        }

        protected boolean absorbIntoTerm(ATermAppl term, Set<ATermAppl> terms, Set<ATermAppl> explanation) {
            if (TBoxImpl.this.isPrimitive(term) && !TBoxImpl.this._primitiveTbox.contains(term)) {
                terms.remove(term);
                ATermAppl disjunction = TBoxImpl.disjunction(terms);
                TBoxImpl.this._unaryTbox.add(term, disjunction, explanation);
                return true;
            }
            return false;
        }
    }

    private class UnfoldAbsorption
    implements Absorption {
        private UnfoldAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> terms, Set<ATermAppl> explanation) {
            for (ATermAppl c : terms) {
                Unfolding unf = TBoxImpl.this._primitiveTbox.getDefinition(c);
                if (unf == null) continue;
                ATermAppl def = unf.getResult();
                terms.remove(c);
                terms.add(ATermUtils.nnf(def));
                TBoxImpl.this.absorbAxiom(terms, explanation);
                return true;
            }
            return false;
        }
    }

    private class ExistentialAbsorption
    implements Absorption {
        private ExistentialAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> terms, Set<ATermAppl> explanation) {
            for (ATermAppl term : terms) {
                if (!ATermUtils.isSomeValues(term)) continue;
                ATermAppl p = (ATermAppl)term.getArgument(0);
                ATermAppl c = (ATermAppl)term.getArgument(1);
                if (!TBoxImpl.this._kb.isObjectProperty(p)) continue;
                terms.remove(term);
                if (terms.size() == 1 && ATermUtils.isNegatedPrimitive(c) && ATermUtils.isNegatedPrimitive(terms.iterator().next())) {
                    terms.add(term);
                    return false;
                }
                ATermAppl a = TBoxImpl.this.freshConcept();
                terms.add(a);
                TBoxImpl.this.absorbAxiom(terms, explanation);
                Set newTerms = CollectionUtils.makeIdentitySet();
                newTerms.add(ATermUtils.nnf(c));
                newTerms.add(TermFactory.some(TermFactory.inv(p), TermFactory.not(a)));
                TBoxImpl.this.absorbAxiom(newTerms, explanation);
                return true;
            }
            return false;
        }
    }

    private class BinaryAbsorption
    implements Absorption {
        private boolean _deterministic = false;

        BinaryAbsorption(boolean deterministic) {
            this._deterministic = deterministic;
        }

        @Override
        public boolean absorb(Set<ATermAppl> terms, Set<ATermAppl> explanation) {
            if (!OpenlletOptions.USE_BINARY_ABSORPTION) {
                return false;
            }
            if (this._deterministic && terms.size() > 3) {
                return false;
            }
            Set candidates1 = CollectionUtils.makeIdentitySet();
            Set candidates2 = CollectionUtils.makeIdentitySet();
            for (ATermAppl term : terms) {
                if (!TBoxImpl.this.isPrimitive(term)) continue;
                if (!TBoxImpl.this._primitiveTbox.contains(term)) {
                    candidates1.add(term);
                    candidates2.add(term);
                }
                if (!TBoxImpl.this._binaryTbox.contains(term)) continue;
                candidates1.add(term);
            }
            if (candidates1.isEmpty()) {
                return false;
            }
            ATermAppl a1 = (ATermAppl)candidates1.iterator().next();
            candidates2.remove(a1);
            if (candidates2.isEmpty()) {
                return false;
            }
            ATermAppl a2 = (ATermAppl)candidates2.iterator().next();
            BinarySet<ATermAppl> set = BinarySet.create(a1, a2);
            Unfolding unfolding = TBoxImpl.this._binaryTbox.unfold(set);
            terms.remove(a1);
            terms.remove(a2);
            if (terms.size() == 0) {
                TBoxImpl.this._binaryTbox.add(set, TermFactory.BOTTOM, explanation);
            } else if (terms.size() == 1) {
                TBoxImpl.this._binaryTbox.add(set, ATermUtils.negate(terms.iterator().next()), explanation);
            } else {
                ATermAppl a = null;
                if (unfolding == null) {
                    a = TBoxImpl.this.freshConcept();
                    TBoxImpl.this._binaryTbox.add(set, a, explanation);
                } else {
                    a = unfolding.getResult();
                }
                terms.add(a);
                TBoxImpl.this.absorbAxiom(terms, explanation);
            }
            return true;
        }
    }

    private class RuleAbsorption
    implements Absorption {
        private RuleAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> terms, Set<ATermAppl> explanation) {
            if (!OpenlletOptions.USE_RULE_ABSORPTION) {
                return false;
            }
            int propertyAtoms = 0;
            int primitiveClassAtoms = 0;
            ATermAppl head = null;
            for (ATermAppl term : terms) {
                if (ATermUtils.isPrimitive(term) && !TBoxImpl.this._primitiveTbox.contains(term)) {
                    ++primitiveClassAtoms;
                    continue;
                }
                if (ATermUtils.isSomeValues(term)) {
                    ++propertyAtoms;
                    continue;
                }
                if (!ATermUtils.isNot(term)) continue;
                head = term;
            }
            if (head == null || propertyAtoms == 0 && primitiveClassAtoms < 2) {
                return false;
            }
            terms.remove(head);
            AtomIVariable var = new AtomIVariable("var");
            int varCount = 0;
            ArrayList<RuleAtom> bodyAtoms = new ArrayList<RuleAtom>();
            for (ATermAppl term : terms) {
                varCount = this.processClass(var, term, bodyAtoms, varCount);
            }
            ArrayList<RuleAtom> headAtoms = new ArrayList<RuleAtom>();
            this.processClass(var, ATermUtils.negate(head), headAtoms, 1);
            Rule rule = new Rule(headAtoms, bodyAtoms);
            TBoxImpl.this._kb.addRule(rule);
            _logger.fine(() -> "Add rule: " + rule);
            return true;
        }

        private int processClass(AtomIObject var, ATermAppl c, List<RuleAtom> atoms, int varCountInit) {
            int varCount = varCountInit;
            AFun afun = c.getAFun();
            if (afun.equals(ATermUtils.ANDFUN)) {
                for (ATerm term : (ATermList)c.getArgument(0)) {
                    ATermAppl conjunct = (ATermAppl)term;
                    varCount = this.processClass(var, conjunct, atoms, varCount);
                }
            } else if (afun.equals(ATermUtils.SOMEFUN)) {
                ATermAppl p = (ATermAppl)c.getArgument(0);
                ATermAppl filler = (ATermAppl)c.getArgument(1);
                if (filler.getAFun().equals(ATermUtils.VALUEFUN)) {
                    ATermAppl nominal = (ATermAppl)filler.getArgument(0);
                    if (TBoxImpl.this._kb.isDatatypeProperty(p)) {
                        AtomDConstant arg = new AtomDConstant(nominal);
                        DatavaluedPropertyAtom atom = new DatavaluedPropertyAtom(p, var, arg);
                        atoms.add(atom);
                    } else {
                        AtomIConstant arg = new AtomIConstant(nominal);
                        IndividualPropertyAtom atom = new IndividualPropertyAtom(p, var, arg);
                        atoms.add(atom);
                    }
                } else {
                    ++varCount;
                    if (TBoxImpl.this._kb.isDatatypeProperty(p)) {
                        AtomDVariable newVar = new AtomDVariable("var" + varCount);
                        DatavaluedPropertyAtom atom = new DatavaluedPropertyAtom(p, var, newVar);
                        atoms.add(atom);
                        this.processDatatype(newVar, filler, atoms);
                    } else {
                        AtomIVariable newVar = new AtomIVariable("var" + varCount);
                        IndividualPropertyAtom atom = new IndividualPropertyAtom(p, var, newVar);
                        atoms.add(atom);
                        varCount = this.processClass(newVar, filler, atoms, varCount);
                    }
                }
            } else if (!c.equals(ATermUtils.TOP)) {
                atoms.add(new ClassAtom(c, var));
            }
            return varCount;
        }

        private void processDatatype(AtomDObject var, ATermAppl c, List<RuleAtom> atoms) {
            AFun afun = c.getAFun();
            if (afun.equals(ATermUtils.ANDFUN)) {
                ATermList list = (ATermList)c.getArgument(0);
                while (!list.isEmpty()) {
                    ATermAppl conjunct = (ATermAppl)list.getFirst();
                    this.processDatatype(var, conjunct, atoms);
                    list = list.getNext();
                }
            } else if (afun.equals(ATermUtils.RESTRDATATYPEFUN)) {
                ATermAppl baseDatatype = (ATermAppl)c.getArgument(0);
                atoms.add(new DataRangeAtom(baseDatatype, var));
                ATermList list = (ATermList)c.getArgument(1);
                while (!list.isEmpty()) {
                    ATermAppl facetRestriction = (ATermAppl)list.getFirst();
                    ATermAppl facet = (ATermAppl)facetRestriction.getArgument(0);
                    String builtin = (String)FACETS.get(facet);
                    if (builtin == null) {
                        atoms.add(new DataRangeAtom(c, var));
                        return;
                    }
                    ATermAppl value = (ATermAppl)facetRestriction.getArgument(1);
                    atoms.add(new BuiltInAtom(builtin, var, new AtomDConstant(value)));
                    list = list.getNext();
                }
            } else {
                atoms.add(new DataRangeAtom(c, var));
            }
        }
    }

    private class HasValueAbsorption
    implements Absorption {
        private HasValueAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> terms, Set<ATermAppl> explanation) {
            if (!OpenlletOptions.USE_HASVALUE_ABSORPTION) {
                return false;
            }
            Iterator<ATermAppl> i = terms.iterator();
            while (i.hasNext()) {
                ATermAppl term = i.next();
                if (!ATermUtils.isHasValue(term)) continue;
                ATermAppl p = (ATermAppl)term.getArgument(0);
                if (!TBoxImpl.this._kb.isObjectProperty(p)) continue;
                i.remove();
                ATermAppl c = TBoxImpl.disjunction(terms);
                ATermAppl nominal = (ATermAppl)term.getArgument(1);
                ATermAppl ind = (ATermAppl)nominal.getArgument(0);
                ATermAppl invP = TBoxImpl.this._kb.getProperty(p).getInverse().getName();
                ATermAppl allInvPC = ATermUtils.makeAllValues(invP, c);
                _logger.finer(() -> "Absorb into " + ATermUtils.toString(ind) + " with inverse of " + ATermUtils.toString(p) + " for " + ATermUtils.toString(c));
                TBoxImpl.this._absorbedAxioms.addAll(explanation);
                TBoxImpl.this._kb.addIndividual(ind);
                TBoxImpl.this._kb.addType(ind, allInvPC, new DependencySet(explanation));
                return true;
            }
            return false;
        }
    }

    private class OneOfAbsorption
    implements Absorption {
        private OneOfAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> terms, Set<ATermAppl> explanation) {
            if (!OpenlletOptions.USE_NOMINAL_ABSORPTION) {
                return false;
            }
            for (ATermAppl term : terms) {
                Iterator<ATermAppl> nominals = this.getNominals(term);
                if (!nominals.hasNext()) continue;
                terms.remove(term);
                ATermAppl c = TBoxImpl.disjunction(terms);
                this.absorbOneOf(nominals, c, explanation);
                return true;
            }
            return false;
        }

        public Iterator<ATermAppl> getNominals(ATermAppl term) {
            if (ATermUtils.isOneOf(term)) {
                ATermList list = (ATermList)term.getArgument(0);
                return new MultiListIterator(list);
            }
            if (ATermUtils.isNominal(term)) {
                return IteratorUtils.singletonIterator(term);
            }
            return IteratorUtils.emptyIterator();
        }

        private void absorbOneOf(Iterator<ATermAppl> list, ATermAppl c, Set<ATermAppl> explain) {
            if (OpenlletOptions.USE_PSEUDO_NOMINALS) {
                _logger.warning(() -> "Ignoring axiom involving nominals: " + explain);
                return;
            }
            TBoxImpl.this._absorbedAxioms.addAll(explain);
            DependencySet ds = new DependencySet(explain);
            while (list.hasNext()) {
                ATermAppl nominal = list.next();
                ATermAppl ind = (ATermAppl)nominal.getArgument(0);
                _logger.fine(() -> "Absorb nominals: " + ATermUtils.toString(c) + " " + ind);
                TBoxImpl.this._kb.addIndividual(ind);
                TBoxImpl.this._kb.addType(ind, c, ds);
            }
        }
    }

    private class SimplifyAbsorption
    implements Absorption {
        private SimplifyAbsorption() {
        }

        @Override
        public boolean absorb(Set<ATermAppl> terms, Set<ATermAppl> explanation) {
            Iterator<ATermAppl> i = terms.iterator();
            while (i.hasNext()) {
                ATermAppl term = i.next();
                if (ATermUtils.isAnd(term)) {
                    i.remove();
                    ATermList list = (ATermList)term.getArgument(0);
                    while (!list.isEmpty()) {
                        terms.add((ATermAppl)list.getFirst());
                        list = list.getNext();
                    }
                    TBoxImpl.this.absorbAxiom(terms, explanation);
                    return true;
                }
                if (!ATermUtils.isOr(term)) continue;
                i.remove();
                ATermList list = (ATermList)term.getArgument(0);
                while (!list.isEmpty()) {
                    Set<ATermAppl> newTerms = SetUtils.create(terms);
                    newTerms.add((ATermAppl)list.getFirst());
                    TBoxImpl.this.absorbAxiom(newTerms, explanation);
                    list = list.getNext();
                }
                return true;
            }
            return false;
        }
    }

    private static interface Absorption {
        public boolean absorb(Set<ATermAppl> var1, Set<ATermAppl> var2);
    }
}

