/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.tbox.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.tbox.impl.TBoxBase;
import openllet.core.boxes.tbox.impl.TBoxExpImpl;
import openllet.core.boxes.tbox.impl.TermDefinition;
import openllet.core.boxes.tbox.impl.Unfolding;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.CollectionUtils;
import openllet.core.utils.IdentityHashSet;

public class TuBox
extends TBoxBase {
    private Map<ATermAppl, List<Unfolding>> _unfoldingMap;
    private Collection<ATermAppl> _termsToNormalize = null;

    public TuBox(TBoxExpImpl tbox) {
        super(tbox);
    }

    @Override
    public boolean addDef(ATermAppl axiom) {
        boolean added = false;
        ATermAppl name = (ATermAppl)axiom.getArgument(0);
        TermDefinition td = this.getTD(name);
        if (td == null) {
            td = new TermDefinition();
            this._termhash.put(name, td);
        }
        if ((added = td.addDef(axiom)) && this._termsToNormalize != null) {
            this._termsToNormalize.add(name);
        }
        return added;
    }

    @Override
    public boolean removeDef(ATermAppl axiom) {
        boolean removed = super.removeDef(axiom);
        if (removed && this._termsToNormalize != null) {
            this._termsToNormalize.add((ATermAppl)axiom.getArgument(0));
        }
        return removed;
    }

    public void updateDef(ATermAppl axiom) {
        ATermAppl c = (ATermAppl)axiom.getArgument(0);
        if (ATermUtils.isPrimitive(c)) {
            this._termsToNormalize.add(c);
        }
    }

    public List<Unfolding> unfold(ATermAppl c) {
        List<Unfolding> list = this._unfoldingMap.get(c);
        return list != null ? list : Collections.emptyList();
    }

    public void normalize() {
        if (this._termsToNormalize == null) {
            this._termsToNormalize = this._termhash.keySet();
            this._unfoldingMap = CollectionUtils.makeIdentityMap();
        }
        _logger.fine(() -> "Normalizing " + this._termsToNormalize);
        for (ATermAppl c : this._termsToNormalize) {
            TermDefinition td = this.getTD(c);
            if (null == td) {
                _logger.severe(() -> "While normalizing the TuBox " + c + " has no TermDefinition but was still declare in termsToNormalize");
                continue;
            }
            td.clearDependencies();
            ATermAppl notC = ATermUtils.makeNot(c);
            ArrayList<Unfolding> unfoldC = new ArrayList<Unfolding>();
            if (!td.getEqClassAxioms().isEmpty()) {
                ArrayList<Unfolding> unfoldNotC = new ArrayList<Unfolding>();
                for (ATermAppl eqClassAxiom : td.getEqClassAxioms()) {
                    ATermAppl unfolded = (ATermAppl)eqClassAxiom.getArgument(1);
                    Set<ATermAppl> ds = this._tbox.getAxiomExplanation(eqClassAxiom);
                    ATermAppl normalized = ATermUtils.normalize(unfolded);
                    ATermAppl normalizedNot = ATermUtils.negate(normalized);
                    unfoldC.add(Unfolding.create(normalized, ds));
                    unfoldNotC.add(Unfolding.create(normalizedNot, ds));
                }
                this._unfoldingMap.put(notC, unfoldNotC);
            } else {
                this._unfoldingMap.remove(notC);
            }
            for (ATermAppl subClassAxiom : td.getSubClassAxioms()) {
                ATermAppl unfolded = (ATermAppl)subClassAxiom.getArgument(1);
                Set<ATermAppl> ds = this._tbox.getAxiomExplanation(subClassAxiom);
                ATermAppl normalized = ATermUtils.normalize(unfolded);
                unfoldC.add(Unfolding.create(normalized, ds));
            }
            if (!unfoldC.isEmpty()) {
                this._unfoldingMap.put(c, unfoldC);
                continue;
            }
            this._unfoldingMap.remove(c);
        }
        this._termsToNormalize = new HashSet<ATermAppl>();
        if (OpenlletOptions.USE_ROLE_ABSORPTION) {
            this.absorbRanges(this._tbox);
        }
    }

    private void absorbRanges(TBoxExpImpl tbox) {
        List<Unfolding> unfoldTop = this._unfoldingMap.get(ATermUtils.TOP);
        if (unfoldTop == null) {
            return;
        }
        ArrayList<Unfolding> newUnfoldTop = new ArrayList<Unfolding>();
        for (Unfolding unfolding : unfoldTop) {
            ATermAppl unfolded = unfolding.getResult();
            Set<ATermAppl> explain = unfolding.getExplanation();
            if (ATermUtils.isAllValues(unfolded)) {
                ATerm r = unfolded.getArgument(0);
                ATermAppl range = (ATermAppl)unfolded.getArgument(1);
                this._kb.addRange(r, range, explain);
                tbox.getAbsorbedAxioms().addAll(explain);
                continue;
            }
            if (ATermUtils.isAnd(unfolded)) {
                ATermList l = (ATermList)unfolded.getArgument(0);
                ATermList newList = ATermUtils.EMPTY_LIST;
                while (!l.isEmpty()) {
                    ATermAppl term = (ATermAppl)l.getFirst();
                    if (term.getAFun().equals(ATermUtils.ALLFUN)) {
                        ATerm r = term.getArgument(0);
                        ATermAppl range = (ATermAppl)term.getArgument(1);
                        this._kb.addRange(r, range, explain);
                        tbox.getAbsorbedAxioms().addAll(explain);
                    } else {
                        newList = newList.insert(term);
                    }
                    l = l.getNext();
                }
                if (newList.isEmpty()) continue;
                newUnfoldTop.add(Unfolding.create(ATermUtils.makeAnd(newList), explain));
                continue;
            }
            newUnfoldTop.add(unfolding);
        }
        if (newUnfoldTop.isEmpty()) {
            this._unfoldingMap.remove(ATermUtils.TOP);
        }
    }

    public boolean addIfUnfoldable(ATermAppl term) {
        Set<ATermAppl> bodyDependencies;
        ATermAppl name = (ATermAppl)term.getArgument(0);
        if (!ATermUtils.isPrimitive(name)) {
            return false;
        }
        TermDefinition td = this.getTD(name);
        if (td == null) {
            td = new TermDefinition();
        }
        if (!td.isUnique(term)) {
            return false;
        }
        ATermAppl body = (ATermAppl)term.getArgument(1);
        Set<ATermAppl> nameDependencies = td.getDependencies();
        if (!nameDependencies.containsAll(bodyDependencies = ATermUtils.findPrimitives(body))) {
            IdentityHashSet<ATermAppl> seen = new IdentityHashSet<ATermAppl>();
            for (ATermAppl current : bodyDependencies) {
                if (!this.findTarget(current, name, seen)) continue;
                return false;
            }
        }
        return this.addDef(term);
    }

    protected boolean findTarget(ATermAppl term, ATermAppl target, Set<ATermAppl> seen) {
        ArrayList<ATermAppl> queue = new ArrayList<ATermAppl>();
        queue.add(term);
        while (!queue.isEmpty()) {
            this._kb.getTimers().checkTimer("preprocessing");
            ATermAppl current = (ATermAppl)queue.remove(queue.size() - 1);
            if (!seen.add(current)) continue;
            if (current.equals(target)) {
                return true;
            }
            TermDefinition td = this.getTD(current);
            if (td == null) continue;
            if (td.getDependencies().contains(target)) {
                return true;
            }
            queue.addAll(td.getDependencies());
        }
        return false;
    }

    public void print(Appendable out) {
        try {
            out.append("Tu: [\n");
            for (ATermAppl c : this._unfoldingMap.keySet()) {
                List<Unfolding> unfoldedList = this.unfold(c);
                if (unfoldedList.isEmpty()) continue;
                out.append(ATermUtils.toString(c)).append(" -> ");
                for (Unfolding unf : unfoldedList) {
                    out.append(ATermUtils.toString(unf.getResult())).append(", ");
                }
                out.append("\n");
            }
            out.append("]\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.print(sb);
        return sb.toString();
    }
}

