/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.tbox.impl;

import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.core.utils.ATermUtils;

public abstract class Unfolding {
    public abstract ATermAppl getCondition();

    public abstract Set<ATermAppl> getExplanation();

    public abstract ATermAppl getResult();

    public static Unfolding create(ATermAppl result, Set<ATermAppl> explanation) {
        return new Unconditional(result, explanation);
    }

    public static Unfolding create(ATermAppl result, ATermAppl condition, Set<ATermAppl> explanation) {
        return new Conditional(result, condition, explanation);
    }

    private static class Conditional
    extends Unconditional {
        private final ATermAppl _condition;

        private Conditional(ATermAppl result, ATermAppl condition, Set<ATermAppl> explanation) {
            super(result, explanation);
            this._condition = condition;
        }

        @Override
        public ATermAppl getCondition() {
            return this._condition;
        }

        @Override
        public String toString() {
            return ATermUtils.toString(this._condition) + " ? " + ATermUtils.toString(this.getResult());
        }
    }

    private static class Unconditional
    extends Unfolding {
        private final ATermAppl _result;
        private final Set<ATermAppl> _explanation;

        private Unconditional(ATermAppl result, Set<ATermAppl> explanation) {
            this._result = result;
            this._explanation = explanation;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Unfolding)) {
                return false;
            }
            Unconditional other = (Unconditional)obj;
            return this.getCondition().equals(other.getCondition()) && this._explanation.equals(other._explanation) && this._result.equals(other._result);
        }

        @Override
        public ATermAppl getCondition() {
            return ATermUtils.TOP;
        }

        @Override
        public Set<ATermAppl> getExplanation() {
            return this._explanation;
        }

        @Override
        public ATermAppl getResult() {
            return this._result;
        }

        public int hashCode() {
            int prime = 31;
            int hashCode = 1;
            hashCode = 31 * hashCode + this.getCondition().hashCode();
            hashCode = 31 * hashCode + this._explanation.hashCode();
            hashCode = 31 * hashCode + this._result.hashCode();
            return hashCode;
        }

        public String toString() {
            return ATermUtils.toString(this._result);
        }
    }
}

