/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import openllet.core.datatypes.IntervalRelations;
import openllet.core.datatypes.OWLRealUtils;
import openllet.shared.tools.Log;

public class OWLRealInterval {
    private static final Logger _logger = Log.getLogger(OWLRealInterval.class);
    private static OWLRealInterval _unconstrainedInteger = new OWLRealInterval(null, null, true, true, LineType.INTEGER_ONLY);
    private static OWLRealInterval _unconstrainedReal = new OWLRealInterval(null, null, true, true, LineType.CONTINUOUS);
    private final boolean _finite;
    private final boolean _inclusiveLower;
    private final boolean _inclusiveUpper;
    private final Number _lower;
    private final boolean _point;
    private final LineType _type;
    private final Number _upper;

    public static OWLRealInterval allIntegers() {
        return _unconstrainedInteger;
    }

    public static OWLRealInterval allReals() {
        return _unconstrainedReal;
    }

    private static IntervalRelations compare(OWLRealInterval a, OWLRealInterval b) {
        int ll = OWLRealInterval.compareLowerLower(a, b);
        if (ll < 0) {
            int ul = OWLRealInterval.compareUpperLower(a, b);
            if (ul < 0) {
                return IntervalRelations.PRECEDES;
            }
            if (ul == 0) {
                if (a.inclusiveUpper()) {
                    if (b.inclusiveLower()) {
                        return IntervalRelations.OVERLAPS;
                    }
                    return IntervalRelations.MEETS;
                }
                if (b.inclusiveLower()) {
                    return IntervalRelations.MEETS;
                }
                return IntervalRelations.PRECEDES;
            }
            int uu = OWLRealInterval.compareUpperUpper(a, b);
            if (uu < 0) {
                return IntervalRelations.OVERLAPS;
            }
            if (uu == 0) {
                return IntervalRelations.FINISHED_BY;
            }
            return IntervalRelations.CONTAINS;
        }
        if (ll == 0) {
            int uu = OWLRealInterval.compareUpperUpper(a, b);
            if (uu < 0) {
                return IntervalRelations.STARTS;
            }
            if (uu == 0) {
                return IntervalRelations.EQUALS;
            }
            return IntervalRelations.STARTED_BY;
        }
        int lu = -OWLRealInterval.compareUpperLower(b, a);
        if (lu < 0) {
            int uu = OWLRealInterval.compareUpperUpper(a, b);
            if (uu < 0) {
                return IntervalRelations.DURING;
            }
            if (uu == 0) {
                return IntervalRelations.FINISHES;
            }
            return IntervalRelations.OVERLAPPED_BY;
        }
        if (lu == 0) {
            if (b.inclusiveUpper()) {
                if (a.inclusiveLower()) {
                    return IntervalRelations.OVERLAPPED_BY;
                }
                return IntervalRelations.MET_BY;
            }
            if (a.inclusiveLower()) {
                return IntervalRelations.MET_BY;
            }
            return IntervalRelations.PRECEDED_BY;
        }
        return IntervalRelations.PRECEDED_BY;
    }

    private static int compareLowerLower(OWLRealInterval a, OWLRealInterval other) {
        int ll;
        if (!a.boundLower()) {
            ll = !other.boundLower() ? 0 : -1;
        } else if (!other.boundLower()) {
            ll = 1;
        } else {
            ll = OWLRealUtils.compare(a.getLower(), other.getLower());
            if (ll == 0) {
                if (a.inclusiveLower()) {
                    if (!other.inclusiveLower()) {
                        ll = -1;
                    }
                } else if (other.inclusiveLower()) {
                    ll = 1;
                }
            }
        }
        return ll;
    }

    private static int compareUpperLower(OWLRealInterval a, OWLRealInterval b) {
        int ul = !a.boundUpper() ? 1 : (!b.boundLower() ? 1 : OWLRealUtils.compare(a.getUpper(), b.getLower()));
        return ul;
    }

    private static int compareUpperUpper(OWLRealInterval a, OWLRealInterval b) {
        int uu;
        if (!a.boundUpper()) {
            uu = !b.boundUpper() ? 0 : 1;
        } else if (!b.boundUpper()) {
            uu = -1;
        } else {
            uu = OWLRealUtils.compare(a.getUpper(), b.getUpper());
            if (uu == 0) {
                if (a.inclusiveUpper()) {
                    if (!b.inclusiveUpper()) {
                        uu = 1;
                    }
                } else if (b.inclusiveUpper()) {
                    uu = -1;
                }
            }
        }
        return uu;
    }

    public OWLRealInterval(Number point) {
        this._lower = point;
        this._upper = point;
        this._point = true;
        this._inclusiveLower = true;
        this._inclusiveUpper = true;
        this._type = LineType.CONTINUOUS;
        this._finite = true;
    }

    public OWLRealInterval(Number lower, Number upper, boolean inclusiveLower, boolean inclusiveUpper, LineType baseType) {
        LineType type = baseType;
        if (lower != null && upper != null) {
            int cmp = OWLRealUtils.compare(lower, upper);
            if (cmp > 0) {
                String msg = String.format("Lower bound of interval (%s) should not be greater than _upper bound of interval (%s)", lower, upper);
                _logger.severe(msg);
                throw new IllegalArgumentException(msg);
            }
            if (cmp == 0) {
                if (!inclusiveLower || !inclusiveUpper) {
                    String msg = "Point intervals must be inclusive";
                    _logger.severe("Point intervals must be inclusive");
                    throw new IllegalArgumentException("Point intervals must be inclusive");
                }
                type = LineType.CONTINUOUS;
            }
        }
        this._type = type;
        if (LineType.INTEGER_ONLY.equals((Object)type)) {
            if (lower == null) {
                this._lower = null;
                this._inclusiveLower = false;
            } else {
                this._lower = inclusiveLower ? (Number)(OWLRealUtils.isInteger(lower) ? (Number)lower : (Number)OWLRealUtils.roundDown(lower)) : (Number)(OWLRealUtils.isInteger(lower) ? (Number)OWLRealUtils.integerIncrement(lower) : (Number)OWLRealUtils.roundDown(lower));
                this._inclusiveLower = true;
            }
            if (upper == null) {
                this._upper = null;
                this._inclusiveUpper = false;
            } else {
                this._upper = inclusiveUpper ? (Number)(OWLRealUtils.isInteger(upper) ? (Number)upper : (Number)OWLRealUtils.roundDown(upper)) : (Number)(OWLRealUtils.isInteger(upper) ? (Number)OWLRealUtils.integerDecrement(upper) : (Number)OWLRealUtils.roundDown(upper));
                this._inclusiveUpper = true;
            }
        } else if (LineType.INTEGER_EXCLUDED.equals((Object)type)) {
            if (lower == null) {
                this._lower = null;
                this._inclusiveLower = false;
            } else {
                this._lower = lower;
                this._inclusiveLower = inclusiveLower ? !OWLRealUtils.isInteger(lower) : false;
            }
            if (upper == null) {
                this._upper = null;
                this._inclusiveUpper = false;
            } else {
                this._upper = upper;
                this._inclusiveUpper = inclusiveUpper ? !OWLRealUtils.isInteger(upper) : false;
            }
        } else {
            this._lower = lower;
            this._upper = upper;
            this._inclusiveLower = lower == null ? false : inclusiveLower;
            this._inclusiveUpper = upper == null ? false : inclusiveUpper;
        }
        this._point = lower != null && upper != null && lower.equals(upper);
        this._finite = this._point || LineType.INTEGER_ONLY.equals((Object)type) && lower != null && upper != null;
    }

    public boolean boundLower() {
        return this._lower != null;
    }

    public boolean boundUpper() {
        return this._upper != null;
    }

    public IntervalRelations compare(OWLRealInterval other) {
        return OWLRealInterval.compare(this, other);
    }

    public boolean contains(Number n) {
        int comp;
        if (this._type.equals((Object)LineType.INTEGER_ONLY) ? !OWLRealUtils.isInteger(n) : this._type.equals((Object)LineType.INTEGER_EXCLUDED) && OWLRealUtils.isInteger(n)) {
            return false;
        }
        if (this.boundLower()) {
            comp = OWLRealUtils.compare(this.getLower(), n);
            if (comp > 0) {
                return false;
            }
            if (comp == 0 && !this.inclusiveLower()) {
                return false;
            }
        }
        if (this.boundUpper()) {
            comp = OWLRealUtils.compare(this.getUpper(), n);
            if (comp < 0) {
                return false;
            }
            if (comp == 0 && !this.inclusiveUpper()) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OWLRealInterval other = (OWLRealInterval)obj;
        if (this._inclusiveLower != other._inclusiveLower) {
            return false;
        }
        if (this._inclusiveUpper != other._inclusiveUpper) {
            return false;
        }
        if (this._lower == null ? other._lower != null : OWLRealUtils.compare(this._lower, other._lower) != 0) {
            return false;
        }
        if (this._type == null ? other._type != null : !this._type.equals((Object)other._type)) {
            return false;
        }
        return !(this._upper == null ? other._upper != null : OWLRealUtils.compare(this._upper, other._upper) != 0);
    }

    public Number getLower() {
        return this._lower;
    }

    public LineType getType() {
        return this._type;
    }

    public Number getUpper() {
        return this._upper;
    }

    public OWLRealInterval greater(Number n) {
        if (this.boundLower() && OWLRealUtils.compare(n, this.getLower()) < 0) {
            return this;
        }
        if (this.boundUpper() && OWLRealUtils.compare(n, this.getUpper()) >= 0) {
            return null;
        }
        return new OWLRealInterval(n, this.getUpper(), false, this.inclusiveUpper(), this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._inclusiveLower ? 1231 : 1237);
        result = 31 * result + (this._inclusiveUpper ? 1231 : 1237);
        result = 31 * result + (this._lower == null ? 0 : this._lower.hashCode());
        result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
        result = 31 * result + (this._upper == null ? 0 : this._upper.hashCode());
        return result;
    }

    public boolean inclusiveLower() {
        return this._inclusiveLower;
    }

    public boolean inclusiveUpper() {
        return this._inclusiveUpper;
    }

    public OWLRealInterval intersection(OWLRealInterval that) {
        boolean inclusiveUpper;
        Number upper;
        boolean inclusiveLower;
        Number lower;
        LineType intersectionType = this._type.intersect(that._type);
        if (intersectionType == null) {
            return null;
        }
        switch (this.compare(that)) {
            case CONTAINS: 
            case STARTED_BY: {
                if (intersectionType.equals((Object)that._type)) {
                    return that;
                }
                lower = that.getLower();
                inclusiveLower = that.inclusiveLower();
                upper = that.getUpper();
                inclusiveUpper = that.inclusiveUpper();
                break;
            }
            case EQUALS: {
                if (intersectionType.equals((Object)this._type)) {
                    return this;
                }
                if (intersectionType.equals((Object)this._type)) {
                    return that;
                }
                lower = this.getLower();
                inclusiveLower = this.inclusiveLower();
                upper = this.getUpper();
                inclusiveUpper = this.inclusiveUpper();
                break;
            }
            case DURING: 
            case STARTS: {
                if (intersectionType.equals((Object)this._type)) {
                    return this;
                }
                lower = this.getLower();
                inclusiveLower = this.inclusiveLower();
                upper = this.getUpper();
                inclusiveUpper = this.inclusiveUpper();
                break;
            }
            case FINISHED_BY: {
                lower = that.getLower();
                inclusiveLower = that.inclusiveLower();
                upper = that.getUpper();
                inclusiveUpper = this.inclusiveUpper() && that.inclusiveUpper();
                break;
            }
            case FINISHES: {
                lower = this.getLower();
                inclusiveLower = this.inclusiveLower();
                upper = this.getUpper();
                inclusiveUpper = this.inclusiveUpper() && that.inclusiveUpper();
                break;
            }
            case MEETS: 
            case MET_BY: {
                return null;
            }
            case OVERLAPPED_BY: {
                lower = this.getLower();
                inclusiveLower = this.inclusiveLower();
                upper = that.getUpper();
                inclusiveUpper = that.inclusiveUpper();
                break;
            }
            case OVERLAPS: {
                lower = that.getLower();
                inclusiveLower = that.inclusiveLower();
                upper = this.getUpper();
                inclusiveUpper = this.inclusiveUpper();
                break;
            }
            case PRECEDED_BY: 
            case PRECEDES: {
                return null;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (LineType.INTEGER_ONLY.equals((Object)intersectionType)) {
            boolean change = false;
            if (lower != null) {
                if (OWLRealUtils.isInteger(lower)) {
                    if (!inclusiveLower) {
                        lower = OWLRealUtils.integerIncrement(lower);
                        inclusiveLower = true;
                        change = true;
                    }
                } else {
                    lower = OWLRealUtils.roundDown(lower);
                    inclusiveLower = true;
                    change = true;
                }
            }
            if (upper != null) {
                if (OWLRealUtils.isInteger(upper)) {
                    if (!inclusiveUpper) {
                        upper = OWLRealUtils.integerDecrement(upper);
                        inclusiveUpper = true;
                        change = true;
                    }
                } else {
                    upper = OWLRealUtils.roundDown(upper);
                    inclusiveUpper = true;
                    change = true;
                }
            }
            if (change && lower != null && upper != null && OWLRealUtils.compare(lower, upper) > 0) {
                return null;
            }
        } else if (LineType.INTEGER_EXCLUDED.equals((Object)intersectionType) && lower != null && upper != null && lower.equals(upper) && OWLRealUtils.isInteger(lower)) {
            return null;
        }
        return new OWLRealInterval(lower, upper, inclusiveLower, inclusiveUpper, intersectionType);
    }

    public boolean isFinite() {
        return this._finite;
    }

    public boolean isPoint() {
        return this._point;
    }

    public OWLRealInterval less(Number n) {
        if (this.boundUpper() && OWLRealUtils.compare(n, this.getUpper()) > 0) {
            return this;
        }
        if (this.boundLower() && OWLRealUtils.compare(n, this.getLower()) <= 0) {
            return null;
        }
        return new OWLRealInterval(this.getLower(), n, this.inclusiveLower(), false, this.getType());
    }

    public List<OWLRealInterval> remove(OWLRealInterval other) {
        OWLRealInterval after;
        OWLRealInterval during;
        OWLRealInterval before;
        LineType t1 = this.getType();
        LineType t2 = other.getType();
        if (LineType.INTEGER_ONLY.equals((Object)t1) ? LineType.INTEGER_EXCLUDED.equals((Object)t2) : LineType.INTEGER_EXCLUDED.equals((Object)t1) && LineType.INTEGER_ONLY.equals((Object)t2)) {
            return Collections.singletonList(this);
        }
        switch (this.compare(other)) {
            case CONTAINS: {
                before = new OWLRealInterval(this.getLower(), other.getLower(), this.inclusiveLower(), !other.inclusiveLower(), t1);
                during = t1.equals((Object)t2) || LineType.CONTINUOUS.equals((Object)t2) ? null : new OWLRealInterval(other.getLower(), other.getUpper(), false, false, LineType.INTEGER_EXCLUDED.equals((Object)t2) ? LineType.INTEGER_ONLY : LineType.INTEGER_EXCLUDED);
                after = new OWLRealInterval(other.getUpper(), this.getUpper(), !other.inclusiveUpper(), this.inclusiveUpper(), t1);
                break;
            }
            case EQUALS: 
            case DURING: 
            case STARTS: 
            case FINISHES: {
                before = null;
                during = t1.equals((Object)t2) || LineType.CONTINUOUS.equals((Object)t2) ? null : new OWLRealInterval(this.getLower(), this.getUpper(), false, false, LineType.INTEGER_EXCLUDED.equals((Object)t2) ? LineType.INTEGER_ONLY : LineType.INTEGER_EXCLUDED);
                after = null;
                break;
            }
            case FINISHED_BY: {
                before = new OWLRealInterval(this.getLower(), other.getLower(), this.inclusiveLower(), !other.inclusiveLower(), t1);
                during = t1.equals((Object)t2) || LineType.CONTINUOUS.equals((Object)t2) ? null : new OWLRealInterval(other.getLower(), this.getUpper(), false, false, LineType.INTEGER_EXCLUDED.equals((Object)t2) ? LineType.INTEGER_ONLY : LineType.INTEGER_EXCLUDED);
                after = null;
                break;
            }
            case MEETS: {
                before = new OWLRealInterval(this.getLower(), this.getUpper(), this.inclusiveLower(), false, t1);
                during = null;
                after = null;
                break;
            }
            case MET_BY: {
                before = null;
                during = null;
                after = new OWLRealInterval(this.getLower(), this.getUpper(), false, this.inclusiveUpper(), t1);
                break;
            }
            case STARTED_BY: 
            case OVERLAPPED_BY: {
                before = null;
                during = t1.equals((Object)t2) || LineType.CONTINUOUS.equals((Object)t2) ? null : new OWLRealInterval(this.getLower(), other.getUpper(), false, false, LineType.INTEGER_EXCLUDED.equals((Object)t2) ? LineType.INTEGER_ONLY : LineType.INTEGER_EXCLUDED);
                after = new OWLRealInterval(other.getUpper(), this.getUpper(), !other.inclusiveUpper(), this.inclusiveUpper(), t1);
                break;
            }
            case OVERLAPS: {
                before = new OWLRealInterval(this.getLower(), other.getLower(), this.inclusiveLower(), !other.inclusiveLower(), t1);
                during = t1.equals((Object)t2) || LineType.CONTINUOUS.equals((Object)t2) ? null : new OWLRealInterval(other.getLower(), this.getUpper(), false, false, LineType.INTEGER_EXCLUDED.equals((Object)t2) ? LineType.INTEGER_ONLY : LineType.INTEGER_EXCLUDED);
                after = null;
                break;
            }
            case PRECEDED_BY: 
            case PRECEDES: {
                return Collections.singletonList(this);
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ArrayList<OWLRealInterval> ret = new ArrayList<OWLRealInterval>();
        if (before != null) {
            ret.add(before);
        }
        if (during != null) {
            ret.add(during);
        }
        if (after != null) {
            ret.add(after);
        }
        return ret;
    }

    public Number size() {
        if (!this._finite) {
            throw new IllegalStateException();
        }
        if (this._point) {
            return 1;
        }
        return OWLRealUtils.integerIncrement(OWLRealUtils.integerDifference(this._upper, this._lower));
    }

    public String toString() {
        Object[] objectArray = new Object[5];
        objectArray[0] = this.inclusiveLower() ? "[" : "(";
        objectArray[1] = this.boundLower() ? this.getLower() : "-Inf";
        objectArray[2] = this.boundUpper() ? this.getUpper() : "+Inf";
        Object object = objectArray[3] = this.inclusiveUpper() ? "]" : ")";
        objectArray[4] = this._type.equals((Object)LineType.CONTINUOUS) ? "" : (this._type.equals((Object)LineType.INTEGER_ONLY) ? "{int}" : "{noint}");
        return String.format("%s%s,%s%s%s", objectArray);
    }

    public List<OWLRealInterval> union(OWLRealInterval other) {
        OWLRealInterval after;
        OWLRealInterval during;
        OWLRealInterval before;
        LineType t1 = this.getType();
        LineType t2 = other.getType();
        switch (this.compare(other)) {
            case CONTAINS: {
                if (LineType.CONTINUOUS.equals((Object)t1) || t1.equals((Object)t2)) {
                    return Collections.singletonList(this);
                }
                before = new OWLRealInterval(this.getLower(), other.getLower(), this.inclusiveLower(), !other.inclusiveLower(), t1);
                during = LineType.CONTINUOUS.equals((Object)t2) ? other : new OWLRealInterval(other.getLower(), other.getUpper(), other.inclusiveLower(), other.inclusiveUpper(), LineType.CONTINUOUS);
                after = new OWLRealInterval(other.getUpper(), this.getUpper(), !other.inclusiveUpper(), this.inclusiveUpper(), t1);
                break;
            }
            case DURING: {
                if (LineType.CONTINUOUS.equals((Object)t2) || t1.equals((Object)t2)) {
                    return Collections.singletonList(other);
                }
                before = new OWLRealInterval(other.getLower(), this.getLower(), other.inclusiveLower(), !this.inclusiveLower(), t2);
                during = LineType.CONTINUOUS.equals((Object)t1) ? this : new OWLRealInterval(this.getLower(), this.getUpper(), this.inclusiveLower(), this.inclusiveUpper(), LineType.CONTINUOUS);
                after = new OWLRealInterval(this.getUpper(), other.getUpper(), !this.inclusiveUpper(), other.inclusiveUpper(), t2);
                break;
            }
            case EQUALS: {
                if (LineType.CONTINUOUS.equals((Object)t1) || t1.equals((Object)t2)) {
                    return Collections.singletonList(this);
                }
                if (LineType.CONTINUOUS.equals((Object)t2)) {
                    return Collections.singletonList(other);
                }
                before = null;
                during = new OWLRealInterval(this.getLower(), this.getUpper(), this.inclusiveLower(), this.inclusiveUpper(), LineType.CONTINUOUS);
                after = null;
                break;
            }
            case FINISHED_BY: {
                if (LineType.CONTINUOUS.equals((Object)t1) || t1.equals((Object)t2)) {
                    return Collections.singletonList(this);
                }
                before = new OWLRealInterval(this.getLower(), other.getLower(), this.inclusiveLower(), !other.inclusiveLower(), t1);
                during = LineType.CONTINUOUS.equals((Object)t2) ? other : new OWLRealInterval(other.getLower(), this.getUpper(), other.inclusiveLower(), this.inclusiveUpper(), LineType.CONTINUOUS);
                after = null;
                break;
            }
            case FINISHES: {
                if (LineType.CONTINUOUS.equals((Object)t2) || t1.equals((Object)t2)) {
                    return Collections.singletonList(other);
                }
                before = new OWLRealInterval(other.getLower(), this.getLower(), other.inclusiveLower(), !this.inclusiveLower(), t2);
                during = LineType.CONTINUOUS.equals((Object)t1) ? this : new OWLRealInterval(this.getLower(), this.getUpper(), this.inclusiveLower(), this.inclusiveUpper(), LineType.CONTINUOUS);
                after = null;
                break;
            }
            case MEETS: {
                if (t1.equals((Object)t2)) {
                    return Collections.singletonList(new OWLRealInterval(this.getLower(), other.getUpper(), this.inclusiveLower(), other.inclusiveUpper(), t1));
                }
                return Arrays.asList(this, other);
            }
            case MET_BY: {
                if (t1.equals((Object)t2)) {
                    return Collections.singletonList(new OWLRealInterval(other.getLower(), this.getUpper(), other.inclusiveLower(), this.inclusiveUpper(), t1));
                }
                return Arrays.asList(other, this);
            }
            case OVERLAPPED_BY: {
                if (t1.equals((Object)t2)) {
                    return Collections.singletonList(new OWLRealInterval(other.getLower(), this.getUpper(), other.inclusiveLower(), this.inclusiveUpper(), t1));
                }
                if (LineType.CONTINUOUS.equals((Object)t2)) {
                    before = other;
                    during = null;
                    after = new OWLRealInterval(other.getUpper(), this.getUpper(), !other.inclusiveUpper(), this.inclusiveUpper(), t1);
                    break;
                }
                if (LineType.CONTINUOUS.equals((Object)t1)) {
                    before = new OWLRealInterval(other.getLower(), this.getLower(), other.inclusiveLower(), !this.inclusiveLower(), t2);
                    during = null;
                    after = this;
                    break;
                }
                before = new OWLRealInterval(other.getLower(), this.getLower(), other.inclusiveLower(), !this.inclusiveLower(), t2);
                during = new OWLRealInterval(this.getLower(), other.getUpper(), this.inclusiveLower(), other.inclusiveUpper(), LineType.CONTINUOUS);
                after = new OWLRealInterval(other.getUpper(), this.getUpper(), !other.inclusiveUpper(), this.inclusiveUpper(), t1);
                break;
            }
            case OVERLAPS: {
                if (t1.equals((Object)t2)) {
                    return Collections.singletonList(new OWLRealInterval(this.getLower(), other.getUpper(), this.inclusiveLower(), other.inclusiveUpper(), t1));
                }
                if (LineType.CONTINUOUS.equals((Object)t1)) {
                    before = this;
                    during = null;
                    after = new OWLRealInterval(this.getUpper(), other.getUpper(), !this.inclusiveUpper(), other.inclusiveUpper(), t2);
                    break;
                }
                if (LineType.CONTINUOUS.equals((Object)t2)) {
                    before = new OWLRealInterval(this.getLower(), other.getLower(), this.inclusiveLower(), !other.inclusiveLower(), t1);
                    during = null;
                    after = other;
                    break;
                }
                before = new OWLRealInterval(this.getLower(), other.getLower(), this.inclusiveLower(), !other.inclusiveLower(), t1);
                during = new OWLRealInterval(other.getLower(), this.getUpper(), other.inclusiveLower(), this.inclusiveUpper(), LineType.CONTINUOUS);
                after = new OWLRealInterval(this.getUpper(), other.getUpper(), !this.inclusiveUpper(), other.inclusiveUpper(), t2);
                break;
            }
            case PRECEDED_BY: 
            case PRECEDES: {
                return Arrays.asList(this, other);
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ArrayList<OWLRealInterval> ret = new ArrayList<OWLRealInterval>();
        if (before != null) {
            ret.add(before);
        }
        if (during != null) {
            ret.add(during);
        }
        if (after != null) {
            ret.add(after);
        }
        return ret;
    }

    public Iterator<Number> valueIterator() {
        if (this.isPoint()) {
            return Collections.singletonList(this.getUpper()).iterator();
        }
        if (LineType.INTEGER_ONLY.equals((Object)this.getType())) {
            Number finish;
            boolean increment;
            Number start;
            if (this.boundLower()) {
                start = this.getLower();
                increment = true;
                finish = this.boundUpper() ? (Number)this.getUpper() : (Number)null;
            } else if (this.boundUpper()) {
                start = this.getUpper();
                increment = false;
                finish = null;
            } else {
                start = (byte)0;
                increment = true;
                finish = null;
            }
            return new IntegerIterator(start, finish, increment);
        }
        throw new IllegalStateException();
    }

    public static enum LineType {
        CONTINUOUS,
        INTEGER_EXCLUDED,
        INTEGER_ONLY;


        public LineType intersect(LineType other) {
            if (other == null) {
                throw new NullPointerException();
            }
            switch (this) {
                case CONTINUOUS: {
                    return other;
                }
                case INTEGER_ONLY: {
                    if (other.equals((Object)INTEGER_EXCLUDED)) {
                        return null;
                    }
                    return INTEGER_ONLY;
                }
                case INTEGER_EXCLUDED: {
                    if (other.equals((Object)INTEGER_ONLY)) {
                        return null;
                    }
                    return INTEGER_EXCLUDED;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static class IntegerIterator
    implements Iterator<Number> {
        private final boolean _increment;
        private final Number _last;
        private volatile Number _next;

        public IntegerIterator(Number first, Number last, boolean increment) {
            this._last = last;
            this._increment = increment;
            this._next = first;
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public Number next() {
            if (this._next == null) {
                throw new NoSuchElementException();
            }
            Number n = this._next;
            this._next = this._last != null && OWLRealUtils.compare(this._next, this._last) == 0 ? null : (this._increment ? (Number)OWLRealUtils.integerIncrement(this._next) : (Number)OWLRealUtils.integerDecrement(this._next));
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

