/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.EmptyRestrictedDatatype;
import openllet.core.datatypes.Facet;
import openllet.core.datatypes.FloatingPointInterval;
import openllet.core.datatypes.FloatingPointType;
import openllet.core.datatypes.OWLRealUtils;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.shared.tools.Log;

public class RestrictedFloatingPointDatatype<T extends Number>
implements RestrictedDatatype<T> {
    private static final Logger _logger = Log.getLogger(RestrictedFloatingPointDatatype.class);
    private final boolean _containsNaN;
    private final Datatype<? extends T> _datatype;
    private final RestrictedDatatype<T> _empty;
    private final List<FloatingPointInterval<T>> _intervals;
    private final FloatingPointType<T> _type;

    public RestrictedFloatingPointDatatype(Datatype<? extends T> datatype, FloatingPointType<T> type) {
        this._datatype = datatype;
        this._type = type;
        this._empty = new EmptyRestrictedDatatype<T>(datatype);
        this._intervals = Collections.singletonList(FloatingPointInterval.unconstrained(type));
        this._containsNaN = true;
    }

    private RestrictedFloatingPointDatatype(RestrictedFloatingPointDatatype<T> other, List<FloatingPointInterval<T>> intervals, boolean containsNaN) {
        this._datatype = other._datatype;
        this._type = other._type;
        this._empty = other._empty;
        this._intervals = Collections.unmodifiableList(intervals);
        this._containsNaN = containsNaN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RestrictedDatatype<T> applyConstrainingFacet(ATermAppl facet, Object value) {
        T upper;
        T lower;
        Facet f = Facet.Registry.get(facet);
        if (f == null) {
            String msg = String.format("Attempt to constrain _datatype (%s) with unsupported constraining facet ('%s' , '%s')", this.getDatatype(), facet, value);
            _logger.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (!this._type.isInstance(value)) {
            String msg = String.format("Attempt to constrain _datatype (%s) using constraining facet ('%s') with an unsupported value ('%s')", this.getDatatype(), f, value);
            _logger.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        T n = this._type.cast(value);
        if (!EnumSet.of(Facet.XSD.MAX_EXCLUSIVE, Facet.XSD.MAX_INCLUSIVE, Facet.XSD.MIN_EXCLUSIVE, Facet.XSD.MIN_INCLUSIVE).contains(f)) throw new IllegalStateException();
        if (this._type.isNaN(n)) {
            return this._empty;
        }
        if (Facet.XSD.MAX_EXCLUSIVE.equals(f)) {
            lower = this._type.getNegativeInfinity();
            if (n.equals(this._type.getNegativeInfinity())) {
                return this._empty;
            }
            upper = this._type.decrement(n);
        } else if (Facet.XSD.MAX_INCLUSIVE.equals(f)) {
            lower = this._type.getNegativeInfinity();
            upper = n;
        } else if (Facet.XSD.MIN_EXCLUSIVE.equals(f)) {
            if (n.equals(this._type.getPositiveInfinity())) {
                return this._empty;
            }
            lower = n;
            upper = this._type.getPositiveInfinity();
        } else {
            if (!Facet.XSD.MIN_INCLUSIVE.equals(f)) throw new IllegalStateException();
            lower = n;
            upper = this._type.getPositiveInfinity();
        }
        FloatingPointInterval<T> restriction = new FloatingPointInterval<T>(this._type, lower, upper);
        ArrayList<FloatingPointInterval<T>> revisedIntervals = new ArrayList<FloatingPointInterval<T>>();
        boolean changes = this._containsNaN;
        for (FloatingPointInterval<T> i : this._intervals) {
            FloatingPointInterval<T> j = i.intersection(restriction);
            if (j != null) {
                revisedIntervals.add(j);
                if (i == j) continue;
                changes = true;
                continue;
            }
            changes = true;
        }
        if (!changes) return this;
        if (!revisedIntervals.isEmpty()) return new RestrictedFloatingPointDatatype<T>(this, revisedIntervals, false);
        return this._empty;
    }

    @Override
    public boolean contains(Object value) {
        if (this._type.isInstance(value)) {
            T n = this._type.cast(value);
            if (this._type.isNaN(n)) {
                return this._containsNaN;
            }
            for (FloatingPointInterval<T> i : this._intervals) {
                if (!i.contains(n)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        if (n <= 0) {
            return true;
        }
        Number sum = this._containsNaN ? 1 : 0;
        for (FloatingPointInterval<T> i : this._intervals) {
            if (OWLRealUtils.compare(sum = OWLRealUtils.integerSum(sum, i.size()), n) < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public RestrictedDatatype<T> exclude(Collection<?> values) {
        boolean changes = false;
        ArrayList<FloatingPointInterval<T>> revisedIntervals = new ArrayList<FloatingPointInterval<T>>(this._intervals);
        block0: for (Object o : values) {
            if (!this._type.isInstance(o)) continue;
            T n = this._type.cast(o);
            Iterator it = revisedIntervals.iterator();
            while (it.hasNext()) {
                FloatingPointInterval<T> greater;
                FloatingPointInterval i = (FloatingPointInterval)it.next();
                if (!i.contains(n)) continue;
                changes = true;
                it.remove();
                FloatingPointInterval<T> less = i.less(n);
                if (less != null) {
                    revisedIntervals.add(less);
                }
                if ((greater = i.greater(n)) == null) continue block0;
                revisedIntervals.add(greater);
                continue block0;
            }
        }
        if (changes) {
            if (revisedIntervals.isEmpty()) {
                return this._empty;
            }
            return new RestrictedFloatingPointDatatype<T>(this, revisedIntervals, this._containsNaN);
        }
        return this;
    }

    @Override
    public Datatype<? extends T> getDatatype() {
        return this._datatype;
    }

    @Override
    public RestrictedDatatype<T> intersect(RestrictedDatatype<?> other, boolean negated) {
        if (other instanceof RestrictedFloatingPointDatatype) {
            boolean toContainNaN;
            List<FloatingPointInterval<T>> intersectWith;
            if (!this._type.equals(((RestrictedFloatingPointDatatype)other)._type)) {
                throw new IllegalArgumentException();
            }
            RestrictedFloatingPointDatatype otherRRD = (RestrictedFloatingPointDatatype)other;
            boolean changes = false;
            ArrayList<FloatingPointInterval<T>> revisedIntervals = new ArrayList<FloatingPointInterval<T>>();
            if (negated) {
                intersectWith = Collections.singletonList(FloatingPointInterval.unconstrained(this._type));
                for (FloatingPointInterval<T> i : otherRRD._intervals) {
                    ArrayList<FloatingPointInterval<T>> tmp = new ArrayList<FloatingPointInterval<T>>();
                    for (FloatingPointInterval<T> j : intersectWith) {
                        tmp.addAll(j.remove(i));
                    }
                    intersectWith = tmp;
                }
            } else {
                intersectWith = otherRRD._intervals;
            }
            for (FloatingPointInterval<T> i : this._intervals) {
                for (FloatingPointInterval<T> j : intersectWith) {
                    FloatingPointInterval<T> k = i.intersection(j);
                    if (k == i) continue;
                    changes = true;
                    if (k == null) continue;
                    revisedIntervals.add(k);
                }
            }
            if (this._containsNaN) {
                if (otherRRD._containsNaN) {
                    if (negated) {
                        changes = true;
                        toContainNaN = false;
                    } else {
                        toContainNaN = true;
                    }
                } else if (negated) {
                    toContainNaN = true;
                } else {
                    changes = true;
                    toContainNaN = false;
                }
            } else {
                toContainNaN = false;
            }
            if (changes) {
                if (revisedIntervals.isEmpty()) {
                    return this._empty;
                }
                return new RestrictedFloatingPointDatatype<T>(this, revisedIntervals, toContainNaN);
            }
            return this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return true;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public int size() {
        long sum = this._containsNaN ? 1L : 0L;
        for (FloatingPointInterval<T> i : this._intervals) {
            if ((sum += i.size().longValue()) < Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    public String toString() {
        return String.format("{%s,%s}", this._datatype, this._intervals);
    }

    @Override
    public RestrictedDatatype<T> union(RestrictedDatatype<?> other) {
        if (other instanceof RestrictedFloatingPointDatatype) {
            if (!this._type.equals(((RestrictedFloatingPointDatatype)other)._type)) {
                throw new IllegalArgumentException();
            }
            RestrictedFloatingPointDatatype otherRRD = (RestrictedFloatingPointDatatype)other;
            ArrayList<FloatingPointInterval<T>> revisedIntervals = new ArrayList<FloatingPointInterval<T>>(this._intervals);
            for (FloatingPointInterval<T> i : otherRRD._intervals) {
                ArrayList<FloatingPointInterval> unionWith = new ArrayList<FloatingPointInterval>();
                Iterator jt = revisedIntervals.iterator();
                while (jt.hasNext()) {
                    FloatingPointInterval j = (FloatingPointInterval)jt.next();
                    if (!i.canUnionWith(j)) continue;
                    jt.remove();
                    unionWith.add(j);
                }
                if (unionWith.isEmpty()) {
                    revisedIntervals.add(i);
                    continue;
                }
                HashSet<FloatingPointInterval<T>> tmp = new HashSet<FloatingPointInterval<T>>();
                for (FloatingPointInterval j : unionWith) {
                    tmp.addAll(i.union(j));
                }
                revisedIntervals.addAll(tmp);
            }
            boolean toContainNaN = this._containsNaN || otherRRD._containsNaN;
            return new RestrictedFloatingPointDatatype<T>(this, revisedIntervals, toContainNaN);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<T> valueIterator() {
        return new Iterator<T>(){
            final Iterator<FloatingPointInterval<T>> iit;
            Iterator<T> nit;
            {
                this.iit = RestrictedFloatingPointDatatype.this._intervals.iterator();
                this.nit = null;
            }

            @Override
            public boolean hasNext() {
                while (this.nit == null || !this.nit.hasNext()) {
                    if (this.iit.hasNext()) {
                        this.nit = this.iit.next().valueIterator();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (Number)this.nit.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

