/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.bool;

import openllet.aterm.ATermAppl;
import openllet.core.datatypes.AbstractBaseDatatype;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.Datatypes;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.bool.RestrictedBooleanDatatype;
import openllet.core.utils.TermFactory;

public class XSDBoolean
extends AbstractBaseDatatype<Boolean> {
    private static final ATermAppl CANONICAL_FALSE_TERM;
    private static final ATermAppl CANONICAL_TRUE_TERM;
    private static final XSDBoolean instance;
    private static final ATermAppl NAME;
    private final RestrictedBooleanDatatype dataRange = new RestrictedBooleanDatatype(this);

    public static XSDBoolean getInstance() {
        return instance;
    }

    private XSDBoolean() {
        super(NAME);
    }

    @Override
    public RestrictedDatatype<Boolean> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        if (input == CANONICAL_FALSE_TERM || input == CANONICAL_TRUE_TERM) {
            return input;
        }
        return this.getLiteral(this.getValue(input));
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? CANONICAL_TRUE_TERM : CANONICAL_FALSE_TERM;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Boolean getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = XSDBoolean.getLexicalForm(literal).trim();
        if ("true".equals(lexicalForm) || "1".equals(lexicalForm)) {
            return Boolean.TRUE;
        }
        if ("false".equals(lexicalForm) || "0".equals(lexicalForm)) {
            return Boolean.FALSE;
        }
        throw new InvalidLiteralException(this.getName(), lexicalForm);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    static {
        NAME = Datatypes.BOOLEAN;
        CANONICAL_TRUE_TERM = TermFactory.literal(true);
        CANONICAL_FALSE_TERM = TermFactory.literal(false);
        instance = new XSDBoolean();
    }
}

