/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.floating;

import javax.xml.bind.DatatypeConverter;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.AbstractBaseDatatype;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.floating.IEEEFloatType;
import openllet.core.datatypes.types.floating.RestrictedFloatingPointDatatype;
import openllet.core.utils.ATermUtils;

public class XSDFloat
extends AbstractBaseDatatype<Float> {
    private static final XSDFloat instance = new XSDFloat();
    private final RestrictedFloatingPointDatatype<Float> dataRange = new RestrictedFloatingPointDatatype<Float>(this, IEEEFloatType.getInstance());

    public static XSDFloat getInstance() {
        return instance;
    }

    private XSDFloat() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#float"));
    }

    @Override
    public RestrictedDatatype<Float> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        Float f = this.getValue(input);
        String canonicalForm = DatatypeConverter.printFloat((float)f.floatValue());
        if (canonicalForm.equals(ATermUtils.getLiteralValue(input))) {
            return input;
        }
        return ATermUtils.makeTypedLiteral(canonicalForm, this.getName());
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (value instanceof Float) {
            return ATermUtils.makeTypedLiteral(DatatypeConverter.printFloat((float)((Float)value).floatValue()), this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Float getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = XSDFloat.getLexicalForm(literal);
        try {
            return Float.valueOf(DatatypeConverter.parseFloat((String)lexicalForm));
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm, e);
        }
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

