/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.real;

import openllet.aterm.ATermAppl;
import openllet.core.datatypes.AbstractBaseDatatype;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.OWLRealUtils;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.real.IntegerInterval;
import openllet.core.datatypes.types.real.RestrictedRealDatatype;
import openllet.core.datatypes.types.real.XSDDecimal;
import openllet.core.utils.ATermUtils;

public abstract class AbstractDerivedIntegerType
extends AbstractBaseDatatype<Number> {
    private static final XSDDecimal XSD_DECIMAL = XSDDecimal.getInstance();
    private final RestrictedDatatype<Number> _dataRange;

    public AbstractDerivedIntegerType(ATermAppl name, Number lower, Number upper) {
        super(name);
        if (lower != null && !OWLRealUtils.isInteger(lower)) {
            throw new IllegalArgumentException();
        }
        if (upper != null && !OWLRealUtils.isInteger(upper)) {
            throw new IllegalArgumentException();
        }
        if (lower != null && upper != null && OWLRealUtils.compare(lower, upper) > 0) {
            throw new IllegalArgumentException();
        }
        IntegerInterval i = new IntegerInterval(lower == null ? (Number)null : (Number)OWLRealUtils.getCanonicalObject(lower), upper == null ? (Number)null : (Number)OWLRealUtils.getCanonicalObject(upper));
        this._dataRange = new RestrictedRealDatatype(this, i, null, null);
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this._dataRange;
    }

    protected abstract Number fromLexicalForm(String var1) throws InvalidLiteralException;

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        String lexicalForm = AbstractDerivedIntegerType.getLexicalForm(input);
        this.fromLexicalForm(lexicalForm);
        return XSD_DECIMAL.getCanonicalRepresentation(ATermUtils.makeTypedLiteral(lexicalForm, XSD_DECIMAL.getName()));
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return XSDDecimal.getInstance();
    }

    @Override
    public Number getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = AbstractDerivedIntegerType.getLexicalForm(literal);
        return OWLRealUtils.getCanonicalObject(this.fromLexicalForm(lexicalForm));
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

