/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.real;

import javax.xml.bind.DatatypeConverter;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.real.AbstractDerivedIntegerType;
import openllet.core.utils.ATermUtils;

public class XSDLong
extends AbstractDerivedIntegerType {
    private static final XSDLong instance = new XSDLong();

    public static XSDLong getInstance() {
        return instance;
    }

    private XSDLong() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#long"), Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            return DatatypeConverter.parseLong((String)lexicalForm);
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm, e);
        }
    }
}

