/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.real;

import javax.xml.bind.DatatypeConverter;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.real.AbstractDerivedIntegerType;
import openllet.core.utils.ATermUtils;

public class XSDUnsignedShort
extends AbstractDerivedIntegerType {
    private static final XSDUnsignedShort instance = new XSDUnsignedShort();
    private static final int MAX_VALUE = 65535;

    public static XSDUnsignedShort getInstance() {
        return instance;
    }

    private XSDUnsignedShort() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#unsignedShort"), 0, 65535);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            int i = DatatypeConverter.parseInt((String)lexicalForm);
            if (i < 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            if (i > 65535) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm, e);
        }
    }
}

