/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.text;

import openllet.aterm.ATermAppl;
import openllet.core.datatypes.AbstractBaseDatatype;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.text.RestrictedTextDatatype;
import openllet.core.utils.ATermUtils;

public class RDFPlainLiteral
extends AbstractBaseDatatype<ATermAppl> {
    private static final RDFPlainLiteral instance = new RDFPlainLiteral();
    private final RestrictedTextDatatype _dataRange = new RestrictedTextDatatype((Datatype<ATermAppl>)this, true);

    public static RDFPlainLiteral getInstance() {
        return instance;
    }

    private RDFPlainLiteral() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/1999/02/22-rdf-syntax-ns#PlainLiteral"));
    }

    @Override
    public RestrictedDatatype<ATermAppl> asDataRange() {
        return this._dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        return this.getValue(input);
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (value instanceof ATermAppl) {
            ATermAppl literal = (ATermAppl)value;
            try {
                return this.getCanonicalRepresentation(literal);
            }
            catch (InvalidLiteralException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public ATermAppl getValue(ATermAppl literal) throws InvalidLiteralException {
        RDFPlainLiteral.getLexicalForm(literal);
        return literal;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    static {
        RestrictedTextDatatype.addPermittedDatatype(instance.getName());
    }
}

