/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.el;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import openllet.aterm.AFun;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.KnowledgeBase;
import openllet.core.boxes.rbox.Role;
import openllet.core.el.ELSyntaxUtils;
import openllet.core.el.GenericTaxonomyBuilder;
import openllet.core.el.RoleRestrictionCache;
import openllet.core.taxonomy.CDOptimizedTaxonomyBuilder;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.MultiValueMap;
import openllet.core.utils.Timer;
import openllet.core.utils.Timers;
import openllet.shared.tools.Log;

public abstract class RuleBasedELClassifier
extends CDOptimizedTaxonomyBuilder {
    public static final Logger _logger = Log.getLogger(RuleBasedELClassifier.class);
    protected Timers _timers = new Timers();

    public RuleBasedELClassifier(KnowledgeBase kb) {
        super(kb);
        _logger.fine("new RuleBasedELClassifier");
    }

    protected abstract void addSubclassRule(ATermAppl var1, ATermAppl var2);

    protected abstract void addRoleDomainRule(ATermAppl var1, ATermAppl var2);

    protected abstract void addRoleRangeRule(ATermAppl var1, ATermAppl var2);

    protected abstract void addRoleChainRule(ATerm[] var1, ATermAppl var2);

    protected abstract void addRoleHierarchyRule(ATermAppl var1, ATermAppl var2);

    protected abstract MultiValueMap<ATermAppl, ATermAppl> run(Collection<ATermAppl> var1);

    @Override
    public synchronized boolean classify() {
        this.reset();
        this._monitor.setProgressTitle("Classifiying");
        this._monitor.setProgressLength(this._classes.size());
        this._monitor.taskStarted();
        this._monitor.setProgress(0);
        _logger.info("Creating structures");
        Optional<Timer> timer = this._timers.startTimer("createConcepts");
        this.processAxioms();
        timer.ifPresent(t -> t.stop());
        _logger.info("Running rules");
        MultiValueMap<ATermAppl, ATermAppl> subsumers = this.run(this._kb.getAllClasses());
        this._monitor.setProgress(this._classes.size());
        _logger.info("Building hierarchy");
        Optional<Timer> timer2 = this._timers.startTimer("buildHierarchy");
        this.buildTaxonomy(subsumers);
        timer2.ifPresent(t -> t.stop());
        this._monitor.setProgress(this._classes.size());
        this._monitor.taskFinished();
        return true;
    }

    protected void buildTaxonomy(MultiValueMap<ATermAppl, ATermAppl> subsumers) {
        this._taxonomyImpl = new GenericTaxonomyBuilder().build(subsumers);
    }

    private void toELSubClassAxioms(ATermAppl axiom) {
        AFun fun = axiom.getAFun();
        ATermAppl sub = (ATermAppl)axiom.getArgument(0);
        ATermAppl sup = (ATermAppl)axiom.getArgument(1);
        ATermAppl subEL = ELSyntaxUtils.simplify(sub);
        if (fun.equals(ATermUtils.SUBFUN)) {
            if (ATermUtils.isPrimitive(sup) || ATermUtils.isBottom(sup)) {
                this.addSubclassRule(subEL, sup);
                return;
            }
            ATermAppl supEL = ELSyntaxUtils.simplify(sup);
            this.addSubclassRule(subEL, supEL);
        } else if (fun.equals(ATermUtils.EQCLASSFUN)) {
            ATermAppl supEL = ELSyntaxUtils.simplify(sup);
            this.addSubclassRule(subEL, supEL);
            this.addSubclassRule(supEL, subEL);
        } else {
            throw new IllegalArgumentException("Axiom " + axiom + " is not EL.");
        }
    }

    private void processAxioms() {
        Collection<ATermAppl> assertedAxioms = this._kb.getTBox().getAssertedAxioms();
        for (ATermAppl assertedAxiom : assertedAxioms) {
            this.toELSubClassAxioms(assertedAxiom);
        }
        for (Role r : this._kb.getRBox().getRoles().values()) {
            ATermAppl aTermAppl = r.getName();
            for (Set<ATermAppl> supers : this._kb.getSuperProperties(aTermAppl)) {
                for (ATermAppl sup : supers) {
                    this.addRoleHierarchyRule(aTermAppl, sup);
                }
            }
        }
        for (Role supRole : this._kb.getRBox().getRoles().values()) {
            for (ATermList chainList : supRole.getSubRoleChains()) {
                ATerm[] chain = ATermUtils.toArray(chainList);
                this.addRoleChainRule(chain, supRole.getName());
            }
        }
        RoleRestrictionCache roleRestrictions = new RoleRestrictionCache(this._kb.getRBox());
        for (Map.Entry<ATermAppl, ATermAppl> entry : roleRestrictions.getDomains().entrySet()) {
            this.addRoleDomainRule(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<ATermAppl, ATermAppl> entry : roleRestrictions.getRanges().entrySet()) {
            this.addRoleRangeRule(entry.getKey(), entry.getValue());
        }
        for (Role role : this._kb.getRBox().getRoles().values()) {
            ATermAppl range;
            if (!role.isReflexive() || (range = roleRestrictions.getRange(role.getName())) == null) continue;
            this.addSubclassRule(ATermUtils.TOP, range);
        }
    }
}

