/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.knowledge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.atom.OpenError;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.rbox.Role;
import openllet.core.knowledge.Base;
import openllet.core.knowledge.MessageBase;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyUtils;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.Bool;
import openllet.core.utils.Timer;
import openllet.shared.tools.Logging;

public interface InstancesBase
extends MessageBase,
Logging,
Base {
    default public void linearInstanceRetrieval(ATermAppl c, List<ATermAppl> candidates, Collection<ATermAppl> results) {
        if (null == c || null == candidates || null == results) {
            return;
        }
        for (ATermAppl ind : candidates) {
            if (!this.getABox().isType(ind, c)) continue;
            results.add(ind);
        }
    }

    @Override
    default public void binaryInstanceRetrieval(ATermAppl c, List<ATermAppl> candidates, Collection<ATermAppl> results) {
        if (null == c || null == candidates || null == results) {
            return;
        }
        if (candidates.isEmpty()) {
            return;
        }
        this.partitionInstanceRetrieval(c, InstancesBase.partition(candidates), results);
    }

    default public void partitionInstanceRetrieval(ATermAppl c, List<ATermAppl>[] partitions, Collection<ATermAppl> results) {
        if (partitions[0].size() == 1) {
            ATermAppl i = partitions[0].get(0);
            this.binaryInstanceRetrieval(c, partitions[1], results);
            if (this.getABox().isType(i, c)) {
                results.add(i);
            }
        } else if (!this.getABox().existType(partitions[0], c)) {
            this.binaryInstanceRetrieval(c, partitions[1], results);
        } else if (!this.getABox().existType(partitions[1], c)) {
            this.binaryInstanceRetrieval(c, partitions[0], results);
        } else {
            this.binaryInstanceRetrieval(c, partitions[0], results);
            this.binaryInstanceRetrieval(c, partitions[1], results);
        }
    }

    public static List<ATermAppl>[] partition(List<ATermAppl> candidates) {
        List[] partitions = new List[2];
        int n = candidates.size();
        if (n <= 1) {
            partitions[0] = candidates;
            partitions[1] = Collections.emptyList();
        } else {
            partitions[0] = candidates.subList(0, n / 2);
            partitions[1] = candidates.subList(n / 2, n);
        }
        return partitions;
    }

    default public Set<ATermAppl> getInstances(ATermAppl c) {
        if (null == c) {
            return Collections.emptySet();
        }
        if (!this.isClass(c)) {
            Base.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        if (this.getInstances().containsKey(c)) {
            return this.getInstances().get(c);
        }
        if (this.isRealized()) {
            Taxonomy<ATermAppl> taxonomy = this.getTaxonomyBuilder().getTaxonomy();
            if (taxonomy == null) {
                throw new OpenError("Taxonomy is null");
            }
            if (taxonomy.contains(c) && ATermUtils.isPrimitive(c)) {
                return TaxonomyUtils.getAllInstances(taxonomy, c);
            }
        }
        return new HashSet<ATermAppl>(this.retrieve(c, this.getIndividuals()));
    }

    default public Set<ATermAppl> getInstances(ATermAppl c, boolean direct) {
        if (null == c) {
            return Collections.emptySet();
        }
        if (!this.isClass(c)) {
            Base.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        if (!direct) {
            return this.getInstances(c);
        }
        this.realize();
        Taxonomy<ATermAppl> taxonomy = this.getTaxonomyBuilder().getTaxonomy();
        if (taxonomy == null) {
            throw new OpenError("Taxonomy is null");
        }
        if (ATermUtils.isPrimitive(c)) {
            return TaxonomyUtils.getDirectInstances(taxonomy, c);
        }
        if (!taxonomy.contains(c)) {
            this.getTaxonomyBuilder().classify(c);
        }
        HashSet<ATermAppl> ret = new HashSet<ATermAppl>();
        Set<Set<ATermAppl>> sups = this.getSuperClasses(c, true);
        for (Set<ATermAppl> s : sups) {
            Iterator<ATermAppl> i = s.iterator();
            ATermAppl term = i.next();
            Set cand = TaxonomyUtils.getDirectInstances(taxonomy, term);
            if (ret.isEmpty()) {
                ret.addAll(cand);
            } else {
                ret.retainAll(cand);
            }
            if (!ret.isEmpty()) continue;
            return ret;
        }
        return this.retrieve(c, ret);
    }

    default public Set<ATermAppl> retrieve(ATermAppl d, Collection<ATermAppl> individuals) {
        if (null == d || null == individuals) {
            return Collections.emptySet();
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.normalize(d);
        if (ATermUtils.isAnd(c)) {
            Set<ATermAppl> terms = new HashSet<ATermAppl>(individuals);
            if (1 != c.getArity()) {
                throw new OpenError("arity isn't 1.");
            }
            if (1 == c.getArity()) {
                ATerm arg = c.getArgument(0);
                if (arg instanceof ATermList) {
                    for (ATerm term : (ATermList)arg) {
                        terms = this.retrieve((ATermAppl)term, terms);
                    }
                }
            } else {
                for (ATerm term : c.getArgumentArray()) {
                    terms = this.retrieve((ATermAppl)term, terms);
                }
            }
            return terms;
        }
        Optional<Timer> timer = this.getTimers().startTimer("retrieve");
        ATermAppl notC = ATermUtils.negate(c);
        ArrayList<ATermAppl> knowns = new ArrayList<ATermAppl>();
        if (!this.getABox().isSatisfiable(notC)) {
            knowns.addAll(this.getIndividuals());
        } else if (this.getABox().isSatisfiable(c)) {
            Set<ATermAppl> subs = Collections.emptySet();
            if (this.isClassified()) {
                Taxonomy<ATermAppl> taxonomy = this.getTaxonomyBuilder().getTaxonomy();
                if (taxonomy == null) {
                    throw new NullPointerException("Taxonomy");
                }
                if (taxonomy.contains(c)) {
                    subs = taxonomy.getFlattenedSubs(c, false);
                }
            }
            ArrayList<ATermAppl> unknowns = new ArrayList<ATermAppl>();
            for (ATermAppl x : individuals) {
                Bool isType = this.getABox().isKnownType(x, c, subs);
                if (isType.isTrue()) {
                    knowns.add(x);
                    continue;
                }
                if (!isType.isUnknown()) continue;
                unknowns.add(x);
            }
            if (!unknowns.isEmpty()) {
                if (OpenlletOptions.INSTANCE_RETRIEVAL == OpenlletOptions.InstanceRetrievalMethod.TRACING_BASED && OpenlletOptions.USE_TRACING) {
                    this.tracingBasedInstanceRetrieval(c, unknowns, knowns);
                } else if (this.getABox().existType(unknowns, c)) {
                    if (OpenlletOptions.INSTANCE_RETRIEVAL == OpenlletOptions.InstanceRetrievalMethod.BINARY) {
                        this.binaryInstanceRetrieval(c, unknowns, knowns);
                    } else {
                        this.linearInstanceRetrieval(c, unknowns, knowns);
                    }
                }
            }
        }
        timer.ifPresent(t -> t.stop());
        Set<ATermAppl> result = Collections.unmodifiableSet(new HashSet(knowns));
        if (OpenlletOptions.CACHE_RETRIEVAL) {
            this.getInstances().put(c, result);
        }
        return result;
    }

    default public void tracingBasedInstanceRetrieval(ATermAppl c, List<ATermAppl> candidates, Collection<ATermAppl> results) {
        if (null == c || null == candidates || null == results) {
            return;
        }
        List<ATermAppl> individuals = candidates;
        boolean doExplanation = this.doExplanation();
        this.setDoExplanation(true);
        ATermAppl notC = ATermUtils.negate(c);
        block0: while (this.getABox().existType(individuals, c)) {
            Set<ATermAppl> explanationSet = this.getExplanationSet();
            for (ATermAppl axiom : explanationSet) {
                ATermAppl ind;
                int index;
                if (!axiom.getAFun().equals(ATermUtils.TYPEFUN) || !axiom.getArgument(1).equals(notC) || (index = individuals.indexOf(ind = (ATermAppl)axiom.getArgument(0))) < 0) continue;
                this.getLogger().finer(() -> "Filter instance " + axiom + " while retrieving " + c);
                Collections.swap(individuals, index, 0);
                results.add(ind);
                individuals = individuals.subList(1, individuals.size());
                continue block0;
            }
        }
        this.setDoExplanation(doExplanation);
    }

    default public List<ATermAppl> retrieveIndividualsWithProperty(ATermAppl r) {
        if (null == r) {
            return Collections.emptyList();
        }
        this.ensureConsistency();
        Role role = this.getRBox().getRole(r);
        if (role == null) {
            Base.handleUndefinedEntity(r + " is not a known property!");
            return Collections.emptyList();
        }
        ArrayList<ATermAppl> result = new ArrayList<ATermAppl>();
        for (ATermAppl ind : this.getIndividuals()) {
            if (this.getABox().hasObviousPropertyValue(ind, r, null).isFalse()) continue;
            result.add(ind);
        }
        return result;
    }

    default public Set<Set<ATermAppl>> getTypes(ATermAppl ind, boolean direct) {
        Set<Set<ATermAppl>> types;
        if (null == ind) {
            return Collections.emptySet();
        }
        if (!this.isIndividual(ind)) {
            Base.handleUndefinedEntity(ind + " is not an individual!");
            return Collections.emptySet();
        }
        if (OpenlletOptions.AUTO_REALIZE) {
            this.realize();
        }
        Set<Set<ATermAppl>> set = types = this.isClassified() ? this.getPrimitiveTypes(ind, direct) : Collections.emptySet();
        if (types.isEmpty() && !OpenlletOptions.AUTO_REALIZE) {
            this.classify();
            this.getTaxonomyBuilder().realize(ind);
            types = this.getPrimitiveTypes(ind, direct);
        }
        return types;
    }

    default public Set<Set<ATermAppl>> getPrimitiveTypes(ATermAppl ind, boolean direct) {
        HashSet<Set<ATermAppl>> types = new HashSet<Set<ATermAppl>>();
        for (Set<ATermAppl> t : TaxonomyUtils.getTypes(this.getTaxonomyBuilder().getTaxonomy(), ind, direct)) {
            Set<ATermAppl> eqSet = ATermUtils.primitiveOrBottom(t);
            if (eqSet.isEmpty()) continue;
            types.add(eqSet);
        }
        return types;
    }

    default public Set<ATermAppl> getAllSames(ATermAppl name) {
        if (null == name) {
            return Collections.emptySet();
        }
        this.ensureConsistency();
        HashSet<ATermAppl> knowns = new HashSet<ATermAppl>();
        HashSet<ATermAppl> unknowns = new HashSet<ATermAppl>();
        Individual ind = this.getABox().getIndividual(name);
        if (ind == null) {
            Base.handleUndefinedEntity(name + " is not an individual!");
            return Collections.emptySet();
        }
        if (ind.isMerged() && !ind.getMergeDependency(true).isIndependent()) {
            knowns.add(name);
            this.getABox().getSames(ind.getSame(), unknowns, unknowns);
            unknowns.remove(name);
        } else {
            this.getABox().getSames(ind.getSame(), knowns, unknowns);
        }
        for (ATermAppl other : unknowns) {
            if (!this.getABox().isSameAs(name, other)) continue;
            knowns.add(other);
        }
        return knowns;
    }
}

