/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.knowledge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.DependencySet;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Literal;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.exceptions.UnrecognizedDatatypeException;
import openllet.core.knowledge.Base;
import openllet.core.knowledge.MessageBase;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.utils.ATermUtils;
import openllet.shared.tools.Logging;

public interface PropertiesBase
extends MessageBase,
Logging,
Base {
    public Set<ATermAppl> currentIndividuals();

    default public void addSubProperty(ATerm sub, ATermAppl sup) {
        this.getChanges().add(KnowledgeBase.ChangeType.RBOX_ADD);
        this.getRBox().addSubRole(sub, sup);
        this.getLogger().finer(() -> "sub-prop " + sub + " " + sup);
    }

    default public void addEquivalentProperty(ATermAppl p1, ATermAppl p2) {
        this.getChanges().add(KnowledgeBase.ChangeType.RBOX_ADD);
        this.getRBox().addEquivalentRole(p1, p2);
        this.getLogger().finer(() -> "same-prop " + p1 + " " + p2);
    }

    default public void addDisjointProperties(ATermList properties) {
        if (null == properties) {
            return;
        }
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeDisjointProperties(properties)) : DependencySet.INDEPENDENT;
        ATermList l1 = properties;
        while (!l1.isEmpty()) {
            ATermAppl p1 = (ATermAppl)l1.getFirst();
            ATermList l2 = l1.getNext();
            while (!l2.isEmpty()) {
                ATermAppl p2 = (ATermAppl)l2.getFirst();
                this.addDisjointProperty(p1, p2, ds);
                l2 = l2.getNext();
            }
            l1 = l1.getNext();
        }
        this.getLogger().finer(() -> "disjoints " + properties);
    }

    default public void addDisjointProperty(ATermAppl p1, ATermAppl p2) {
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeDisjointProperty(p1, p2)) : DependencySet.INDEPENDENT;
        this.addDisjointProperty(p1, p2, ds);
    }

    default public void addDisjointProperty(ATermAppl p1, ATermAppl p2, DependencySet ds) {
        this.getChanges().add(KnowledgeBase.ChangeType.RBOX_ADD);
        this.getRBox().addDisjointRole(p1, p2, ds);
        this.getLogger().finer(() -> "dis-prop " + p1 + " " + p2);
    }

    default public void addInverseProperty(ATermAppl p1, ATermAppl p2) {
        if (null == p1 || null == p2) {
            return;
        }
        if (OpenlletOptions.IGNORE_INVERSES) {
            this.getLogger().warning("Ignoring inverseOf(" + p1 + " " + p2 + ") axiom due to the IGNORE_INVERSES option");
            return;
        }
        this.getChanges().add(KnowledgeBase.ChangeType.RBOX_ADD);
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeInvProp(p1, p2)) : DependencySet.INDEPENDENT;
        this.getRBox().addInverseRole(p1, p2, ds);
        this.getLogger().finer(() -> "inv-prop " + p1 + " " + p2);
    }

    default public void addTransitiveProperty(ATermAppl p) {
        if (null == p) {
            return;
        }
        this.getChanges().add(KnowledgeBase.ChangeType.RBOX_ADD);
        Role r = this.getRBox().getDefinedRole(p);
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeTransitive(p)) : DependencySet.INDEPENDENT;
        r.addSubRoleChain(ATermUtils.makeList(new ATerm[]{p, p}), ds);
        this.getLogger().finer(() -> "trans-prop " + p);
    }

    default public void addSymmetricProperty(ATermAppl p) {
        if (OpenlletOptions.IGNORE_INVERSES) {
            this.getLogger().warning("Ignoring SymmetricProperty(" + p + ") axiom due to the IGNORE_INVERSES option");
            return;
        }
        this.getChanges().add(KnowledgeBase.ChangeType.RBOX_ADD);
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSymmetric(p)) : DependencySet.INDEPENDENT;
        this.getRBox().addInverseRole(p, p, ds);
        this.getLogger().finer(() -> "sym-prop " + p);
    }

    @Deprecated
    default public void addAntisymmetricProperty(ATermAppl p) {
        this.addAsymmetricProperty(p);
    }

    default public void addAsymmetricProperty(ATermAppl p) {
        if (null == p) {
            return;
        }
        this.getChanges().add(KnowledgeBase.ChangeType.RBOX_ADD);
        Role r = this.getRBox().getDefinedRole(p);
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeAsymmetric(p)) : DependencySet.INDEPENDENT;
        r.setAsymmetric(true, ds);
        this.getLogger().finer(() -> "anti-sym-prop " + p);
    }

    default public void addReflexiveProperty(ATermAppl p) {
        if (null == p) {
            return;
        }
        this.getChanges().add(KnowledgeBase.ChangeType.RBOX_ADD);
        Role r = this.getRBox().getDefinedRole(p);
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeReflexive(p)) : DependencySet.INDEPENDENT;
        r.setReflexive(true, ds);
        this.getLogger().finer(() -> "reflexive-prop " + p);
    }

    default public void addIrreflexiveProperty(ATermAppl p) {
        this.getChanges().add(KnowledgeBase.ChangeType.RBOX_ADD);
        Role r = this.getRBox().getDefinedRole(p);
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeIrreflexive(p)) : DependencySet.INDEPENDENT;
        r.setIrreflexive(true, ds);
        this.getLogger().finer(() -> "irreflexive-prop " + p);
    }

    default public void addFunctionalProperty(ATermAppl p) {
        this.getChanges().add(KnowledgeBase.ChangeType.RBOX_ADD);
        Role r = this.getRBox().getDefinedRole(p);
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeFunctional(p)) : DependencySet.INDEPENDENT;
        r.setFunctional(true, ds);
        this.getLogger().finer(() -> "func-prop " + p);
    }

    default public void addInverseFunctionalProperty(ATerm p) {
        if (null == p) {
            return;
        }
        if (OpenlletOptions.IGNORE_INVERSES) {
            this.getLogger().warning("Ignoring InverseFunctionalProperty(" + p + ") axiom due to the IGNORE_INVERSES option");
            return;
        }
        this.getChanges().add(KnowledgeBase.ChangeType.RBOX_ADD);
        Role role = this.getRBox().getDefinedRole(p);
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeInverseFunctional(p)) : DependencySet.INDEPENDENT;
        role.setInverseFunctional(true, ds);
        this.getLogger().finer(() -> "inv-func-prop " + p);
    }

    default public Set<Set<ATermAppl>> getAllSuperProperties(ATermAppl prop) {
        if (null == prop) {
            return Collections.emptySet();
        }
        if (!this.isProperty(prop)) {
            Base.handleUndefinedEntity(prop + " is not a property!");
            return Collections.emptySet();
        }
        Set<Set<ATermAppl>> supers = this.getSuperProperties(prop);
        supers.add(this.getAllEquivalentProperties(prop));
        return supers;
    }

    default public Set<Set<ATermAppl>> getSuperProperties(ATermAppl prop) {
        return this.getSuperProperties(prop, false);
    }

    default public Set<Set<ATermAppl>> getSuperProperties(ATermAppl prop, boolean direct) {
        if (null == prop) {
            return Collections.emptySet();
        }
        if (!this.isProperty(prop)) {
            Base.handleUndefinedEntity(prop + " is not a property!");
            return Collections.emptySet();
        }
        HashSet<Set<ATermAppl>> supers = new HashSet<Set<ATermAppl>>();
        Taxonomy<ATermAppl> taxonomy = this.getRoleTaxonomy(prop);
        if (taxonomy != null) {
            for (Set<ATermAppl> s : taxonomy.getSupers(prop, direct)) {
                Set<ATermAppl> supEqSet = ATermUtils.primitiveOrBottom(s);
                if (supEqSet.isEmpty()) continue;
                supers.add(supEqSet);
            }
        }
        return supers;
    }

    default public Set<Set<ATermAppl>> getAllSubProperties(ATermAppl prop) {
        if (null == prop) {
            return Collections.emptySet();
        }
        if (!this.isProperty(prop)) {
            Base.handleUndefinedEntity(prop + " is not a property!");
            return Collections.emptySet();
        }
        Set<Set<ATermAppl>> subs = this.getSubProperties(prop);
        subs.add(this.getAllEquivalentProperties(prop));
        return subs;
    }

    default public Taxonomy<ATermAppl> getRoleTaxonomy(ATermAppl r) {
        this.prepare();
        if (this.isObjectProperty(r)) {
            return this.getRBox().getObjectTaxonomy();
        }
        if (this.isDatatypeProperty(r)) {
            return this.getRBox().getDataTaxonomy();
        }
        if (this.isAnnotationProperty(r)) {
            return this.getRBox().getAnnotationTaxonomy();
        }
        return null;
    }

    default public Set<Set<ATermAppl>> getSubProperties(ATermAppl prop, boolean direct) {
        if (null == prop) {
            return Collections.emptySet();
        }
        if (!this.isProperty(prop)) {
            Base.handleUndefinedEntity(prop + " is not a property!");
            return Collections.emptySet();
        }
        HashSet<Set<ATermAppl>> subs = new HashSet<Set<ATermAppl>>();
        Taxonomy<ATermAppl> taxonomy = this.getRoleTaxonomy(prop);
        if (taxonomy != null) {
            for (Set<ATermAppl> s : taxonomy.getSubs(prop, direct)) {
                Set<ATermAppl> subEqSet = ATermUtils.primitiveOrBottom(s);
                if (subEqSet.isEmpty()) continue;
                subs.add(subEqSet);
            }
        } else {
            this.getLogger().info(() -> "taxonomy is null for " + prop);
        }
        return subs;
    }

    default public Set<Set<ATermAppl>> getSubProperties(ATermAppl prop) {
        return this.getSubProperties(prop, false);
    }

    default public Taxonomy<ATermAppl> getRoleTaxonomy(boolean objectTaxonomy) {
        this.prepare();
        return objectTaxonomy ? this.getRBox().getObjectTaxonomy() : this.getRBox().getDataTaxonomy();
    }

    default public Set<ATermAppl> getEquivalentProperties(ATermAppl prop) {
        if (null == prop) {
            return Collections.emptySet();
        }
        if (!this.isProperty(prop)) {
            Base.handleUndefinedEntity(prop + " is not a property!");
            return Collections.emptySet();
        }
        Taxonomy<ATermAppl> taxonomy = this.getRoleTaxonomy(prop);
        if (null == taxonomy) {
            return Collections.emptySet();
        }
        if (OpenlletOptions.RETURN_NON_PRIMITIVE_EQUIVALENT_PROPERTIES && !ATermUtils.isBuiltinProperty(prop)) {
            return taxonomy.getEquivalents(prop);
        }
        return ATermUtils.primitiveOrBottom(taxonomy.getEquivalents(prop));
    }

    default public Set<ATermAppl> getAllEquivalentProperties(ATermAppl prop) {
        if (null == prop) {
            return Collections.emptySet();
        }
        if (!this.isProperty(prop)) {
            Base.handleUndefinedEntity(prop + " is not a property!");
            return Collections.emptySet();
        }
        Taxonomy<ATermAppl> taxonomy = this.getRoleTaxonomy(prop);
        if (null == taxonomy) {
            return Collections.emptySet();
        }
        if (OpenlletOptions.RETURN_NON_PRIMITIVE_EQUIVALENT_PROPERTIES && !ATermUtils.isBuiltinProperty(prop)) {
            return taxonomy.getAllEquivalents(prop);
        }
        return ATermUtils.primitiveOrBottom(taxonomy.getAllEquivalents(prop));
    }

    default public Set<ATermAppl> getInverses(ATerm name) {
        if (null == name) {
            return Collections.emptySet();
        }
        ATermAppl invR = this.getInverse(name);
        if (invR != null) {
            Set<ATermAppl> inverses = this.getAllEquivalentProperties(invR);
            return inverses;
        }
        return Collections.emptySet();
    }

    default public ATermAppl getInverse(ATerm name) {
        if (null == name) {
            return null;
        }
        Role prop = this.getRBox().getRole(name);
        if (prop == null) {
            Base.handleUndefinedEntity(name + " is not a property!");
            return null;
        }
        Role invProp = prop.getInverse();
        return invProp != null ? invProp.getName() : null;
    }

    default public boolean isSubPropertyOf(ATermAppl sub, ATermAppl sup) {
        ATermAppl test;
        if (null == sub || null == sup) {
            return false;
        }
        Role roleSub = this.getRBox().getRole(sub);
        Role roleSup = this.getRBox().getRole(sup);
        if (roleSub == null) {
            Base.handleUndefinedEntity(sub + " is not a known property!");
            return false;
        }
        if (roleSup == null) {
            Base.handleUndefinedEntity(sup + " is not a known property!");
            return false;
        }
        if (roleSub.isSubRoleOf(roleSup)) {
            if (this.doExplanation()) {
                this.getABox().setExplanation(roleSub.getExplainSuper(sup));
            }
            return true;
        }
        if (roleSub.getType() != roleSup.getType()) {
            return false;
        }
        this.ensureConsistency();
        if (roleSub.isObjectRole()) {
            ATermAppl c = ATermUtils.makeTermAppl("_C_");
            ATermAppl notC = ATermUtils.makeNot(c);
            test = ATermUtils.makeAnd(ATermUtils.makeSomeValues(sub, c), ATermUtils.makeAllValues(sup, notC));
        } else if (roleSub.isDatatypeRole()) {
            ATermAppl anon = ATermUtils.makeLiteral(ATermUtils.makeAnonNominal(Integer.MAX_VALUE));
            test = ATermUtils.makeAnd(ATermUtils.makeHasValue(sub, anon), ATermUtils.makeAllValues(sup, ATermUtils.makeNot(ATermUtils.makeValue(anon))));
        } else {
            if (roleSub.isAnnotationRole()) {
                return false;
            }
            throw new IllegalArgumentException();
        }
        return !this.getABox().isSatisfiable(test);
    }

    default public boolean isEquivalentProperty(ATermAppl p1, ATermAppl p2) {
        ATermAppl test;
        if (null == p1 || null == p2) {
            return false;
        }
        Role role1 = this.getRBox().getRole(p1);
        Role role2 = this.getRBox().getRole(p2);
        if (role1 == null) {
            Base.handleUndefinedEntity(p1 + " is not a known property!");
            return false;
        }
        if (role2 == null) {
            Base.handleUndefinedEntity(p2 + " is not a known property!");
            return false;
        }
        if (role1.isSubRoleOf(role2) && role2.isSubRoleOf(role1)) {
            if (this.doExplanation()) {
                this.getABox().setExplanation(role1.getExplainSuper(p2).union(role1.getExplainSub(p2), this.doExplanation()));
            }
            return true;
        }
        if (role1.isAnnotationRole() || role2.isAnnotationRole()) {
            return false;
        }
        if (role1.getType() != role2.getType()) {
            return false;
        }
        this.ensureConsistency();
        if (role1.isObjectRole()) {
            ATermAppl c = !role1.getRanges().isEmpty() ? role1.getRanges().iterator().next() : (!role2.getRanges().isEmpty() ? role2.getRanges().iterator().next() : ATermUtils.makeTermAppl("_C_"));
            ATermAppl notC = ATermUtils.makeNot(c);
            test = ATermUtils.makeOr(ATermUtils.makeAnd(ATermUtils.makeSomeValues(p1, c), ATermUtils.makeAllValues(p2, notC)), ATermUtils.makeAnd(ATermUtils.makeSomeValues(p2, c), ATermUtils.makeAllValues(p1, notC)));
        } else if (role1.isDatatypeRole()) {
            ATermAppl anon = ATermUtils.makeLiteral(ATermUtils.makeAnonNominal(Integer.MAX_VALUE));
            test = ATermUtils.makeOr(ATermUtils.makeAnd(ATermUtils.makeHasValue(p1, anon), ATermUtils.makeAllValues(p2, ATermUtils.makeNot(ATermUtils.makeValue(anon)))), ATermUtils.makeAnd(ATermUtils.makeHasValue(p2, anon), ATermUtils.makeAllValues(p1, ATermUtils.makeNot(ATermUtils.makeValue(anon)))));
        } else {
            throw new IllegalArgumentException();
        }
        return !this.getABox().isSatisfiable(test);
    }

    default public boolean isInverse(ATermAppl r1, ATermAppl r2) {
        if (null == r1 || null == r2) {
            return false;
        }
        Role role1 = this.getRole(r1);
        Role role2 = this.getRole(r2);
        if (role1 == null) {
            Base.handleUndefinedEntity(r1 + " is not a known property!");
            return false;
        }
        if (role2 == null) {
            Base.handleUndefinedEntity(r2 + " is not a known property!");
            return false;
        }
        if (!role1.isObjectRole() || !role2.isObjectRole()) {
            return false;
        }
        if (role1.getInverse().equals(role2)) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.makeTermAppl("_C_");
        ATermAppl notC = ATermUtils.makeNot(c);
        ATermAppl test = ATermUtils.makeAnd(c, ATermUtils.makeOr(ATermUtils.makeSomeValues(r1, ATermUtils.makeAllValues(r2, notC)), ATermUtils.makeSomeValues(r2, ATermUtils.makeAllValues(r1, notC))));
        return !this.getABox().isSatisfiable(test);
    }

    default public boolean isTransitiveProperty(ATermAppl r) {
        if (null == r) {
            return false;
        }
        Role role = this.getRole(r);
        if (role == null) {
            Base.handleUndefinedEntity(r + " is not a known property!");
            return false;
        }
        if (role.isTransitive()) {
            if (this.doExplanation()) {
                this.getABox().setExplanation(role.getExplainTransitive());
            }
            return true;
        }
        if (!role.isObjectRole() || role.isFunctional() || role.isInverseFunctional()) {
            return false;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.makeTermAppl("_C_");
        ATermAppl notC = ATermUtils.makeNot(c);
        ATermAppl test = ATermUtils.makeAnd(ATermUtils.makeSomeValues(r, ATermUtils.makeSomeValues(r, c)), ATermUtils.makeAllValues(r, notC));
        return !this.getABox().isSatisfiable(test);
    }

    default public boolean isSymmetricProperty(ATermAppl p) {
        return p != null && this.isInverse(p, p);
    }

    default public boolean isFunctionalProperty(ATermAppl p) {
        if (null == p) {
            return false;
        }
        Role role = this.getRole(p);
        if (role == null) {
            Base.handleUndefinedEntity(p + " is not a known property!");
            return false;
        }
        if (role.isAnnotationRole()) {
            return false;
        }
        if (role.isBottom()) {
            if (this.doExplanation()) {
                this.getABox().setExplanation(DependencySet.INDEPENDENT);
            }
            return true;
        }
        if (role.isFunctional()) {
            if (this.doExplanation()) {
                this.getABox().setExplanation(role.getExplainFunctional());
            }
            return true;
        }
        if (!role.isSimple()) {
            return false;
        }
        ATermAppl min2P = role.isDatatypeRole() ? ATermUtils.makeMin((ATerm)p, 2, (ATerm)ATermUtils.TOP_LIT) : ATermUtils.makeMin((ATerm)p, 2, (ATerm)ATermUtils.TOP);
        return !this.isSatisfiable(min2P);
    }

    default public boolean isInverseFunctionalProperty(ATermAppl p) {
        if (null == p) {
            return false;
        }
        Role role = this.getRole(p);
        if (role == null) {
            Base.handleUndefinedEntity(p + " is not a known property!");
            return false;
        }
        if (!role.isObjectRole()) {
            return false;
        }
        if (role.isInverseFunctional() || role.isBottom()) {
            if (this.doExplanation()) {
                this.getABox().setExplanation(role.getExplainInverseFunctional());
            }
            return true;
        }
        ATermAppl invP = role.getInverse().getName();
        ATermAppl max1invP = ATermUtils.makeMax((ATerm)invP, 1, (ATerm)ATermUtils.TOP);
        return this.isSubClassOf(ATermUtils.TOP, max1invP);
    }

    default public boolean hasDomain(ATermAppl p, ATermAppl c) {
        if (null == p || null == c) {
            return false;
        }
        Role r = this.getRBox().getRole(p);
        if (r == null) {
            Base.handleUndefinedEntity(p + " is not a property!");
            return false;
        }
        if (!this.isClass(c)) {
            Base.handleUndefinedEntity(c + " is not a valid class expression");
            return false;
        }
        ATermAppl someP = ATermUtils.makeSomeValues(p, ATermUtils.getTop(r));
        return this.isSubClassOf(someP, c);
    }

    default public boolean isReflexiveProperty(ATermAppl p) {
        if (null == p) {
            return false;
        }
        Role role = this.getRole(p);
        if (role == null) {
            Base.handleUndefinedEntity(p + " is not a known property!");
            return false;
        }
        if (!role.isObjectRole() || role.isIrreflexive()) {
            return false;
        }
        if (role.isReflexive()) {
            if (this.doExplanation()) {
                this.getABox().setExplanation(role.getExplainReflexive());
            }
            return true;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.makeTermAppl("_C_");
        ATermAppl notC = ATermUtils.makeNot(c);
        ATermAppl test = ATermUtils.makeAnd(c, ATermUtils.makeAllValues(p, notC));
        return !this.getABox().isSatisfiable(test);
    }

    default public boolean isIrreflexiveProperty(ATermAppl p) {
        if (null == p) {
            return false;
        }
        Role role = this.getRole(p);
        if (role == null) {
            Base.handleUndefinedEntity(p + " is not a known property!");
            return false;
        }
        if (!role.isObjectRole() || role.isReflexive()) {
            return false;
        }
        if (role.isIrreflexive()) {
            if (this.doExplanation()) {
                this.getABox().setExplanation(role.getExplainIrreflexive());
            }
            return true;
        }
        if (role.isAsymmetric()) {
            if (this.doExplanation()) {
                this.getABox().setExplanation(role.getExplainAsymmetric());
            }
            return true;
        }
        this.ensureConsistency();
        ATermAppl test = ATermUtils.makeSelf(p);
        return !this.getABox().isSatisfiable(test);
    }

    @Deprecated
    default public boolean isAntisymmetricProperty(ATermAppl p) {
        return this.isAsymmetricProperty(p);
    }

    default public boolean isAsymmetricProperty(ATermAppl p) {
        if (null == p) {
            return false;
        }
        Role role = this.getRole(p);
        if (role == null) {
            Base.handleUndefinedEntity(p + " is not a known property!");
            return false;
        }
        if (!role.isObjectRole()) {
            return false;
        }
        if (role.isAsymmetric()) {
            if (this.doExplanation()) {
                this.getABox().setExplanation(role.getExplainAsymmetric());
            }
            return true;
        }
        this.ensureConsistency();
        ATermAppl o = ATermUtils.makeAnonNominal(Integer.MAX_VALUE);
        ATermAppl nom = ATermUtils.makeValue(o);
        ATermAppl test = ATermUtils.makeAnd(nom, ATermUtils.makeSomeValues(p, ATermUtils.makeAnd(ATermUtils.makeNot(nom), ATermUtils.makeSomeValues(p, nom))));
        return !this.getABox().isSatisfiable(test);
    }

    default public Set<ATermAppl> getObjectProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.getRBox().getRoles().values()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isObjectRole()) continue;
            set.add(p);
        }
        return set;
    }

    default public Set<ATermAppl> getAnnotationProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.getRBox().getRoles().values()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isAnnotationRole()) continue;
            set.add(p);
        }
        return set;
    }

    default public Set<ATermAppl> getTransitiveProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.getRBox().getRoles().values()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isTransitive()) continue;
            set.add(p);
        }
        set.add(ATermUtils.BOTTOM_OBJECT_PROPERTY);
        return set;
    }

    default public Set<ATermAppl> getSymmetricProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.getRBox().getRoles().values()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isSymmetric()) continue;
            set.add(p);
        }
        return set;
    }

    @Deprecated
    default public Set<ATermAppl> getAntisymmetricProperties() {
        return this.getAsymmetricProperties();
    }

    default public Set<ATermAppl> getAsymmetricProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.getRBox().getRoles().values()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isAsymmetric()) continue;
            set.add(p);
        }
        return set;
    }

    default public Set<ATermAppl> getReflexiveProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.getRBox().getRoles().values()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isReflexive()) continue;
            set.add(p);
        }
        return set;
    }

    default public Set<ATermAppl> getIrreflexiveProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.getRBox().getRoles().values()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isIrreflexive()) continue;
            set.add(p);
        }
        return set;
    }

    default public Set<ATermAppl> getFunctionalProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.getRBox().getRoles().values()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isFunctional()) continue;
            set.add(p);
        }
        set.add(ATermUtils.BOTTOM_DATA_PROPERTY);
        set.add(ATermUtils.BOTTOM_OBJECT_PROPERTY);
        return set;
    }

    default public Set<ATermAppl> getInverseFunctionalProperties() {
        Set<ATermAppl> set = this.getRBox().getRoles().values().stream().filter(role -> {
            ATermAppl p = role.getName();
            return ATermUtils.isPrimitive(p) && role.isInverseFunctional();
        }).map(Role::getName).collect(Collectors.toSet());
        set.add(ATermUtils.BOTTOM_OBJECT_PROPERTY);
        return set;
    }

    default public Set<ATermAppl> getDataProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.getRBox().getRoles().values()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isDatatypeRole()) continue;
            set.add(p);
        }
        return set;
    }

    default public Set<ATermAppl> getRanges(ATerm name) {
        if (null == name) {
            return Collections.emptySet();
        }
        this.ensureConsistency();
        Set<ATermAppl> set = Collections.emptySet();
        Role prop = this.getRBox().getRole(name);
        if (prop == null) {
            Base.handleUndefinedEntity(name + " is not a property!");
            return set;
        }
        return ATermUtils.primitiveOrBottom(prop.getRanges());
    }

    default public Set<ATermAppl> getDomains(ATermAppl name) {
        if (null == name) {
            return Collections.emptySet();
        }
        this.ensureConsistency();
        Role prop = this.getRBox().getRole(name);
        if (prop == null) {
            Base.handleUndefinedEntity(name + " is not a property!");
            return Collections.emptySet();
        }
        return ATermUtils.primitiveOrBottom(prop.getDomains());
    }

    default public Set<ATermAppl> getObjectPropertyValuesSet(ATermAppl r, ATermAppl x) {
        if (null == r || null == x) {
            return Collections.emptySet();
        }
        this.ensureConsistency();
        Role role = this.getRBox().getRole(r);
        if (role == null || !role.isObjectRole()) {
            Base.handleUndefinedEntity(r + " is not a known object property!");
            return Collections.emptySet();
        }
        if (!this.isIndividual(x)) {
            Base.handleUndefinedEntity(x + " is not a known individual!");
            return Collections.emptySet();
        }
        HashSet<ATermAppl> knowns = new HashSet();
        HashSet<ATermAppl> unknowns = new HashSet<ATermAppl>();
        if (role.isTop()) {
            if (!OpenlletOptions.HIDE_TOP_PROPERTY_VALUES) {
                knowns = this.getIndividuals();
            }
        } else if (!role.isBottom()) {
            this.getABox().getObjectPropertyValues(x, role, knowns, unknowns, true);
        }
        if (!unknowns.isEmpty()) {
            ATermAppl valueX = ATermUtils.makeHasValue(role.getInverse().getName(), x);
            ATermAppl c = ATermUtils.normalize(valueX);
            this.binaryInstanceRetrieval(c, new ArrayList<ATermAppl>(unknowns), knowns);
        }
        return knowns;
    }

    default public List<ATermAppl> getObjectPropertyValues(ATermAppl r, ATermAppl x) {
        return new ArrayList<ATermAppl>(this.getObjectPropertyValuesSet(r, x));
    }

    default public Stream<ATermAppl> objectPropertyValues(ATermAppl r, ATermAppl x) {
        return this.getObjectPropertyValuesSet(r, x).stream();
    }

    default public List<ATermAppl> getDataPropertyValues(ATermAppl r, ATermAppl x, ATermAppl datatype) {
        if (null == r || null == x) {
            return Collections.emptyList();
        }
        this.ensureConsistency();
        Individual ind = this.getABox().getIndividual(x);
        Role role = this.getRBox().getRole(r);
        if (ind == null) {
            Base.handleUndefinedEntity(x + " is not an individual!");
            return Collections.emptyList();
        }
        if (role == null || !role.isDatatypeRole()) {
            Base.handleUndefinedEntity(r + " is not a known data property!");
            return Collections.emptyList();
        }
        if (role.isTop()) {
            ArrayList<ATermAppl> literals = new ArrayList<ATermAppl>();
            if (!OpenlletOptions.HIDE_TOP_PROPERTY_VALUES) {
                for (Node node : this.getABox().getNodes().values()) {
                    if (!node.isLiteral() || node.getTerm() == null) continue;
                    literals.add(node.getTerm());
                }
            }
            return literals;
        }
        if (role.isBottom()) {
            return Collections.emptyList();
        }
        return this.getABox().getDataPropertyValues(x, role, datatype);
    }

    default public List<ATermAppl> getIndividualsWithObjectProperty(ATermAppl r, ATermAppl o) {
        if (null == r || null == o) {
            return Collections.emptyList();
        }
        this.ensureConsistency();
        if (!this.isIndividual(o)) {
            Base.handleUndefinedEntity(o + " is not an individual!");
            return Collections.emptyList();
        }
        Role role = this.getRBox().getRole(r);
        ATermAppl invR = role.getInverse().getName();
        return this.getObjectPropertyValues(invR, o);
    }

    default public List<ATermAppl> getIndividualsWithDataProperty(ATermAppl r, ATermAppl litValue) {
        ATermAppl canonicalLit;
        if (null == r || null == litValue) {
            return Collections.emptyList();
        }
        if (!ATermUtils.isLiteral(litValue)) {
            return Collections.emptyList();
        }
        this.ensureConsistency();
        ArrayList<ATermAppl> knowns = new ArrayList<ATermAppl>();
        ArrayList<ATermAppl> unknowns = new ArrayList<ATermAppl>();
        try {
            canonicalLit = this.getDatatypeReasoner().getCanonicalRepresentation(litValue);
        }
        catch (InvalidLiteralException e) {
            this.getLogger().warning(String.format("Invalid literal '%s' passed as input, returning empty set of _individuals: %s", litValue, e.getMessage()));
            return Collections.emptyList();
        }
        catch (UnrecognizedDatatypeException e) {
            this.getLogger().warning(String.format("Unrecognized datatype for literal '%s' passed as input, returning empty set of _individuals: %s", litValue, e.getMessage()));
            return Collections.emptyList();
        }
        Literal literal = this.getABox().getLiteral(canonicalLit);
        if (literal != null) {
            Role role = this.getRole(r);
            EdgeList edges = literal.getInEdges();
            for (Edge edge : edges) {
                if (!edge.getRole().isSubRoleOf(role)) continue;
                ATermAppl subj = edge.getFrom().getName();
                if (edge.getDepends().isIndependent()) {
                    knowns.add(subj);
                    continue;
                }
                unknowns.add(subj);
            }
            if (!unknowns.isEmpty()) {
                ATermAppl c = ATermUtils.normalize(ATermUtils.makeHasValue(r, litValue));
                this.binaryInstanceRetrieval(c, unknowns, knowns);
            }
        }
        return knowns;
    }

    default public Set<ATermAppl> getIndividualsWithAnnotation(ATermAppl p, ATermAppl o) {
        if (null == p || null == o) {
            return Collections.emptySet();
        }
        HashSet<ATermAppl> ret = new HashSet<ATermAppl>();
        for (Map.Entry<ATermAppl, Map<ATermAppl, Set<ATermAppl>>> e1 : this.getAnnotations().entrySet()) {
            ATermAppl st = e1.getKey();
            Map<ATermAppl, Set<ATermAppl>> pidx = e1.getValue();
            for (Map.Entry<ATermAppl, Set<ATermAppl>> e2 : pidx.entrySet()) {
                ATermAppl pt = e2.getKey();
                Set<ATermAppl> oidx = e2.getValue();
                if (!pt.equals(p) || !oidx.contains(o)) continue;
                ret.add(st);
            }
        }
        return ret;
    }

    default public List<ATermAppl> getIndividualsWithProperty(ATermAppl r, ATermAppl x) {
        Role role = this.getRBox().getRole(r);
        if (role == null) {
            Base.handleUndefinedEntity(r + " is not a known property!");
            return Collections.emptyList();
        }
        if (role.isObjectRole()) {
            return this.getIndividualsWithObjectProperty(r, x);
        }
        if (role.isDatatypeRole()) {
            return this.getIndividualsWithDataProperty(r, x);
        }
        if (role.isAnnotationRole()) {
            return Arrays.asList(this.getIndividualsWithAnnotation(r, x).toArray(new ATermAppl[0]));
        }
        throw new IllegalArgumentException();
    }

    default public List<ATermAppl> getDataPropertyValues(ATermAppl r, ATermAppl x, String lang) {
        if (null == r || null == x) {
            return Collections.emptyList();
        }
        List<ATermAppl> values = this.getDataPropertyValues(r, x);
        if (lang == null) {
            return values;
        }
        ArrayList<ATermAppl> result = new ArrayList<ATermAppl>();
        for (ATermAppl lit : values) {
            String litLang = ((ATermAppl)lit.getArgument(1)).getName();
            if (!litLang.equals(lang)) continue;
            result.add(lit);
        }
        return result;
    }

    default public List<ATermAppl> getDataPropertyValues(ATermAppl r, ATermAppl x) {
        return this.getDataPropertyValues(r, x, (ATermAppl)null);
    }

    default public List<ATermAppl> getPropertyValues(ATermAppl r, ATermAppl x) {
        if (null == r || null == x) {
            return Collections.emptyList();
        }
        Role role = this.getRBox().getRole(r);
        if (role == null || role.isUntypedRole()) {
            Base.handleUndefinedEntity(r + " is not a known property!");
            return Collections.emptyList();
        }
        if (role.isObjectRole()) {
            return this.getObjectPropertyValues(r, x);
        }
        if (role.isDatatypeRole()) {
            return this.getDataPropertyValues(r, x);
        }
        if (role.isAnnotationRole()) {
            Set<ATermAppl> values = this.getAnnotations(x, r);
            return values.isEmpty() ? Collections.emptyList() : Arrays.asList(values.toArray(new ATermAppl[0]));
        }
        throw new IllegalArgumentException();
    }

    default public Map<ATermAppl, List<ATermAppl>> getPropertyValues(ATermAppl pred) {
        if (null == pred) {
            return Collections.emptyMap();
        }
        HashMap<ATermAppl, List<ATermAppl>> result = new HashMap<ATermAppl, List<ATermAppl>>();
        for (ATermAppl subj : this.currentIndividuals()) {
            List<ATermAppl> objects = this.getPropertyValues(pred, subj);
            if (objects.isEmpty()) continue;
            result.put(subj, objects);
        }
        return result;
    }

    default public List<ATermAppl> getProperties(ATermAppl s, ATermAppl o) {
        if (!this.isIndividual(s)) {
            Base.handleUndefinedEntity(s + " is not an individual!");
            return Collections.emptyList();
        }
        if (!this.isIndividual(o) && !ATermUtils.isLiteral(o)) {
            Base.handleUndefinedEntity(o + " is not an individual!");
            return Collections.emptyList();
        }
        ArrayList<ATermAppl> props = new ArrayList<ATermAppl>();
        Set<ATermAppl> allProps = ATermUtils.isLiteral(o) ? this.getDataProperties() : this.getObjectProperties();
        for (ATermAppl p : allProps) {
            if (!this.getABox().hasPropertyValue(s, p, o)) continue;
            props.add(p);
        }
        return props;
    }

    default public Set<ATermAppl> getSubAnnotationProperties(ATermAppl p) {
        if (null == p) {
            return Collections.emptySet();
        }
        HashSet<ATermAppl> values = new HashSet<ATermAppl>();
        ArrayList<ATermAppl> temp = new ArrayList<ATermAppl>();
        temp.add(p);
        while (!temp.isEmpty()) {
            ATermAppl value = (ATermAppl)temp.remove(0);
            values.add(value);
            for (ATermAppl property : this.getAnnotationProperties()) {
                if (value == property || !this.isSubPropertyOf(property, value)) continue;
                temp.add(property);
            }
        }
        return values;
    }

    default public Set<ATermAppl> getAnnotations(ATermAppl s, ATermAppl p) {
        if (null == s || null == p) {
            return Collections.emptySet();
        }
        Map<ATermAppl, Set<ATermAppl>> pidx = this.getAnnotations().get(s);
        if (pidx == null) {
            return Collections.emptySet();
        }
        HashSet<ATermAppl> values = new HashSet<ATermAppl>();
        for (ATermAppl subproperty : this.getSubAnnotationProperties(p)) {
            if (pidx.get(subproperty) == null) continue;
            for (ATermAppl value : pidx.get(subproperty)) {
                values.add(value);
            }
        }
        return values;
    }
}

