/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import openllet.core.boxes.abox.ABox;
import openllet.core.rules.BindingGenerator;
import openllet.core.rules.BindingGeneratorImpl;
import openllet.core.rules.BindingGeneratorStrategy;
import openllet.core.rules.BindingHelper;
import openllet.core.rules.DataRangeBindingHelper;
import openllet.core.rules.DatavaluePropertyBindingHelper;
import openllet.core.rules.ObjectVariableBindingHelper;
import openllet.core.rules.TrivialSatisfactionHelpers;
import openllet.core.rules.VariableBinding;
import openllet.core.rules.VariableUtils;
import openllet.core.rules.builtins.BuiltIn;
import openllet.core.rules.builtins.BuiltInRegistry;
import openllet.core.rules.model.AtomDVariable;
import openllet.core.rules.model.AtomIVariable;
import openllet.core.rules.model.AtomVariable;
import openllet.core.rules.model.BuiltInAtom;
import openllet.core.rules.model.DataRangeAtom;
import openllet.core.rules.model.DatavaluedPropertyAtom;
import openllet.core.rules.model.Rule;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.model.RuleAtomVisitor;

public class BindingGeneratorStrategyImpl
implements BindingGeneratorStrategy {
    private final ABox _abox;

    public BindingGeneratorStrategyImpl(ABox abox) {
        this._abox = abox;
    }

    @Override
    public BindingGenerator createGenerator(Rule rule) {
        return this.createGenerator(rule, new VariableBinding(this._abox));
    }

    @Override
    public BindingGenerator createGenerator(Rule rule, VariableBinding initialBinding) {
        BodyAtomsToSelectiveHelpersVisitor selectiveVisitor = new BodyAtomsToSelectiveHelpersVisitor();
        HashSet<AtomIVariable> instanceVariables = new HashSet<AtomIVariable>();
        HashSet<AtomDVariable> dataVariables = new HashSet<AtomDVariable>();
        for (RuleAtom ruleAtom : rule.getBody()) {
            ruleAtom.accept(selectiveVisitor);
            instanceVariables.addAll(VariableUtils.getIVars(ruleAtom));
            dataVariables.addAll(VariableUtils.getDVars(ruleAtom));
        }
        List<BindingHelper> helpers = selectiveVisitor.getHelpers();
        HashSet<? extends AtomVariable> selectiveVariables = new HashSet<AtomVariable>();
        for (BindingHelper helper : helpers) {
            Set<AtomVariable> emptyCollection = Collections.emptySet();
            selectiveVariables.addAll(helper.getBindableVars(emptyCollection));
        }
        for (AtomIVariable var : instanceVariables) {
            if (selectiveVariables.contains(var)) continue;
            helpers.add(new ObjectVariableBindingHelper(this._abox, var));
        }
        helpers.addAll(new TrivialSatisfactionHelpers(this._abox).getHelpers(rule));
        if (!BindingGeneratorStrategyImpl.ensureOrdering(helpers)) {
            BindingGenerator._logger.warning("IGNORING RULE " + rule + ": Could not generate safe ordering for body constraints.");
            return new BindingGeneratorImpl();
        }
        BindingGeneratorStrategyImpl.optimize(helpers);
        return new BindingGeneratorImpl(initialBinding, helpers);
    }

    private static boolean ensureOrdering(List<BindingHelper> helpers) {
        ArrayList<BindingHelper> unsatList = new ArrayList<BindingHelper>();
        HashSet<AtomVariable> bound = new HashSet<AtomVariable>();
        ListIterator<BindingHelper> listIter = helpers.listIterator();
        while (listIter.hasNext()) {
            BindingHelper helper = listIter.next();
            if (bound.containsAll(helper.getPrerequisiteVars(bound))) {
                bound.addAll(helper.getBindableVars(bound));
                ListIterator unsatIter = unsatList.listIterator();
                while (unsatIter.hasNext()) {
                    BindingHelper unsat = (BindingHelper)unsatIter.next();
                    if (!bound.containsAll(unsat.getPrerequisiteVars(bound))) continue;
                    listIter.add(unsat);
                    bound.addAll(unsat.getBindableVars(bound));
                    unsatIter.remove();
                }
                continue;
            }
            unsatList.add(helper);
            listIter.remove();
        }
        return unsatList.size() == 0;
    }

    private static void optimize(List<BindingHelper> helpers) {
        HashSet<AtomVariable> bound = new HashSet<AtomVariable>();
        for (int i = 0; i < helpers.size(); ++i) {
            int j = 0;
            while (i + j < helpers.size()) {
                BindingHelper helper = helpers.get(i + j);
                if (bound.containsAll(helper.getBindableVars(bound)) && bound.containsAll(helper.getPrerequisiteVars(bound))) {
                    helpers.remove(i + j);
                    helpers.add(i, helper);
                    ++i;
                    continue;
                }
                ++j;
            }
            if (i >= helpers.size()) continue;
            bound.addAll(helpers.get(i).getBindableVars(bound));
        }
    }

    private class BodyAtomsToSelectiveHelpersVisitor
    implements RuleAtomVisitor {
        private final List<BindingHelper> helpers = new ArrayList<BindingHelper>();

        private BodyAtomsToSelectiveHelpersVisitor() {
        }

        public List<BindingHelper> getHelpers() {
            return this.helpers;
        }

        @Override
        public void visit(BuiltInAtom atom) {
            BuiltIn builtIn = BuiltInRegistry.instance.getBuiltIn((String)atom.getPredicate());
            this.helpers.add(builtIn.createHelper(atom));
        }

        @Override
        public void visit(DataRangeAtom atom) {
            this.helpers.add(new DataRangeBindingHelper(BindingGeneratorStrategyImpl.this._abox, atom));
        }

        @Override
        public void visit(DatavaluedPropertyAtom atom) {
            this.helpers.add(new DatavaluePropertyBindingHelper(BindingGeneratorStrategyImpl.this._abox, atom));
        }
    }
}

