/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.builtins;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import openllet.core.boxes.abox.ABoxImpl;
import openllet.core.rules.builtins.BooleanOperators;
import openllet.core.rules.builtins.BuiltIn;
import openllet.core.rules.builtins.ComparisonTesters;
import openllet.core.rules.builtins.DateTimeOperators;
import openllet.core.rules.builtins.Function;
import openllet.core.rules.builtins.FunctionBuiltIn;
import openllet.core.rules.builtins.GeneralFunction;
import openllet.core.rules.builtins.GeneralFunctionBuiltIn;
import openllet.core.rules.builtins.NoSuchBuiltIn;
import openllet.core.rules.builtins.NumericAdapter;
import openllet.core.rules.builtins.NumericFunction;
import openllet.core.rules.builtins.NumericOperators;
import openllet.core.rules.builtins.StringOperators;
import openllet.core.rules.builtins.Tester;
import openllet.core.rules.builtins.TesterBuiltIn;
import openllet.core.rules.builtins.URIOperators;
import openllet.shared.tools.Log;
import openllet.shared.tools.Logging;

public class BuiltInRegistry
implements Logging {
    protected static final Logger _logger = Log.getLogger(ABoxImpl.class);
    public static final BuiltInRegistry instance = new BuiltInRegistry();
    private final Map<String, BuiltIn> builtIns = new HashMap<String, BuiltIn>();

    private BuiltInRegistry() {
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#equal", BuiltInRegistry.tester(ComparisonTesters.equal));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#greaterThan", BuiltInRegistry.tester(ComparisonTesters.greaterThan));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#greaterThanOrEqual", BuiltInRegistry.tester(ComparisonTesters.greaterThanOrEqual));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#lessThan", BuiltInRegistry.tester(ComparisonTesters.lessThan));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#lessThanOrEqual", BuiltInRegistry.tester(ComparisonTesters.lessThanOrEqual));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#notEqual", BuiltInRegistry.tester(ComparisonTesters.notEqual));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#date", BuiltInRegistry.generalFunc(DateTimeOperators.date));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#dateTime", BuiltInRegistry.generalFunc(DateTimeOperators.dateTime));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#dayTimeDuration", BuiltInRegistry.function(DateTimeOperators.dayTimeDuration));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#time", BuiltInRegistry.generalFunc(DateTimeOperators.time));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#yearMonthDuration", BuiltInRegistry.function(DateTimeOperators.yearMonthDuration));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#resolveURI", BuiltInRegistry.function(URIOperators.resolveURI));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#anyURI", BuiltInRegistry.function(URIOperators.anyURI));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#abs", BuiltInRegistry.numeric(NumericOperators.abs));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#add", BuiltInRegistry.numeric(NumericOperators.add));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#ceiling", BuiltInRegistry.numeric(NumericOperators.ceiling));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#cos", BuiltInRegistry.numeric(NumericOperators.cos));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#divide", BuiltInRegistry.numeric(NumericOperators.divide));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#floor", BuiltInRegistry.numeric(NumericOperators.floor));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#integerDivide", BuiltInRegistry.numeric(NumericOperators.integerDivide));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#mod", BuiltInRegistry.numeric(NumericOperators.mod));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#multiply", BuiltInRegistry.numeric(NumericOperators.multiply));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#pow", BuiltInRegistry.numeric(NumericOperators.pow));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#round", BuiltInRegistry.numeric(NumericOperators.round));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#roundHalfToEven", BuiltInRegistry.numeric(NumericOperators.roundHalfToEven));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#sin", BuiltInRegistry.numeric(NumericOperators.sin));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#subtract", BuiltInRegistry.numeric(NumericOperators.subtract));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#tan", BuiltInRegistry.numeric(NumericOperators.tan));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#unaryMinus", BuiltInRegistry.numeric(NumericOperators.unaryMinus));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#unaryPlus", BuiltInRegistry.numeric(NumericOperators.unaryPlus));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#contains", BuiltInRegistry.tester(StringOperators.contains));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#containsIgnoreCase", BuiltInRegistry.tester(StringOperators.containsIgnoreCase));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#endsWith", BuiltInRegistry.tester(StringOperators.endsWith));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#lowerCase", BuiltInRegistry.function(StringOperators.lowerCase));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#matches", BuiltInRegistry.tester(StringOperators.matches));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#normalizeSpace", BuiltInRegistry.function(StringOperators.normalizeSpace));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#replace", BuiltInRegistry.function(StringOperators.replace));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#startsWith", BuiltInRegistry.tester(StringOperators.startsWith));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#stringConcat", BuiltInRegistry.function(StringOperators.stringConcat));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#stringEqualIgnoreCase", BuiltInRegistry.tester(StringOperators.stringEqualIgnoreCase));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#stringLength", BuiltInRegistry.function(StringOperators.stringLength));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#substring", BuiltInRegistry.function(StringOperators.substring));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#substringAfter", BuiltInRegistry.function(StringOperators.substringAfter));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#substringBefore", BuiltInRegistry.function(StringOperators.substringBefore));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#tokenize", StringOperators.tokenize);
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#translate", BuiltInRegistry.function(StringOperators.translate));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#upperCase", BuiltInRegistry.function(StringOperators.upperCase));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#booleanNot", BuiltInRegistry.generalFunc(BooleanOperators.booleanNot));
    }

    @Override
    public Logger getLogger() {
        return _logger;
    }

    public BuiltIn getBuiltIn(String name) {
        BuiltIn builtIn = this.builtIns.get(name);
        if (builtIn == null) {
            builtIn = NoSuchBuiltIn.instance;
        }
        return builtIn;
    }

    private static BuiltIn function(Function function) {
        return new FunctionBuiltIn(function);
    }

    private static BuiltIn generalFunc(GeneralFunction function) {
        return new GeneralFunctionBuiltIn(function);
    }

    private static BuiltIn numeric(NumericFunction numeric) {
        return BuiltInRegistry.function(new NumericAdapter(numeric));
    }

    public void registerBuiltIn(String name, BuiltIn builtIn) {
        this.builtIns.put(name, builtIn);
    }

    private static BuiltIn tester(Tester tester) {
        return new TesterBuiltIn(tester);
    }
}

