/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.builtins;

import java.math.BigDecimal;
import java.math.BigInteger;
import openllet.core.rules.builtins.NumericComparisonVisitor;
import openllet.core.rules.builtins.NumericFunction;
import openllet.core.rules.builtins.NumericPromotion;
import openllet.core.rules.builtins.NumericVisitor;

public class FunctionApplicationVisitor
implements NumericVisitor {
    private final NumericFunction _function;
    private Number _result;

    public FunctionApplicationVisitor(NumericFunction function) {
        this(function, null);
    }

    public FunctionApplicationVisitor(NumericFunction function, Number expected) {
        this._function = function;
        this._result = expected;
    }

    public Number getResult() {
        return this._result;
    }

    private void testAndSetResult(Number theResult) {
        if (this._result == null) {
            this._result = theResult;
        } else {
            NumericComparisonVisitor visitor = new NumericComparisonVisitor();
            NumericPromotion promoter = new NumericPromotion();
            promoter.promote(this._result, theResult);
            promoter.accept(visitor);
            this._result = visitor.getComparison() == 0 ? theResult : null;
        }
    }

    @Override
    public void visit(BigDecimal[] args) {
        this.testAndSetResult(this._function.apply(args));
    }

    @Override
    public void visit(BigInteger[] args) {
        this.testAndSetResult(this._function.apply(args));
    }

    @Override
    public void visit(Double[] args) {
        this.testAndSetResult(this._function.apply(args));
    }

    @Override
    public void visit(Float[] args) {
        this.testAndSetResult(this._function.apply(args));
    }
}

