/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.builtins;

import java.util.Collection;
import java.util.Collections;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Literal;
import openllet.core.rules.BindingHelper;
import openllet.core.rules.VariableBinding;
import openllet.core.rules.VariableUtils;
import openllet.core.rules.builtins.BuiltIn;
import openllet.core.rules.builtins.Tester;
import openllet.core.rules.model.AtomDObject;
import openllet.core.rules.model.AtomVariable;
import openllet.core.rules.model.BuiltInAtom;

public class TesterBuiltIn
implements BuiltIn {
    private final Tester _test;

    public TesterBuiltIn(Tester test) {
        this._test = test;
    }

    @Override
    public BindingHelper createHelper(BuiltInAtom atom) {
        return new TestHelper(atom);
    }

    @Override
    public boolean apply(ABox abox, Literal[] args) {
        return this._test.test(args);
    }

    private class TestHelper
    implements BindingHelper {
        private final BuiltInAtom _atom;
        private boolean _result;

        public TestHelper(BuiltInAtom atom) {
            this._atom = atom;
            this._result = false;
        }

        @Override
        public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
            return Collections.emptySet();
        }

        @Override
        public Collection<? extends AtomVariable> getPrerequisiteVars(Collection<AtomVariable> bound) {
            return VariableUtils.getVars(this._atom);
        }

        @Override
        public void rebind(VariableBinding newBinding) {
            Literal[] arguments = new Literal[this._atom.getAllArguments().size()];
            int i = 0;
            for (AtomDObject obj : this._atom.getAllArguments()) {
                arguments[i++] = newBinding.get(obj);
            }
            this._result = TesterBuiltIn.this._test.test(arguments);
        }

        @Override
        public boolean selectNextBinding() {
            if (this._result) {
                this._result = false;
                return true;
            }
            return false;
        }

        @Override
        public void setCurrentBinding(VariableBinding currentBinding) {
        }
    }
}

