/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.core.rules.RulesToATermTranslator;
import openllet.core.rules.model.RuleAtom;
import openllet.core.utils.ATermUtils;

public class Rule {
    private final ATermAppl _name;
    private final List<? extends RuleAtom> _body;
    private final List<? extends RuleAtom> _head;
    private volatile Set<ATermAppl> _explanation;

    public Rule(List<? extends RuleAtom> head, List<? extends RuleAtom> body) {
        this(head, body, null);
    }

    public Rule(List<? extends RuleAtom> head, List<? extends RuleAtom> body, Set<ATermAppl> explanation) {
        this(null, head, body, explanation);
    }

    public Rule(ATermAppl name, List<? extends RuleAtom> head, List<? extends RuleAtom> body) {
        this(name, head, body, null);
    }

    public Rule(ATermAppl name, List<? extends RuleAtom> head, List<? extends RuleAtom> body, Set<ATermAppl> explanation) {
        this._name = name;
        this._body = body;
        this._head = head;
        this._explanation = explanation;
    }

    public Set<ATermAppl> getExplanation(RulesToATermTranslator translator) {
        if (this._explanation == null) {
            this._explanation = Collections.singleton(translator.translate(this));
        }
        return this._explanation;
    }

    public boolean equals(Object other) {
        if (other != null && this.getClass().equals(other.getClass())) {
            Rule rule = (Rule)other;
            return this.getHead().equals(rule.getHead()) && this.getBody().equals(rule.getBody());
        }
        return false;
    }

    public Collection<? extends RuleAtom> getBody() {
        return this._body;
    }

    public Collection<? extends RuleAtom> getHead() {
        return this._head;
    }

    public ATermAppl getName() {
        return this._name;
    }

    public int hashCode() {
        return this.getBody().hashCode() + this.getHead().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Rule(");
        if (this._name != null) {
            sb.append(ATermUtils.toString(this._name));
            sb.append(" ");
        }
        sb.append(this.getBody());
        sb.append(" => ");
        sb.append(this.getHead());
        sb.append(")");
        return sb.toString();
    }
}

