/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import java.util.ArrayList;
import java.util.Iterator;
import openllet.core.DependencySet;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.DefaultEdge;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.rules.model.AtomVariable;
import openllet.core.rules.model.BinaryAtom;
import openllet.core.rules.model.DatavaluedPropertyAtom;
import openllet.core.rules.model.IndividualPropertyAtom;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.rete.AlphaNode;
import openllet.core.rules.rete.WME;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.iterator.IteratorUtils;
import openllet.core.utils.iterator.NestedIterator;

public class AlphaEdgeNode
extends AlphaNode {
    protected final Role _role;

    public AlphaEdgeNode(ABox abox, Role role) {
        super(abox);
        this._role = role;
    }

    public Role getRole() {
        return this._role;
    }

    protected WME.EdgeDirection edgeMatches(Edge edge) {
        boolean isBwd;
        Role edgeRole = edge.getRole();
        boolean isFwd = edgeRole.isSubRoleOf(this._role);
        boolean bl = isBwd = this._role.getInverse() != null && edgeRole.isSubRoleOf(this._role.getInverse());
        return isFwd ? (isBwd ? WME.EdgeDirection.BOTH : WME.EdgeDirection.FORWARD) : (isBwd ? WME.EdgeDirection.BACKWARD : null);
    }

    protected WME createEdge(Edge edge, WME.EdgeDirection dir) {
        if (this._doExplanation) {
            DependencySet ds;
            DependencySet dependencySet = ds = dir == WME.EdgeDirection.FORWARD ? this._role.getExplainSub(edge.getRole().getName()) : this._role.getInverse().getExplainSub(edge.getRole().getName());
            if (!ds.getExplain().isEmpty()) {
                return WME.createEdge(new DefaultEdge(edge.getRole(), edge.getFrom(), edge.getTo(), edge.getDepends().union(ds, this._doExplanation)), dir);
            }
        }
        return WME.createEdge(edge, dir);
    }

    public boolean activate(Edge edge) {
        WME.EdgeDirection dir = this.edgeMatches(edge);
        if (dir != null) {
            if (dir == WME.EdgeDirection.BOTH) {
                this.activate(this.createEdge(edge, WME.EdgeDirection.FORWARD));
            } else {
                this.activate(this.createEdge(edge, dir));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(RuleAtom atom) {
        return (atom instanceof IndividualPropertyAtom || atom instanceof DatavaluedPropertyAtom) && atom.getPredicate().equals(this._role.getName()) && ((BinaryAtom)atom).getArgument1() instanceof AtomVariable && ((BinaryAtom)atom).getArgument2() instanceof AtomVariable;
    }

    @Override
    public Iterator<WME> getMatches(int argIndex, Node arg) {
        return argIndex == 0 ? this.getMatches((Individual)arg, this._role, null) : this.getMatches(null, this._role, arg);
    }

    protected Iterator<WME> getMatches(Individual s, Role r, Node o) {
        Iterator<Object> i1 = IteratorUtils.emptyIterator();
        Iterator<WME> i2 = IteratorUtils.emptyIterator();
        Role invRole = this._role.getInverse();
        if (s != null) {
            i1 = this.toWMEs(AlphaEdgeNode.getEdges(s.getOutEdges(), this._role, o), WME.EdgeDirection.FORWARD);
            if (invRole != null) {
                i2 = this.toWMEs(AlphaEdgeNode.getEdges(s.getInEdges(), invRole, o), WME.EdgeDirection.BACKWARD);
            }
        } else {
            assert (s == null);
            i1 = this.toWMEs(AlphaEdgeNode.getEdges(o.getInEdges(), this._role, null), WME.EdgeDirection.FORWARD);
            if (invRole != null) {
                i2 = this.toWMEs(AlphaEdgeNode.getEdges(((Individual)o).getOutEdges(), invRole, null), WME.EdgeDirection.BACKWARD);
            }
        }
        return !i1.hasNext() ? i2 : (!i2.hasNext() ? i1 : IteratorUtils.concat(i1, i2));
    }

    private static EdgeList getEdges(EdgeList edges, Role r, Node o) {
        return o == null ? edges.getEdges(r) : edges.getEdgesTo(r, o);
    }

    @Override
    public Iterator<WME> getMatches() {
        return new NestedIterator<Individual, WME>((Iterator)this._abox.getIndIterator()){

            @Override
            public Iterator<WME> getInnerIterator(Individual ind) {
                return AlphaEdgeNode.this.toWMEs(ind.getOutEdges().getEdges(AlphaEdgeNode.this._role), WME.EdgeDirection.FORWARD);
            }
        };
    }

    protected Iterator<WME> toWMEs(EdgeList edges, WME.EdgeDirection dir) {
        if (edges.isEmpty()) {
            return IteratorUtils.emptyIterator();
        }
        if (edges.size() == 1) {
            Edge edge = (Edge)edges.get(0);
            return IteratorUtils.singletonIterator(this.createEdge(edge, dir));
        }
        ArrayList<WME> wmes = new ArrayList<WME>(edges.size());
        for (Edge edge : edges) {
            wmes.add(this.createEdge(edge, dir));
        }
        return wmes.iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._role.getName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        AlphaEdgeNode other = (AlphaEdgeNode)obj;
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this._role.equals(other._role);
    }

    public String toString() {
        return ATermUtils.toString(this._role.getName()) + "(0, 1)";
    }
}

