/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import java.util.Arrays;
import openllet.core.DependencySet;
import openllet.core.rules.rete.WME;

public abstract class Token {
    public abstract WME get(int var1);

    public abstract DependencySet getDepends(boolean var1);

    public abstract boolean dependsOn(int var1);

    public static Token create(WME wme, Token token) {
        return new ArrayToken(wme, (ArrayToken)token);
    }

    private static class ArrayToken
    extends Token {
        private final WME[] _wmes;

        public ArrayToken(WME wme, ArrayToken tok) {
            int l = tok == null ? 0 : tok._wmes.length;
            this._wmes = tok == null ? new WME[1] : Arrays.copyOf(tok._wmes, l + 1);
            this._wmes[l] = wme;
        }

        @Override
        public WME get(int index) {
            if (index >= this._wmes.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this._wmes[index];
        }

        @Override
        public DependencySet getDepends(boolean doExplanation) {
            DependencySet ds = DependencySet.INDEPENDENT;
            for (WME wme : this._wmes) {
                ds = ds.union(wme.getDepends(), doExplanation);
            }
            return ds;
        }

        @Override
        public boolean dependsOn(int branch) {
            for (WME wme : this._wmes) {
                if (!wme.dependsOn(branch)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return Arrays.toString(this._wmes);
        }
    }

    private static class ListToken
    extends Token {
        private final ListToken _next;
        private final WME _wme;
        private final int _index;

        public ListToken(WME wme, ListToken tok) {
            this._wme = wme;
            this._next = tok;
            this._index = tok == null ? 0 : tok._index + 1;
        }

        @Override
        public WME get(int index) {
            ListToken t = this;
            while (t != null) {
                if (t._index == index) {
                    return t._wme;
                }
                t = t._next;
            }
            throw new IndexOutOfBoundsException(index + " > " + this._index);
        }

        @Override
        public DependencySet getDepends(boolean doExplanation) {
            DependencySet ds = DependencySet.INDEPENDENT;
            ListToken t = this;
            while (t != null) {
                ds = ds.union(t._wme.getDepends(), doExplanation);
                t = t._next;
            }
            return ds;
        }

        @Override
        public boolean dependsOn(int branch) {
            ListToken t = this;
            while (t != null) {
                if (t._wme.dependsOn(branch)) {
                    return true;
                }
                t = t._next;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            ListToken t = this;
            while (t != null) {
                sb.append(t._wme.toString());
                sb.append(',');
                t = t._next;
            }
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }
    }
}

