/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.branch;

import java.util.HashSet;
import java.util.logging.Level;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.tableau.branch.Branch;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.utils.ATermUtils;

public class DisjunctionBranch
extends Branch {
    protected final Node _node;
    protected final ATermAppl _disjunction;
    private volatile ATermAppl[] _allDisjonctions;
    protected volatile DependencySet[] _prevDS;
    protected volatile int[] _order;

    public DisjunctionBranch(ABox abox, CompletionStrategy completion, Node node, ATermAppl disjunction, DependencySet ds, ATermAppl[] disj) {
        super(abox, completion, ds, disj.length);
        this._node = node;
        this._disjunction = disjunction;
        this.setDisj(disj);
        this._prevDS = new DependencySet[disj.length];
        this._order = new int[disj.length];
        for (int i = 0; i < disj.length; ++i) {
            this._order[i] = i;
        }
    }

    public DisjunctionBranch(DisjunctionBranch dr, ABox abox) {
        super(abox, dr._allDisjonctions.length, dr);
        this._node = abox.getNode(dr._node.getName());
        this._disjunction = dr._disjunction;
        this._allDisjonctions = dr._allDisjonctions;
        this._prevDS = new DependencySet[dr._allDisjonctions.length];
        System.arraycopy(dr._prevDS, 0, this._prevDS, 0, dr._allDisjonctions.length);
        this._order = new int[dr._allDisjonctions.length];
        System.arraycopy(dr._order, 0, this._order, 0, dr._allDisjonctions.length);
    }

    @Override
    public Node getNode() {
        return this._node;
    }

    protected String getDebugMsg() {
        return "DISJ: Branch (" + this.getBranchIndexInABox() + ") try (" + (this.getTryNext() + 1) + "/" + this.getTryCount() + ") " + this._node + " " + ATermUtils.toString(this._allDisjonctions[this.getTryNext()]) + " " + ATermUtils.toString(this._disjunction);
    }

    @Override
    public DisjunctionBranch copyTo(ABox abox) {
        return new DisjunctionBranch(this, abox);
    }

    private int preferredDisjunct() {
        if (this._allDisjonctions.length != 2) {
            return -1;
        }
        if (ATermUtils.isPrimitive(this._allDisjonctions[0]) && ATermUtils.isAllValues(this._allDisjonctions[1]) && ATermUtils.isNot((ATermAppl)this._allDisjonctions[1].getArgument(1))) {
            return 1;
        }
        if (ATermUtils.isPrimitive(this._allDisjonctions[1]) && ATermUtils.isAllValues(this._allDisjonctions[0]) && ATermUtils.isNot((ATermAppl)this._allDisjonctions[0].getArgument(1))) {
            return 0;
        }
        return -1;
    }

    @Override
    public void setLastClash(DependencySet ds) {
        super.setLastClash(ds);
        if (this.getTryNext() >= 0) {
            this._prevDS[this.getTryNext()] = ds;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void tryBranch() {
        this._abox.incrementBranch();
        int[] stats = null;
        if (OpenlletOptions.USE_DISJUNCT_SORTING) {
            stats = this._abox.getDisjBranchStats().get(this._disjunction);
            if (stats == null) {
                int preference = this.preferredDisjunct();
                stats = new int[this._allDisjonctions.length];
                for (int i = 0; i < this._allDisjonctions.length; ++i) {
                    stats[i] = i != preference ? 0 : Integer.MIN_VALUE;
                }
                this._abox.getDisjBranchStats().put(this._disjunction, stats);
            }
            if (this.getTryNext() > 0) {
                int n = this._order[this.getTryNext() - 1];
                stats[n] = stats[n] + 1;
            }
            int minIndex = this.getTryNext();
            int minValue = stats[this.getTryNext()];
            for (int i = this.getTryNext() + 1; i < stats.length; ++i) {
                boolean tryEarlier;
                boolean bl = tryEarlier = stats[i] < minValue;
                if (!tryEarlier) continue;
                minIndex = i;
                minValue = stats[i];
            }
            if (minIndex != this.getTryNext()) {
                ATermAppl selDisj = this._allDisjonctions[minIndex];
                this._allDisjonctions[minIndex] = this._allDisjonctions[this.getTryNext()];
                this._allDisjonctions[this.getTryNext()] = selDisj;
                this._order[minIndex] = this.getTryNext();
                this._order[this.getTryNext()] = minIndex;
            }
        }
        Node node = this._node.getSame();
        while (this.getTryNext() < this.getTryCount()) {
            DependencySet clashDepends;
            ATermAppl d = this._allDisjonctions[this.getTryNext()];
            if (OpenlletOptions.USE_SEMANTIC_BRANCHING) {
                for (int m = 0; m < this.getTryNext(); ++m) {
                    this._strategy.addType(node, ATermUtils.negate(this._allDisjonctions[m]), this._prevDS[m]);
                }
            }
            DependencySet ds = null;
            if (this.getTryNext() == this.getTryCount() - 1 && !OpenlletOptions.SATURATE_TABLEAU) {
                ds = this.getTermDepends();
                for (int m = 0; m < this.getTryNext(); ++m) {
                    ds = ds.union(this._prevDS[m], this._abox.doExplanation());
                }
                if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
                    ds.setExplain(this.getTermDepends().getExplain());
                } else {
                    ds.remove(this.getBranchIndexInABox());
                }
            } else if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
                ds = this.getTermDepends().union(new DependencySet(this.getBranchIndexInABox()), this._abox.doExplanation());
            } else {
                ds = new DependencySet(this.getBranchIndexInABox());
                HashSet<ATermAppl> explain = new HashSet<ATermAppl>();
                explain.addAll(this.getTermDepends().getExplain());
                ds.setExplain(explain);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(this.getDebugMsg());
            }
            ATermAppl notD = ATermUtils.negate(d);
            DependencySet dependencySet = clashDepends = OpenlletOptions.SATURATE_TABLEAU ? null : node.getDepends(notD);
            if (clashDepends == null) {
                this._strategy.addType(node, d, ds);
                if (this._abox.isClosed()) {
                    clashDepends = this._abox.getClash().getDepends();
                }
            } else {
                clashDepends = clashDepends.union(ds, this._abox.doExplanation());
            }
            if (clashDepends == null) return;
            if (_logger.isLoggable(Level.FINE)) {
                Clash clash = this._abox.isClosed() ? this._abox.getClash() : Clash.atomic(node, clashDepends, d);
                _logger.fine("CLASH: Branch " + this.getBranchIndexInABox() + " " + clash + "! " + clashDepends.getExplain());
            }
            if (OpenlletOptions.USE_DISJUNCT_SORTING) {
                if (stats == null) {
                    stats = new int[this._allDisjonctions.length];
                    for (int i = 0; i < this._allDisjonctions.length; ++i) {
                        stats[i] = 0;
                    }
                    this._abox.getDisjBranchStats().put(this._disjunction, stats);
                }
                int n = this._order[this.getTryNext()];
                stats[n] = stats[n] + 1;
            }
            if (this.getTryNext() < this.getTryCount() - 1 && clashDepends.contains(this.getBranchIndexInABox())) {
                if (this._abox.isClosed()) {
                    if (node.isLiteral()) {
                        this._abox.setClash(null);
                        node.restore(this.getBranchIndexInABox());
                    } else {
                        this._strategy.restoreLocal((Individual)node, this);
                        this._abox.incrementBranch();
                    }
                }
            } else {
                if (this._abox.doExplanation()) {
                    ATermAppl positive = ATermUtils.isNot(notD) ? d : notD;
                    this._abox.setClash(Clash.atomic(node, clashDepends.union(ds, this._abox.doExplanation()), positive));
                } else {
                    this._abox.setClash(Clash.atomic(node, clashDepends.union(ds, this._abox.doExplanation())));
                }
                if (!OpenlletOptions.USE_INCREMENTAL_DELETION) return;
                this._abox.getKB().getDependencyIndex().addCloseBranchDependency(this, this._abox.getClash().getDepends());
                return;
            }
            this.setLastClash(clashDepends);
            ++this._tryNext;
        }
        throw new InternalReasonerException("This exception should not be thrown!");
    }

    @Override
    public void shiftTryNext(int openIndex) {
        ATermAppl dis = this._allDisjonctions[openIndex];
        if (OpenlletOptions.USE_SEMANTIC_BRANCHING) {
            // empty if block
        }
        for (int i = openIndex; i < this._allDisjonctions.length - 1; ++i) {
            this._allDisjonctions[i] = this._allDisjonctions[i + 1];
            this._prevDS[i] = this._prevDS[i + 1];
            this._order[i] = this._order[i];
        }
        this._allDisjonctions[this._allDisjonctions.length - 1] = dis;
        this._prevDS[this._allDisjonctions.length - 1] = null;
        this._order[this._allDisjonctions.length - 1] = this._allDisjonctions.length - 1;
        this.setTryNext(this.getTryNext() - 1);
    }

    public void printLong() {
        for (int i = 0; i < this._allDisjonctions.length; ++i) {
            System.out.println("Disj[" + i + "] " + this._allDisjonctions[i]);
            System.out.println("prevDS[" + i + "] " + this._prevDS[i]);
            System.out.println("order[" + i + "] " + this._order[i]);
        }
        System.out.println("trynext: " + this.getTryNext());
    }

    public void setDisj(ATermAppl[] disj) {
        this._allDisjonctions = disj;
    }

    public ATermAppl getDisjunct(int i) {
        return this._allDisjonctions[i];
    }
}

