/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.cache;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.KnowledgeBase;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.rbox.Role;
import openllet.core.expressivity.Expressivity;
import openllet.core.tableau.cache.CacheSafety;
import openllet.core.tableau.cache.CachedNode;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.fsm.Transition;
import openllet.core.utils.fsm.TransitionGraph;
import openllet.core.utils.iterator.IteratorUtils;

public class CacheSafetyDynamic
implements CacheSafety {
    private final Expressivity _expressivity;

    CacheSafetyDynamic(Expressivity e) {
        this._expressivity = new Expressivity(e);
    }

    @Override
    public boolean canSupport(Expressivity expressivity) {
        return !expressivity.hasNominal() && this._expressivity.getAnonInverses().equals(expressivity.getAnonInverses());
    }

    @Override
    public boolean isSafe(ATermAppl c, Individual ind) {
        Edge parentEdge = this.getParentEdge(ind);
        Role r = parentEdge.getRole();
        Individual parent = parentEdge.getFrom();
        ABox abox = parent.getABox();
        if (!CacheSafetyDynamic.isParentSafe(abox.getKB(), r, parent)) {
            return false;
        }
        Iterator<CachedNode> nodes = this.getCachedNodes(abox, c);
        if (!nodes.hasNext()) {
            return false;
        }
        if (this.interactsWithInverses(abox.getKB(), r)) {
            while (nodes.hasNext()) {
                CachedNode node = nodes.next();
                if (node.isBottom()) {
                    return true;
                }
                if (node.isTop() || !node.isComplete()) {
                    return false;
                }
                if (CacheSafetyDynamic.isSafe(abox.getKB(), parent, r.getInverse(), node)) continue;
                return false;
            }
        }
        return true;
    }

    protected Edge getParentEdge(Individual ind) {
        Edge result = null;
        Role role = null;
        Individual parent = ind.getParent();
        for (Edge e : ind.getInEdges()) {
            if (!e.getFrom().equals(parent)) continue;
            if (role == null) {
                role = e.getRole();
                result = e;
                continue;
            }
            if (!e.getRole().isSubRoleOf(role)) continue;
            role = e.getRole();
            result = e;
        }
        assert (result != null);
        return result;
    }

    protected Iterator<CachedNode> getCachedNodes(ABox abox, ATermAppl c) {
        CachedNode node = abox.getCached(c);
        if (node != null) {
            return IteratorUtils.singletonIterator(node);
        }
        if (ATermUtils.isAnd(c)) {
            ATermList list = (ATermList)c.getArgument(0);
            CachedNode[] nodes = new CachedNode[list.getLength()];
            int i = 0;
            while (!list.isEmpty()) {
                ATermAppl d = (ATermAppl)list.getFirst();
                node = abox.getCached(d);
                if (node == null) {
                    return IteratorUtils.emptyIterator();
                }
                if (node.isBottom()) {
                    return IteratorUtils.singletonIterator(node);
                }
                nodes[i++] = node;
                list = list.getNext();
            }
            return IteratorUtils.iterator(nodes);
        }
        return IteratorUtils.emptyIterator();
    }

    private static boolean isParentSafe(KnowledgeBase kb, Role role, Individual parent) {
        return CacheSafetyDynamic.isParentFunctionalSafe(role, parent) && CacheSafetyDynamic.isParentMaxSafe(kb, role, parent);
    }

    private static boolean isParentFunctionalSafe(Role role, Individual parent) {
        return !role.isFunctional() || parent.getRNeighbors(role).size() <= 1;
    }

    private static boolean isParentMaxSafe(KnowledgeBase kb, Role role, Individual parent) {
        for (ATermAppl negatedMax : parent.getTypes(5)) {
            ATermAppl max = (ATermAppl)negatedMax.getArgument(0);
            if (CacheSafetyDynamic.isParentMaxSafe(kb, role, max)) continue;
            return false;
        }
        return true;
    }

    private static boolean isParentMaxSafe(KnowledgeBase kb, Role role, ATermAppl max) {
        Role maxR = kb.getRole(max.getArgument(0));
        return !role.isSubRoleOf(maxR);
    }

    private static boolean isSafe(KnowledgeBase kb, Individual parent, Role role, CachedNode node) {
        if (!CacheSafetyDynamic.isFunctionalSafe(role, node)) {
            return false;
        }
        for (ATermAppl c : node.getDepends().keySet()) {
            ATermAppl arg;
            if (!(ATermUtils.isAllValues(c) ? !CacheSafetyDynamic.isAllValuesSafe(kb, parent, role, c) : ATermUtils.isNot(c) && ATermUtils.isMin(arg = (ATermAppl)c.getArgument(0)) && !CacheSafetyDynamic.isMaxSafe(kb, role, arg))) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllValuesSafe(KnowledgeBase kb, Individual parent, Role role, ATermAppl term) {
        Role s = kb.getRole(term.getArgument(0));
        if (!s.hasComplexSubRole()) {
            ATermAppl c = (ATermAppl)term.getArgument(1);
            if (role.isSubRoleOf(s) && !parent.hasType(c)) {
                return false;
            }
        } else {
            TransitionGraph<Role> tg = s.getFSM();
            for (Transition<Role> t : tg.getInitialState().getTransitions()) {
                if (!role.isSubRoleOf(t.getName())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isFunctionalSafe(Role role, CachedNode node) {
        return !role.isFunctional() || CacheSafetyDynamic.getRNeighbors(node, role).isEmpty();
    }

    private static boolean isMaxSafe(KnowledgeBase kb, Role role, ATermAppl term) {
        Role maxR = kb.getRole(term.getArgument(0));
        return !role.isSubRoleOf(maxR);
    }

    private static Set<ATermAppl> getRNeighbors(CachedNode node, Role role) {
        HashSet<ATermAppl> neighbors = new HashSet<ATermAppl>();
        for (Edge edge : node.getOutEdges()) {
            Role r = edge.getRole();
            if (!r.isSubRoleOf(role)) continue;
            neighbors.add(edge.getToName());
        }
        if (role.isObjectRole()) {
            Role invRole = role.getInverse();
            for (Edge edge : node.getInEdges()) {
                Role r = edge.getRole();
                if (!r.isSubRoleOf(invRole)) continue;
                neighbors.add(edge.getFromName());
            }
        }
        return neighbors;
    }

    protected boolean interactsWithInverses(KnowledgeBase kb, Role role) {
        if (this.interactsWithInversesSimple(role)) {
            return true;
        }
        return this._expressivity.hasComplexSubRoles() && this.interactsWithInversesComplex(kb, role);
    }

    protected boolean interactsWithInversesSimple(Role role) {
        for (Role superRole : role.getSuperRoles()) {
            if (!this.hasAnonInverse(superRole)) continue;
            return true;
        }
        return false;
    }

    protected boolean interactsWithInversesComplex(KnowledgeBase kb, Role role) {
        for (ATermAppl p : this._expressivity.getAnonInverses()) {
            Role anonRole = kb.getRole(p);
            if (!anonRole.hasComplexSubRole() || !anonRole.getFSM().getAlpahabet().contains(role)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAnonInverse(Role role) {
        return !role.isBuiltin() && (role.isAnon() || this._expressivity.getAnonInverses().contains(role.getName()));
    }
}

