/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.atom.OpenError;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.IndividualIterator;
import openllet.core.boxes.abox.Node;
import openllet.core.expressivity.Expressivity;
import openllet.core.tableau.blocking.BlockingFactory;
import openllet.core.tableau.branch.Branch;
import openllet.core.tableau.cache.CacheSafety;
import openllet.core.tableau.cache.CacheSafetyFactory;
import openllet.core.tableau.cache.CachedNode;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.Bool;
import openllet.core.utils.Timer;

public class EmptySRIQStrategy
extends CompletionStrategy {
    private LinkedList<Individual> _mayNeedExpanding = new LinkedList();
    private final List<List<Individual>> _mnx = new ArrayList<List<Individual>>();
    private final Map<Individual, ATermAppl> _cachedNodes = new HashMap<Individual, ATermAppl>();
    private volatile Optional<CacheSafety> _cacheSafety = Optional.empty();

    public EmptySRIQStrategy(ABox abox) {
        super(abox);
    }

    @Override
    public void initialize(Expressivity expressivity) {
        this._mergeList.clear();
        this._mnx.add(null);
        assert (this._abox.size() == 1) : "This strategy can only be used with originally empty ABoxes";
        this._blocking = BlockingFactory.createBlocking(expressivity);
        Individual root = this._abox.getIndIterator().next();
        this.applyUniversalRestrictions(root);
        this._selfRule.apply(root);
        this._mayNeedExpanding.add(root);
        this._abox.setBranchIndex(1);
        this._abox.getStats()._treeDepth = 1;
        this._abox.setChanged(true);
        this._abox.setComplete(false);
        this._abox.setInitialized(true);
    }

    @Override
    public void complete(Expressivity expr) {
        _logger.fine(() -> "************  " + EmptySRIQStrategy.class.getName() + "  ************ " + expr);
        if (this._abox.getNodes().isEmpty()) {
            this._abox.setComplete(true);
            return;
        }
        if (this._abox.getNodes().size() > 1) {
            throw new OpenError("This _strategy can only be used with an ABox that has a single _individual.");
        }
        this._cacheSafety = Optional.of(this._abox.getCache().getSafety().canSupport(expr) ? this._abox.getCache().getSafety() : CacheSafetyFactory.createCacheSafety(expr));
        this.initialize(expr);
        while (!this._abox.isComplete() && !this._abox.isClosed()) {
            Individual x = this.getNextIndividual();
            if (x == null) {
                this._abox.setComplete(true);
                break;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Starting with _node " + x);
                this._abox.printTree();
                this._abox.validate();
            }
            this.expand(x);
            if (this._abox.isClosed()) {
                _logger.fine(() -> "Clash at Branch (" + this._abox.getBranchIndex() + ") " + this._abox.getClash());
                if (this.backtrack()) {
                    this._abox.setClash(null);
                    continue;
                }
                this._abox.setComplete(true);
                continue;
            }
            if (!expr.hasInverse() || !EmptySRIQStrategy.parentNeedsExpanding(x)) continue;
            this._mayNeedExpanding.removeAll(this.getDescendants(x.getParent()));
            this._mayNeedExpanding.addFirst(x.getParent());
        }
        if (_logger.isLoggable(Level.FINE)) {
            this._abox.printTree();
        }
        if (OpenlletOptions.USE_ADVANCED_CACHING && !this._abox.isClosed()) {
            IndividualIterator i = new IndividualIterator(this._abox);
            while (i.hasNext()) {
                Individual ind = (Individual)i.next();
                ATermAppl c = this._cachedNodes.get(ind);
                if (c == null) continue;
                this.addCacheSat(c);
            }
        }
    }

    private List<Individual> getDescendants(Individual ind) {
        ArrayList<Individual> descendants = new ArrayList<Individual>();
        this.getDescendants(ind, descendants);
        return descendants;
    }

    private void getDescendants(Individual ind, List<Individual> descendants) {
        descendants.add(ind);
        for (Edge edge : ind.getOutEdges()) {
            if (!edge.getTo().isIndividual() || edge.getTo().equals(ind)) continue;
            this.getDescendants((Individual)edge.getTo(), descendants);
        }
    }

    private void addCacheSat(ATermAppl c) {
        if (!this._abox.getCache().putSat(c, true)) {
            return;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("+++ Cache sat concept " + c);
        }
        if (ATermUtils.isAnd(c)) {
            ATermList list = (ATermList)c.getArgument(0);
            while (!list.isEmpty()) {
                this.addCacheSat((ATermAppl)list.getFirst());
                list = list.getNext();
            }
        }
    }

    private Individual getNextIndividual() {
        if (this._mayNeedExpanding.isEmpty()) {
            return null;
        }
        return this._mayNeedExpanding.get(0);
    }

    private static boolean parentNeedsExpanding(Individual x) {
        if (x.isRoot()) {
            return false;
        }
        Individual parent = x.getParent();
        return parent.canApply(0) || parent.canApply(1) || parent.canApply(2) || parent.canApply(4) || parent.canApply(5);
    }

    private void expand(Individual x) {
        this.checkTimer();
        if (!this._abox.doExplanation() && OpenlletOptions.USE_ADVANCED_CACHING) {
            Optional<Timer> timer = this._abox.getKB().getTimers().startTimer("cache");
            Bool cachedSat = this.isCachedSat(x);
            timer.ifPresent(t -> t.stop());
            if (cachedSat.isKnown()) {
                if (cachedSat.isTrue()) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("Stop cached " + x);
                    }
                    this._mayNeedExpanding.remove(0);
                } else {
                    DependencySet ds = DependencySet.EMPTY;
                    for (ATermAppl c : x.getTypes()) {
                        ds = ds.union(x.getDepends(c), this._abox.doExplanation());
                    }
                    this._abox.setClash(Clash.atomic(x, ds));
                }
                return;
            }
        }
        do {
            if (this._blocking.isDirectlyBlocked(x)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Stop _blocked " + x);
                }
                this._mayNeedExpanding.remove(0);
                return;
            }
            this._unfoldingRule.apply(x);
            if (this._abox.isClosed()) {
                return;
            }
            this._disjunctionRule.apply(x);
            if (this._abox.isClosed()) {
                return;
            }
            if (x.canApply(0) || x.canApply(1)) continue;
            if (this._blocking.isDynamic() && this._blocking.isDirectlyBlocked(x)) {
                _logger.fine(() -> "Stop blocked " + x);
                this._mayNeedExpanding.remove(0);
                return;
            }
            this._someValuesRule.apply(x);
            if (this._abox.isClosed()) {
                return;
            }
            this._minRule.apply(x);
            if (this._abox.isClosed()) {
                return;
            }
            if (x.canApply(0) || x.canApply(1)) continue;
            this._chooseRule.apply(x);
            if (this._abox.isClosed()) {
                return;
            }
            this._maxRule.apply(x);
            if (!this._abox.isClosed()) continue;
            return;
        } while (x.canApply(0) || x.canApply(1) || x.canApply(2) || x.canApply(4));
        this._mayNeedExpanding.remove(0);
        EdgeList sortedSuccessors = x.getOutEdges().sort();
        if (OpenlletOptions.SEARCH_TYPE) {
            for (Edge edge : sortedSuccessors) {
                Node succ = edge.getTo();
                if (succ.isLiteral() || succ.equals(x)) continue;
                this._mayNeedExpanding.add((Individual)succ);
            }
        } else {
            for (int i = sortedSuccessors.size() - 1; i >= 0; --i) {
                Edge edge = (Edge)sortedSuccessors.get(i);
                Node succ = edge.getTo();
                if (succ.isLiteral() || succ.equals(x)) continue;
                this._mayNeedExpanding.add((Individual)succ);
            }
        }
    }

    private static ATermAppl createConcept(Individual x) {
        int count = 0;
        ATerm[] terms = new ATermAppl[x.getTypes().size()];
        for (int t = 0; t < 7; ++t) {
            if (t == 6) continue;
            for (ATermAppl c : x.getTypes(t)) {
                if (c.equals(ATermUtils.TOP)) continue;
                terms[count++] = c;
            }
        }
        switch (count) {
            case 0: {
                return ATermUtils.TOP;
            }
            case 1: {
                return terms[0];
            }
        }
        return ATermUtils.makeAnd(ATermUtils.toSet(terms, count));
    }

    private Bool isCachedSat(Individual x) {
        if (x.isRoot()) {
            return Bool.UNKNOWN;
        }
        ATermAppl c = EmptySRIQStrategy.createConcept(x);
        Bool sat = this.isCachedSat(c);
        if (sat.isUnknown()) {
            _logger.finest(() -> "??? Cache miss for " + c);
            this._cachedNodes.put(x, c);
        } else {
            if (!this._cacheSafety.isPresent() || !this._cacheSafety.get().isSafe(c, x)) {
                _logger.finer(() -> "*** Cache unsafe for " + c);
                return Bool.UNKNOWN;
            }
            _logger.finer(() -> "*** Cache hit for " + c + " sat = " + sat);
        }
        return sat;
    }

    private Bool isCachedSat(ATermAppl c) {
        Bool sat = this._abox.getCachedSat(c);
        if (sat.isKnown() || !ATermUtils.isAnd(c)) {
            return sat;
        }
        sat = null;
        ATermList list = (ATermList)c.getArgument(0);
        CachedNode cached1 = null;
        CachedNode cached2 = null;
        while (!list.isEmpty()) {
            ATermAppl d = (ATermAppl)list.getFirst();
            CachedNode node = this._abox.getCached(d);
            if (node == null || !node.isComplete()) {
                sat = Bool.UNKNOWN;
                break;
            }
            if (node.isBottom()) {
                sat = Bool.FALSE;
                break;
            }
            if (!node.isTop()) {
                if (cached1 == null) {
                    cached1 = node;
                } else if (cached2 == null) {
                    cached2 = node;
                } else {
                    sat = Bool.UNKNOWN;
                    break;
                }
            }
            list = list.getNext();
        }
        if (sat == null) {
            sat = cached2 == null ? Bool.TRUE : this._abox.getCache().isMergable(this._abox.getKB(), cached1, cached2);
        }
        if (sat.isKnown()) {
            this._abox.getCache().putSat(c, sat.isTrue());
        }
        return sat;
    }

    @Override
    public void restoreLocal(Individual ind, Branch br) {
        this.restore(br);
    }

    @Override
    public void restore(Branch br) {
        Optional<Timer> timer = this._timers.startTimer("restore");
        ++this._abox.getStats()._globalRestores;
        Node clashNode = this._abox.getClash().getNode();
        List<ATermAppl> clashPath = clashNode.getPath();
        clashPath.add(clashNode.getName());
        this._abox.setBranchIndex(br.getBranchIndexInABox());
        this._abox.setClash(null);
        this._mergeList.clear();
        List<ATermAppl> nodeList = this._abox.getNodeNames();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("RESTORE: Branch " + br.getBranchIndexInABox());
            if (br.getNodeCount() < nodeList.size()) {
                _logger.fine("Remove _nodes " + nodeList.subList(br.getNodeCount(), nodeList.size()));
            }
        }
        for (int i = 0; i < nodeList.size(); ++i) {
            ATermAppl x = nodeList.get(i);
            Node node = this._abox.getNode(x);
            if (i >= br.getNodeCount()) {
                this._abox.removeNode(x);
                ATermAppl c = this._cachedNodes.remove(node);
                if (c == null || !OpenlletOptions.USE_ADVANCED_CACHING) continue;
                if (clashPath.contains(x)) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("+++ Cache unsat concept " + c);
                    }
                    this._abox.getCache().putSat(c, false);
                    continue;
                }
                if (!_logger.isLoggable(Level.FINEST)) continue;
                _logger.finest("--- Do not _cache concept " + c + " " + x + " " + clashNode + " " + clashPath);
                continue;
            }
            node.restore(br.getBranchIndexInABox());
            if (!node.equals(clashNode)) continue;
            this._cachedNodes.remove(node);
        }
        nodeList.subList(br.getNodeCount(), nodeList.size()).clear();
        IndividualIterator i = this._abox.getIndIterator();
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            this._allValuesRule.apply(ind);
        }
        if (_logger.isLoggable(Level.FINE)) {
            this._abox.printTree();
        }
        timer.ifPresent(t -> t.stop());
    }

    protected boolean backtrack() {
        boolean branchFound = false;
        ++this._abox.getStats()._backtracks;
        while (!branchFound) {
            this._completionTimer.ifPresent(t -> t.check());
            int lastBranch = this._abox.getClash().getDepends().max();
            if (lastBranch <= 0) {
                return false;
            }
            List<Branch> branches = this._abox.getBranches();
            this._abox.getStats()._backjumps += branches.size() - lastBranch;
            Branch newBranch = null;
            if (lastBranch <= branches.size()) {
                branches.subList(lastBranch, branches.size()).clear();
                newBranch = branches.get(lastBranch - 1);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("JUMP: " + lastBranch);
                }
                if (newBranch == null || lastBranch != newBranch.getBranchIndexInABox()) {
                    throw new OpenError("Internal error in reasoner: Trying to backtrack _branch " + lastBranch + " but got " + newBranch);
                }
                if (newBranch.getTryNext() < newBranch.getTryCount()) {
                    newBranch.setLastClash(this._abox.getClash().getDepends());
                }
                newBranch.setTryNext(newBranch.getTryNext() + 1);
                if (newBranch.getTryNext() < newBranch.getTryCount()) {
                    this.restore(newBranch);
                    branchFound = newBranch.tryNext();
                }
            }
            if (!branchFound || newBranch == null) {
                this._abox.getClash().getDepends().remove(lastBranch);
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.fine("FAIL: " + lastBranch);
                continue;
            }
            this._mayNeedExpanding = new LinkedList(this._mnx.get(newBranch.getBranchIndexInABox()));
            this._mnx.subList(newBranch.getBranchIndexInABox() + 1, this._mnx.size()).clear();
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.fine("MNX : " + this._mayNeedExpanding);
        }
        this._abox.validate();
        return branchFound;
    }

    @Override
    public void addBranch(Branch newBranch) {
        super.addBranch(newBranch);
        assert (this._mnx.size() == newBranch.getBranchIndexInABox()) : this._mnx.size() + " != " + newBranch.getBranchIndexInABox();
        this._mnx.add(new ArrayList<Individual>(this._mayNeedExpanding));
    }
}

