/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.IndividualIterator;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.expressivity.Expressivity;
import openllet.core.tableau.branch.Branch;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.tableau.completion.rule.TableauRule;

public class SROIQStrategy
extends CompletionStrategy {
    public SROIQStrategy(ABox abox) {
        super(abox);
    }

    protected boolean backtrack() {
        boolean branchFound = false;
        ++this._abox.getStats()._backtracks;
        while (!branchFound) {
            Branch br;
            this._completionTimer.ifPresent(t -> t.check());
            int branchCount = this._abox.getBranches().size();
            int candidatLastBranch = this._abox.getClash().getDepends().max();
            while (candidatLastBranch <= 0 || candidatLastBranch > branchCount) {
                if (candidatLastBranch <= 0) {
                    return false;
                }
                this._abox.getClash().getDepends().remove(candidatLastBranch);
                candidatLastBranch = this._abox.getClash().getDepends().max();
                _logger.severe("Used the improved backupjump.");
            }
            int lastBranch = candidatLastBranch;
            if (lastBranch > branchCount) {
                throw new InternalReasonerException("Backtrack: Trying to backtrack to _branch " + lastBranch + " but has only " + branchCount + "branches. Clash found: " + this._abox.getClash());
            }
            if (OpenlletOptions.USE_INCREMENTAL_DELETION && (br = this._abox.getBranches().get(lastBranch - 1)).getTryNext() == br.getTryCount() - 1 && this._abox.getClash().getDepends().size() == 2) {
                this._abox.getKB().getDependencyIndex().addCloseBranchDependency(br, this._abox.getClash().getDepends());
                return false;
            }
            List<Branch> branches = this._abox.getBranches();
            this._abox.getStats()._backjumps += branches.size() - lastBranch;
            if (OpenlletOptions.USE_TRACING && OpenlletOptions.USE_INCREMENTAL_CONSISTENCY) {
                List<Branch> brList = branches.subList(lastBranch, branches.size());
                for (Branch branch : brList) {
                    this._abox.getKB().getDependencyIndex().removeBranchDependencies(branch);
                }
                brList.clear();
            } else {
                branches.subList(lastBranch, branches.size()).clear();
            }
            Branch newBranch = branches.get(lastBranch - 1);
            _logger.fine(() -> "JUMP: Branch " + lastBranch + "\tbranchCount=" + this._abox.getBranches().size());
            if (lastBranch != newBranch.getBranchIndexInABox()) {
                throw new InternalReasonerException("Backtrack: Trying to backtrack to _branch " + lastBranch + " but got " + newBranch.getBranchIndexInABox());
            }
            if (newBranch.getTryNext() < newBranch.getTryCount()) {
                newBranch.setLastClash(this._abox.getClash().getDepends());
            }
            newBranch.setTryNext(newBranch.getTryNext() + 1);
            if (newBranch.getTryNext() < newBranch.getTryCount()) {
                this.restore(newBranch);
            }
            if (branchFound = newBranch.tryNext()) continue;
            _logger.fine(() -> "FAIL: Branch " + lastBranch);
        }
        return branchFound;
    }

    @Override
    public void complete(Expressivity expr) {
        this.initialize(expr);
        while (!this._abox.isComplete()) {
            while (this._abox.isChanged() && !this._abox.isClosed()) {
                TableauRule tableauRule;
                boolean closed;
                IndividualIterator i;
                this._completionTimer.ifPresent(t -> t.check());
                this._abox.setChanged(false);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Branch: " + this._abox.getBranchIndex() + ", Depth: " + this._abox.getStats()._treeDepth + ", Size: " + this._abox.getNodes().size() + ", Mem: " + Runtime.getRuntime().freeMemory() / 1000L + "kb");
                    this._abox.validate();
                    this.printBlocked();
                    this._abox.printTree();
                }
                IndividualIterator individualIterator = i = OpenlletOptions.USE_COMPLETION_QUEUE ? this._abox.getCompletionQueue() : this._abox.getIndIterator();
                if (OpenlletOptions.USE_COMPLETION_QUEUE) {
                    this._abox.getCompletionQueue().flushQueue();
                }
                Iterator iterator = this._tableauRules.iterator();
                while (iterator.hasNext() && !(closed = (tableauRule = (TableauRule)iterator.next()).apply(i))) {
                }
                if (!OpenlletOptions.USE_COMPLETION_QUEUE) continue;
                this._abox.getCompletionQueue().setClosed(this._abox.isClosed());
            }
            if (this._abox.isClosed()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Clash at Branch (" + this._abox.getBranchIndex() + ") " + this._abox.getClash());
                }
                if (this.backtrack()) {
                    this._abox.setClash(null);
                    if (!OpenlletOptions.USE_COMPLETION_QUEUE) continue;
                    this._abox.getCompletionQueue().setClosed(false);
                    continue;
                }
                this._abox.setComplete(true);
                if (!OpenlletOptions.USE_COMPLETION_QUEUE) continue;
                this._abox.getCompletionQueue().flushQueue();
                continue;
            }
            if (OpenlletOptions.SATURATE_TABLEAU) {
                Branch unexploredBranch = null;
                for (int i = this._abox.getBranches().size() - 1; i >= 0; --i) {
                    unexploredBranch = this._abox.getBranches().get(i);
                    unexploredBranch.setTryNext(unexploredBranch.getTryNext() + 1);
                    if (unexploredBranch.getTryNext() < unexploredBranch.getTryCount()) {
                        this.restore(unexploredBranch);
                        System.out.println("restoring _branch " + unexploredBranch.getBranchIndexInABox() + " _tryNext = " + unexploredBranch.getTryNext() + " _tryCount = " + unexploredBranch.getTryCount());
                        unexploredBranch.tryNext();
                        break;
                    }
                    System.out.println("removing _branch " + unexploredBranch.getBranchIndexInABox());
                    this._abox.getBranches().remove(i);
                    unexploredBranch = null;
                }
                if (unexploredBranch != null) continue;
                this._abox.setComplete(true);
                continue;
            }
            this._abox.setComplete(true);
        }
    }
}

