/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.queue;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.atom.OpenError;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.tableau.completion.queue.CompletionQueue;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.queue.QueueElement;

public final class BasicCompletionQueue
extends CompletionQueue {
    private final List<ATermAppl> _queue = new ArrayList<ATermAppl>();
    private final Set<ATermAppl> _newQueue = new HashSet<ATermAppl>();
    private final List<ATermAppl> _newQueueList = new ArrayList<ATermAppl>();
    private int _current = 0;
    private int _end = 0;
    private int _cutOff = 0;
    private boolean _backtracked = false;

    public BasicCompletionQueue(ABox abox) {
        super(abox);
    }

    public BasicCompletionQueue(BasicCompletionQueue that) {
        super(that._abox);
        this._queue.addAll(that._queue);
        this._newQueue.addAll(that._newQueue);
        this._newQueueList.addAll(that._newQueueList);
        this._current = that._current;
        this._cutOff = that._cutOff;
        this._backtracked = that._backtracked;
        this._end = that._end;
        this.setAllowLiterals(that.isAllowLiterals());
    }

    @Override
    protected void findNext(int type) {
        Node node;
        while (!(this._current >= this._cutOff || (node = this._abox.getNode(this._queue.get(this._current))) != null && ((node = node.getSame()).isLiteral() && this.isAllowLiterals() || node.isIndividual() && !this.isAllowLiterals()) && !node.isPruned())) {
            ++this._current;
        }
    }

    @Override
    public boolean hasNext() {
        this.findNext(-1);
        return this._current < this._cutOff;
    }

    @Override
    public void restore(int branch) {
        this._queue.addAll(this._newQueueList);
        this._newQueue.clear();
        this._newQueueList.clear();
        this._end = this._queue.size();
        this._current = 0;
        this._cutOff = this._end;
        this._backtracked = true;
    }

    @Override
    public Individual next() {
        this.findNext(-1);
        Individual ind = this._abox.getIndividual(this._queue.get(this._current));
        ind = ind.getSame();
        ++this._current;
        return ind;
    }

    @Override
    public Node nextLiteral() {
        this.findNext(-1);
        Node node = this._abox.getNode(this._queue.get(this._current));
        node = node.getSame();
        ++this._current;
        return node;
    }

    @Override
    public void add(QueueElement x, NodeSelector s) {
        this.add(x);
    }

    @Override
    public void add(QueueElement x) {
        if (!this._newQueue.contains(x.getNode())) {
            this._newQueue.add(x.getNode());
            this._newQueueList.add(x.getNode());
        }
    }

    @Override
    public void reset(NodeSelector s) {
        this._cutOff = this._end;
        this._current = 0;
    }

    @Override
    public void incrementBranch(int branch) {
    }

    @Override
    public BasicCompletionQueue copy() {
        return new BasicCompletionQueue(this);
    }

    @Override
    public void setABox(ABox ab) {
        this._abox = ab;
    }

    @Override
    public void print(int type) {
        System.out.println("Queue: " + this._queue);
    }

    @Override
    public void print() {
        System.out.println("Queue: " + this._queue);
    }

    @Override
    public void remove() {
        throw new OpenError("Remove is not supported");
    }

    @Override
    public void flushQueue() {
        if (!this._backtracked && !this._closed) {
            this._queue.clear();
        } else if (this._closed && !this._abox.isClosed()) {
            this._closed = false;
        }
        this._queue.addAll(this._newQueueList);
        this._newQueue.clear();
        this._newQueueList.clear();
        this._end = this._queue.size();
        this._backtracked = false;
    }

    @Override
    protected void flushQueue(NodeSelector s) {
    }

    @Override
    public void clearQueue(NodeSelector s) {
    }
}

