/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.rule;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.Individual;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.tableau.branch.DisjunctionBranch;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.rule.AbstractTableauRule;
import openllet.core.utils.ATermUtils;

public class DisjunctionRule
extends AbstractTableauRule {
    public DisjunctionRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.DISJUNCTION, AbstractTableauRule.BlockingType.COMPLETE);
    }

    @Override
    public void apply(Individual node) {
        if (!node.canApply(1)) {
            return;
        }
        List<ATermAppl> types = node.getTypes(1);
        int size = types.size();
        ATermAppl[] disjunctions = new ATermAppl[size - node._applyNext[1]];
        types.subList(node._applyNext[1], size).toArray(disjunctions);
        if (OpenlletOptions.USE_DISJUNCTION_SORTING != "NO") {
            DisjunctionRule.sortDisjunctions(node, disjunctions);
        }
        for (ATermAppl disjunction : disjunctions) {
            this.applyDisjunctionRule(node, disjunction);
            if (!this._strategy.getABox().isClosed() && !node.isMerged()) continue;
            return;
        }
        node._applyNext[1] = size;
    }

    private static void sortDisjunctions(Individual node, ATermAppl[] disjunctions) {
        if (OpenlletOptions.USE_DISJUNCTION_SORTING != "OLDEST_FIRST") {
            throw new InternalReasonerException("Unknown _disjunction sorting option " + OpenlletOptions.USE_DISJUNCTION_SORTING);
        }
        Comparator comparator = (d1, d2) -> node.getDepends((ATerm)d1).max() - node.getDepends((ATerm)d2).max();
        Arrays.sort(disjunctions, comparator);
    }

    protected void applyDisjunctionRule(Individual node, ATermAppl disjunction) {
        ATermAppl a = (ATermAppl)disjunction.getArgument(0);
        ATermList disjuncts = (ATermList)a.getArgument(0);
        ATermAppl[] disj = new ATermAppl[disjuncts.getLength()];
        int index = 0;
        while (!disjuncts.isEmpty()) {
            disj[index] = ATermUtils.negate((ATermAppl)disjuncts.getFirst());
            if (node.hasType(disj[index])) {
                return;
            }
            disjuncts = disjuncts.getNext();
            ++index;
        }
        DisjunctionBranch newBranch = new DisjunctionBranch(this._strategy.getABox(), this._strategy, node, disjunction, node.getDepends(disjunction), disj);
        this._strategy.addBranch(newBranch);
        newBranch.tryNext();
    }
}

