/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.rule;

import java.util.List;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermInt;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.rule.AbstractTableauRule;
import openllet.core.utils.ATermUtils;

public class MinCardinalityRule
extends AbstractTableauRule {
    public MinCardinalityRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.MIN_NUMBER, AbstractTableauRule.BlockingType.COMPLETE);
    }

    @Override
    public void apply(Individual ind) {
        if (!ind.canApply(4)) {
            return;
        }
        List<ATermAppl> types = ind.getTypes(4);
        int size = types.size();
        for (int j = ind._applyNext[4]; j < size; ++j) {
            ATermAppl mc = types.get(j);
            this.apply(ind, mc);
            if (!this._strategy.getABox().isClosed()) continue;
            return;
        }
        ind._applyNext[4] = size;
    }

    protected void apply(Individual x, ATermAppl mc) {
        ATermAppl c;
        int n;
        Role r = this._strategy.getABox().getRole(mc.getArgument(0));
        if (x.hasDistinctRNeighborsForMin(r, n = ((ATermInt)mc.getArgument(1)).getInt(), c = (ATermAppl)mc.getArgument(2))) {
            return;
        }
        DependencySet ds = x.getDepends(mc);
        if (!OpenlletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) {
            return;
        }
        _logger.fine(() -> "MIN : " + x + " -> " + r + " -> anon" + (n == 1 ? "" : this._strategy.getABox().getAnonCount() + 1 + " - anon") + (this._strategy.getABox().getAnonCount() + n) + " " + ATermUtils.toString(c) + " " + ds);
        Node[] y = new Node[n];
        for (int c1 = 0; c1 < n; ++c1) {
            this._strategy.checkTimer();
            y[c1] = r.isDatatypeRole() ? this._strategy.getABox().addLiteral(ds) : this._strategy.createFreshIndividual(x, ds);
            Node succ = y[c1];
            DependencySet finalDS = ds;
            this._strategy.addEdge(x, r, succ, ds);
            if (succ.isPruned()) {
                finalDS = finalDS.union(succ.getMergeDependency(true), this._strategy.getABox().doExplanation());
                succ = succ.getMergedTo();
            }
            this._strategy.addType(succ, c, finalDS);
            for (int c2 = 0; c2 < c1; ++c2) {
                succ.setDifferent(y[c2], finalDS);
            }
        }
    }
}

