/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.taxonomy;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.atom.OpenError;
import openllet.core.taxonomy.Taxonomy;

public class TaxonomyUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean addSuperExplanation(Taxonomy<ATermAppl> t, ATermAppl sub, ATermAppl sup, Set<ATermAppl> explanation) {
        HashSet<Set<ATermAppl>> explanations;
        HashMap<ATermAppl, HashSet<Set<ATermAppl>>> map = (HashMap<ATermAppl, HashSet<Set<ATermAppl>>>)t.getDatum(sub, TaxonomyKey.SUPER_EXPLANATION_KEY);
        if (map == null) {
            if (!t.contains(sub)) throw new OpenError(sub + " is an unknown class!");
            map = new HashMap<ATermAppl, HashSet<Set<ATermAppl>>>();
            t.putDatum(sub, TaxonomyKey.SUPER_EXPLANATION_KEY, map);
            explanations = null;
        } else {
            explanations = (HashSet<Set<ATermAppl>>)map.get(sup);
        }
        if (explanations != null) return explanations.add(explanation);
        explanations = new HashSet<Set<ATermAppl>>();
        map.put(sup, explanations);
        return explanations.add(explanation);
    }

    protected static void clearSuperExplanation(Taxonomy<ATermAppl> t, ATermAppl c) {
        t.removeDatum(c, TaxonomyKey.SUPER_EXPLANATION_KEY);
    }

    public static Set<Set<ATermAppl>> getSuperExplanations(Taxonomy<ATermAppl> t, ATermAppl sub, ATermAppl sup) {
        Map map = (Map)t.getDatum(sub, TaxonomyKey.SUPER_EXPLANATION_KEY);
        if (map == null) {
            return null;
        }
        Set explanations = (Set)map.get(sup);
        if (explanations == null) {
            return null;
        }
        return Collections.unmodifiableSet(explanations);
    }

    public static <T, I> Set<I> getAllInstances(Taxonomy<T> t, T c) {
        Iterator<Object> i = t.depthFirstDatumOnly(c, TaxonomyKey.INSTANCES_KEY);
        if (!i.hasNext()) {
            throw new OpenError(c + " is an unknown class!");
        }
        HashSet instances = new HashSet();
        do {
            Set current;
            if ((current = (Set)i.next()) == null) continue;
            instances.addAll(current);
        } while (i.hasNext());
        return Collections.unmodifiableSet(instances);
    }

    public static <T, I> Set<I> getDirectInstances(Taxonomy<T> t, T c) {
        Set instances = (Set)t.getDatum(c, TaxonomyKey.INSTANCES_KEY);
        if (instances == null) {
            if (t.contains(c)) {
                return Collections.emptySet();
            }
            throw new OpenError(c + " is an unknown class!");
        }
        return Collections.unmodifiableSet(instances);
    }

    public static <TClass, TInd> Set<Set<TClass>> getTypes(Taxonomy<TClass> t, TInd ind, boolean directOnly) {
        HashSet<Set<TClass>> types = new HashSet<Set<TClass>>();
        Iterator<Map.Entry<Set<TClass>, Object>> i = t.datumEquivalentsPair(TaxonomyKey.INSTANCES_KEY);
        while (i.hasNext()) {
            Map.Entry<Set<TClass>, Object> pair = i.next();
            Set instances = (Set)pair.getValue();
            if (instances == null || !instances.contains(ind)) continue;
            types.add(pair.getKey());
            if (directOnly) continue;
            TClass a = pair.getKey().iterator().next();
            types.addAll(t.getSupers(a));
        }
        return Collections.unmodifiableSet(types);
    }

    public static boolean isType(Taxonomy<ATermAppl> t, ATermAppl ind, ATermAppl c) {
        Iterator<Object> i = t.depthFirstDatumOnly(c, TaxonomyKey.INSTANCES_KEY);
        if (!i.hasNext()) {
            throw new OpenError(c + " is an unknown class!");
        }
        do {
            Set instances;
            if ((instances = (Set)i.next()) == null || !instances.contains(ind)) continue;
            return true;
        } while (i.hasNext());
        return false;
    }

    public static enum TaxonomyKey {
        INSTANCES_KEY,
        SUPER_EXPLANATION_KEY;

    }
}

