/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tracker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.core.tracker.BranchEffectTracker;

public class SimpleBranchEffectTracker
implements BranchEffectTracker {
    private final ArrayList<Set<ATermAppl>> _effects;

    public SimpleBranchEffectTracker() {
        this._effects = new ArrayList();
    }

    private SimpleBranchEffectTracker(SimpleBranchEffectTracker other) {
        int n = other._effects.size();
        this._effects = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Set<ATermAppl> s = other._effects.get(i);
            this._effects.add((Set<ATermAppl>)(s == null ? null : new HashSet<ATermAppl>(s)));
        }
    }

    @Override
    public boolean add(int branch, ATermAppl a) {
        Set<ATermAppl> existing;
        if (branch <= 0) {
            return false;
        }
        int diff = branch - this._effects.size();
        if (diff > 0) {
            Set[] nulls = new Set[diff];
            this._effects.addAll(Arrays.asList(nulls));
        }
        if ((existing = this._effects.get(branch - 1)) == null) {
            existing = new HashSet<ATermAppl>();
            this._effects.set(branch - 1, existing);
        }
        return existing.add(a);
    }

    @Override
    public SimpleBranchEffectTracker copy() {
        return new SimpleBranchEffectTracker(this);
    }

    @Override
    public Set<ATermAppl> getAll(int branch) {
        if (branch < 1) {
            throw new IllegalArgumentException();
        }
        if (branch > this._effects.size()) {
            return Collections.emptySet();
        }
        HashSet<ATermAppl> ret = new HashSet<ATermAppl>();
        for (int i = branch - 1; i < this._effects.size(); ++i) {
            Set<ATermAppl> s = this._effects.get(i);
            if (s == null) continue;
            ret.addAll(s);
        }
        return ret;
    }

    @Override
    public Set<ATermAppl> remove(int branch) {
        if (branch < 1) {
            throw new IllegalArgumentException();
        }
        if (branch > this._effects.size()) {
            return Collections.emptySet();
        }
        Set<ATermAppl> ret = this._effects.remove(branch - 1);
        if (ret == null) {
            return Collections.emptySet();
        }
        return ret;
    }

    @Override
    public Set<ATermAppl> removeAll(int branch) {
        if (branch < 1) {
            throw new IllegalArgumentException();
        }
        if (branch > this._effects.size()) {
            return Collections.emptySet();
        }
        HashSet<ATermAppl> ret = new HashSet<ATermAppl>();
        for (int i = this._effects.size() - 1; i >= branch - 1; --i) {
            Set<ATermAppl> s = this._effects.remove(i);
            if (s == null) continue;
            ret.addAll(s);
        }
        return ret;
    }
}

