/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import openllet.core.utils.MultiMap;

public class MultiValueMap<K, V>
extends ConcurrentHashMap<K, Set<V>>
implements MultiMap<K, V> {
    private static final long serialVersionUID = 2660982967886888197L;

    public MultiValueMap() {
    }

    public MultiValueMap(int initialCapacity) {
        super(initialCapacity);
    }

    public Set<V> putSingle(K key, V value) {
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        set.add(value);
        return super.put(key, set);
    }

    @Override
    public boolean containsKey(Object key) {
        return null == key ? false : super.containsKey(key);
    }

    @Override
    public Set<V> put(K key, Set<V> values) {
        return super.put(key, values);
    }

    public boolean add(K key, V value) {
        Set values = (Set)this.get(key);
        if (null == values) {
            values = Collections.newSetFromMap(new ConcurrentHashMap());
            super.put(key, values);
        }
        return values.add(value);
    }

    public boolean addAll(K key, Collection<? extends V> collection) {
        Set values = (Set)this.get(key);
        if (null == values) {
            values = Collections.newSetFromMap(new ConcurrentHashMap());
            super.put(key, values);
        }
        return values.addAll(collection);
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean removed = false;
        Set values = (Set)this.get(key);
        if (values != null) {
            removed = values.remove(value);
            if (values.isEmpty()) {
                super.remove(key);
            }
        }
        return removed;
    }

    public boolean contains(K key, V value) {
        Set values = (Set)this.get(key);
        if (null == values) {
            return false;
        }
        return values.contains(value);
    }

    public Iterator<V> flattenedValues() {
        return new Iterator<V>(){
            private final Iterator<Set<V>> _setIterator;
            private volatile Iterator<V> _valueIterator;
            {
                this._setIterator = MultiValueMap.this.values().iterator();
                this._valueIterator = null;
            }

            @Override
            public boolean hasNext() {
                while (this._valueIterator == null || !this._valueIterator.hasNext()) {
                    if (!this._setIterator.hasNext()) {
                        return false;
                    }
                    this._valueIterator = this._setIterator.next().iterator();
                }
                return true;
            }

            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this._valueIterator.next();
            }

            @Override
            public void remove() {
                this._setIterator.remove();
            }
        };
    }
}

