/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SetUtils {
    public static <T> Set<T> add(T o, Set<T> set) {
        switch (set.size()) {
            case 0: {
                return Collections.singleton(o);
            }
            case 1: {
                T existing = set.iterator().next();
                if (existing.equals(o)) {
                    return set;
                }
                return SetUtils.binary(existing, o);
            }
        }
        set.add(o);
        return set;
    }

    public static <T> Set<T> remove(Object o, Set<T> set) {
        switch (set.size()) {
            case 0: {
                return set;
            }
            case 1: {
                if (set.contains(o)) {
                    return Collections.emptySet();
                }
                return set;
            }
        }
        set.remove(o);
        return set;
    }

    public static final <T> Set<T> singleton(T o) {
        return Collections.singleton(o);
    }

    public static final <T> Set<T> binary(T o1, T o2) {
        Set<T> set = SetUtils.create();
        set.add(o1);
        set.add(o2);
        return set;
    }

    public static <T> Set<T> union(Collection<? extends Collection<? extends T>> coll) {
        Set<T> set = SetUtils.create();
        for (Collection<T> collection : coll) {
            set.addAll(collection);
        }
        return set;
    }

    public static <T> Set<T> union(Collection<? extends T> c1, Collection<? extends T> c2) {
        Set<T> set = SetUtils.create();
        set.addAll(c1);
        set.addAll(c2);
        return set;
    }

    public static <T> Set<T> intersection(Collection<? extends Collection<? extends T>> coll) {
        Iterator<Collection<T>> i = coll.iterator();
        if (!i.hasNext()) {
            return SetUtils.create();
        }
        Set<T> set = SetUtils.create();
        set.addAll(i.next());
        while (i.hasNext()) {
            Collection<? extends T> innerColl = i.next();
            set.retainAll(innerColl);
        }
        return set;
    }

    public static <T> Set<T> intersection(Collection<? extends T> c1, Collection<? extends T> c2) {
        Set<T> set = SetUtils.create();
        set.addAll(c1);
        set.retainAll(c2);
        return set;
    }

    public static boolean intersects(Collection<?> c1, Collection<?> c2) {
        for (Object name : c1) {
            if (!c2.contains(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean subset(Set<?> sub, Set<?> sup) {
        return sub.size() <= sup.size() && sup.containsAll(sub);
    }

    public static <T> boolean equals(Set<T> s1, Set<T> s2) {
        return s1.size() == s2.size() && s1.containsAll(s2);
    }

    public static <T> Set<T> difference(Collection<T> c1, Collection<? extends Object> c2) {
        Set<T> set = SetUtils.create();
        set.addAll(c1);
        if (c2 instanceof Set) {
            set.removeAll(c2);
        } else {
            for (Object object : c2) {
                set.remove(object);
            }
        }
        return set;
    }

    @SafeVarargs
    public static <T> Set<T> create(T ... elems) {
        Set<T> set = SetUtils.create(elems.length);
        for (T elem : elems) {
            set.add(elem);
        }
        return set;
    }

    public static <T> Set<T> create(int initialSize) {
        return new HashSet(initialSize);
    }

    public static <T> Set<T> create() {
        return new HashSet();
    }

    public static <T> Set<T> create(Collection<? extends T> elements) {
        return new HashSet<T>(elements);
    }
}

