/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import openllet.shared.tools.Log;

public class StatisticsTable<ROW, COL> {
    private static final Logger _logger = Log.getLogger(StatisticsTable.class);
    private final Map<COL, Map<ROW, Number>> _statistics = new HashMap<COL, Map<ROW, Number>>();
    private final List<COL> _cols = new ArrayList<COL>();
    private final List<ROW> _rows = new ArrayList<ROW>();
    private int _firstColumnSize = 10;

    public void add(ROW row, COL col, Number stat) {
        Number getStat;
        Map<ROW, Number> getCol = this._statistics.get(col);
        if (getCol == null) {
            getCol = new HashMap<ROW, Number>();
            this._statistics.put(col, getCol);
            this._cols.add(col);
        }
        if ((getStat = getCol.get(row)) != null) {
            _logger.warning("Overwriting [" + row + " : " + col + "].");
        } else if (!this._rows.contains(row)) {
            if (this._firstColumnSize < row.toString().length()) {
                this._firstColumnSize = row.toString().length();
            }
            this._rows.add(row);
        }
        getCol.put(row, stat);
    }

    public void add(COL col, Map<ROW, ? extends Number> stat) {
        for (Map.Entry<ROW, Number> entry : stat.entrySet()) {
            this.add(entry.getKey(), col, entry.getValue());
        }
    }

    public String toString() {
        String s = "";
        ArrayList<Integer> colSizes = new ArrayList<Integer>();
        for (COL col : this._cols) {
            colSizes.add(col.toString().length() + 2);
        }
        String firstCol = "| %1$-" + (this._firstColumnSize + 2) + "s ";
        StringBuffer lineFormat = new StringBuffer();
        for (int i = 1; i < colSizes.size() + 1; ++i) {
            lineFormat.append("| %").append(i).append("$-10.10s ");
        }
        lineFormat.append("|\n");
        char[] a = new char[String.format(lineFormat.toString(), this._cols.toArray()).length() + String.format(firstCol, "").length()];
        Arrays.fill(a, '=');
        String separator = new String(a);
        s = s + separator + "\n";
        s = s + String.format(firstCol, "") + String.format(lineFormat.toString(), this._cols.toArray());
        s = s + separator + "\n";
        for (ROW row : this._rows) {
            ArrayList<Number> rowData = new ArrayList<Number>();
            for (COL col : this._cols) {
                Map<ROW, Number> map = this._statistics.get(col);
                Number stat = map.get(row);
                if (stat == null) {
                    rowData.add(Double.POSITIVE_INFINITY);
                    continue;
                }
                rowData.add(stat);
            }
            String rowName = row.toString();
            s = s + String.format(firstCol, rowName) + String.format(lineFormat.toString(), rowData.toArray());
        }
        s = s + separator + "\n";
        return s;
    }
}

