/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.shared.tools.Log;

public class VersionInfo {
    public static final Logger _logger = Log.getLogger(VersionInfo.class);
    private Properties versionProperties;
    private static String UNKNOWN = "(unknown)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionInfo() {
        block25: {
            this.versionProperties = null;
            this.versionProperties = new Properties();
            try (InputStream vstream = VersionInfo.class.getResourceAsStream("src/main/resources/openllet/version.properties.in");){
                if (vstream == null) break block25;
                try {
                    this.versionProperties.load(vstream);
                }
                catch (IOException e) {
                    _logger.log(Level.SEVERE, "Could not load version properties", e);
                }
                finally {
                    try {
                        vstream.close();
                    }
                    catch (IOException e) {
                        _logger.log(Level.SEVERE, "Could not close version properties", e);
                    }
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    public static final VersionInfo getInstance() {
        return new VersionInfo();
    }

    public String getVersionString() {
        return this.versionProperties.getProperty("org.mindswap.pellet.version", "(unreleased)");
    }

    public String getReleaseDate() {
        return this.versionProperties.getProperty("org.mindswap.pellet.releaseDate", UNKNOWN);
    }

    public String toString() {
        return "Version: " + this.getVersionString() + " Released: " + this.getReleaseDate();
    }
}

