/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;

public class MultiListIterator
implements Iterator<ATermAppl> {
    private final List<ATermList> _list = new ArrayList<ATermList>(2);
    private int _index = 0;
    private volatile ATermList _curr;

    public MultiListIterator(ATermList first) {
        this._curr = first;
    }

    @Override
    public boolean hasNext() {
        while (this._curr.isEmpty() && this._index < this._list.size()) {
            this._curr = this._list.get(this._index++);
        }
        return !this._curr.isEmpty();
    }

    @Override
    public ATermAppl next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ATermAppl next = (ATermAppl)this._curr.getFirst();
        this._curr = this._curr.getNext();
        return next;
    }

    public void append(ATermList other) {
        this._list.add(other);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

