/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.vocabulary;

import java.util.HashMap;
import java.util.Map;

public enum BuiltinNamespace {
    OWL("http://www.w3.org/2002/07/owl#"),
    RDF("http://www.w3.org/1999/02/22-rdf-syntax-ns#"),
    RDFS("http://www.w3.org/2000/01/rdf-schema#"),
    XSD("http://www.w3.org/2001/XMLSchema#"),
    SWRL("http://www.w3.org/2003/11/swrl#"),
    SWRLB("http://www.w3.org/2003/11/swrlb#");

    private String _uri;
    public static final Map<String, BuiltinNamespace> _uriMap;

    private BuiltinNamespace(String uri) {
        this._uri = uri;
    }

    public String getURI() {
        return this._uri;
    }

    public static BuiltinNamespace find(String uri) {
        return _uriMap.get(uri);
    }

    static {
        _uriMap = new HashMap<String, BuiltinNamespace>();
        for (BuiltinNamespace ns : BuiltinNamespace.values()) {
            _uriMap.put(ns.getURI(), ns);
        }
    }
}

