/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.KnowledgeBase;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.output.ATermBaseVisitor;
import openllet.core.utils.ATermUtils;
import openllet.owlapi.facet.FacetFactoryOWL;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.vocab.OWLFacet;

public class ConceptConverter
extends ATermBaseVisitor
implements FacetFactoryOWL {
    private final KnowledgeBase _kb;
    private final OWLDataFactory _factory;
    private OWLObject _obj;
    private Set<OWLObject> _set;

    @Override
    public OWLDataFactory getFactory() {
        return this._factory;
    }

    public ConceptConverter(KnowledgeBase kb, OWLDataFactory factory) {
        this._kb = kb;
        this._factory = factory;
    }

    public OWLIndividual convertIndividual(ATermAppl term) {
        IRI iri = null;
        if (!ATermUtils.isBnode(term)) {
            iri = IRI.create(term.getName());
        }
        if (this._kb.isIndividual(term)) {
            if (ATermUtils.isBnode(term)) {
                return this._factory.getOWLAnonymousIndividual(((ATermAppl)term.getArgument(0)).getName());
            }
            return this._factory.getOWLNamedIndividual(iri);
        }
        throw new InternalReasonerException("Cannot convert _individual: " + term);
    }

    public OWLObject convert(ATermAppl term) {
        this._obj = null;
        this.visit(term);
        return this._obj;
    }

    public OWLObject getResult() {
        return this._obj;
    }

    @Override
    public void visitTerm(ATermAppl term) {
        this._obj = null;
        IRI iri = null;
        if (!ATermUtils.isBnode(term)) {
            iri = IRI.create(term.getName());
        }
        if (term.equals(OWL_THING)) {
            this._obj = this._factory.getOWLThing();
        } else if (term.equals(OWL_NOTHING)) {
            this._obj = this._factory.getOWLNothing();
        } else if (this._kb.isClass(term)) {
            this._obj = this._factory.getOWLClass(iri);
        } else if (this._kb.isObjectProperty(term)) {
            this._obj = ATermUtils.TOP_OBJECT_PROPERTY.equals(term) ? this._factory.getOWLTopDataProperty() : (ATermUtils.BOTTOM_DATA_PROPERTY.equals(term) ? this._factory.getOWLBottomObjectProperty() : this._factory.getOWLObjectProperty(iri));
        } else if (this._kb.isDatatypeProperty(term)) {
            this._obj = ATermUtils.TOP_DATA_PROPERTY.equals(term) ? this._factory.getOWLTopDataProperty() : (ATermUtils.BOTTOM_DATA_PROPERTY.equals(term) ? this._factory.getOWLBottomDataProperty() : this._factory.getOWLDataProperty(iri));
        } else if (this._kb.isIndividual(term)) {
            this._obj = ATermUtils.isBnode(term) ? this._factory.getOWLAnonymousIndividual(((ATermAppl)term.getArgument(0)).getName()) : this._factory.getOWLNamedIndividual(iri);
        } else if (this._kb.isDatatype(term)) {
            this._obj = this._factory.getOWLDatatype(iri);
        }
        if (this._obj == null) {
            throw new InternalReasonerException("Ontology does not contain: " + term);
        }
    }

    private static <Type, Tmp> Set<Type> dynamicCastTheSet(Collection<Tmp> set, Class<Type> c) {
        return set.stream().filter(c::isInstance).map(c::cast).collect(Collectors.toSet());
    }

    @Override
    public void visitAnd(ATermAppl term) {
        this.visitList((ATermList)term.getArgument(0));
        if (this._obj instanceof OWLClassExpression) {
            this._obj = this._factory.getOWLObjectIntersectionOf(ConceptConverter.dynamicCastTheSet(this._set, OWLClassExpression.class));
        } else if (this._obj instanceof OWLDataRange) {
            this._obj = this._factory.getOWLDataIntersectionOf(ConceptConverter.dynamicCastTheSet(this._set, OWLDataRange.class));
        }
    }

    @Override
    public void visitOr(ATermAppl term) {
        this.visitList((ATermList)term.getArgument(0));
        if (this._obj instanceof OWLClassExpression) {
            this._obj = this._factory.getOWLObjectUnionOf(ConceptConverter.dynamicCastTheSet(this._set, OWLClassExpression.class));
        } else if (this._obj instanceof OWLDataRange) {
            this._obj = this._factory.getOWLDataUnionOf(ConceptConverter.dynamicCastTheSet(this._set, OWLDataRange.class));
        }
    }

    @Override
    public void visitNot(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        if (this._obj instanceof OWLClassExpression) {
            this._obj = this._factory.getOWLObjectComplementOf((OWLClassExpression)this._obj);
        } else if (this._obj instanceof OWLDataRange) {
            this._obj = this._factory.getOWLDataComplementOf((OWLDataRange)this._obj);
        }
    }

    @Override
    public void visitSome(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this._obj;
        this.visit((ATermAppl)term.getArgument(1));
        if (prop instanceof OWLObjectPropertyExpression) {
            OWLClassExpression desc = (OWLClassExpression)this._obj;
            this._obj = this._factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)prop, desc);
        } else {
            OWLDataRange datatype = (OWLDataRange)this._obj;
            this._obj = this._factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)((OWLDataProperty)prop), datatype);
        }
    }

    @Override
    public void visitAll(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this._obj;
        this.visit((ATermAppl)term.getArgument(1));
        if (prop instanceof OWLObjectPropertyExpression) {
            OWLClassExpression desc = (OWLClassExpression)this._obj;
            this._obj = this._factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)prop, desc);
        } else {
            OWLDataRange datatype = (OWLDataRange)this._obj;
            this._obj = this._factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)((OWLDataProperty)prop), datatype);
        }
    }

    @Override
    public void visitMin(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this._obj;
        int cardinality = Integer.parseInt(term.getArgument(1).toString());
        if (prop instanceof OWLObjectPropertyExpression) {
            OWLClassExpression c = (OWLClassExpression)this.convert((ATermAppl)term.getArgument(2));
            this._obj = this._factory.getOWLObjectMinCardinality(cardinality, (OWLObjectPropertyExpression)prop, c);
        } else {
            OWLDataRange d = (OWLDataRange)this.convert((ATermAppl)term.getArgument(2));
            this._obj = this._factory.getOWLDataMinCardinality(cardinality, (OWLDataPropertyExpression)((OWLDataProperty)prop), d);
        }
    }

    @Override
    public void visitCard(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this._obj;
        int cardinality = Integer.parseInt(term.getArgument(1).toString());
        if (prop instanceof OWLObjectPropertyExpression) {
            OWLClassExpression c = (OWLClassExpression)this.convert((ATermAppl)term.getArgument(2));
            this._obj = this._factory.getOWLObjectExactCardinality(cardinality, (OWLObjectPropertyExpression)prop, c);
        } else {
            OWLDataRange d = (OWLDataRange)this.convert((ATermAppl)term.getArgument(2));
            this._obj = this._factory.getOWLDataExactCardinality(cardinality, (OWLDataPropertyExpression)((OWLDataProperty)prop), d);
        }
    }

    @Override
    public void visitMax(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this._obj;
        int cardinality = Integer.parseInt(term.getArgument(1).toString());
        if (prop instanceof OWLObjectPropertyExpression) {
            OWLClassExpression c = (OWLClassExpression)this.convert((ATermAppl)term.getArgument(2));
            this._obj = this._factory.getOWLObjectMaxCardinality(cardinality, (OWLObjectPropertyExpression)prop, c);
        } else {
            OWLDataRange d = (OWLDataRange)this.convert((ATermAppl)term.getArgument(2));
            this._obj = this._factory.getOWLDataMaxCardinality(cardinality, (OWLDataPropertyExpression)((OWLDataProperty)prop), d);
        }
    }

    @Override
    public void visitHasValue(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this._obj;
        if (prop instanceof OWLObjectProperty) {
            OWLIndividual ind = this.convertIndividual((ATermAppl)((ATermAppl)term.getArgument(1)).getArgument(0));
            this._obj = this._factory.getOWLObjectHasValue((OWLObjectPropertyExpression)prop, ind);
        } else {
            this.visit((ATermAppl)((ATermAppl)term.getArgument(1)).getArgument(0));
            OWLLiteral dataVal = (OWLLiteral)this._obj;
            this._obj = this._factory.getOWLDataHasValue((OWLDataProperty)prop, dataVal);
        }
    }

    @Override
    public void visitValue(ATermAppl term) {
        ATermAppl nominal = (ATermAppl)term.getArgument(0);
        if (ATermUtils.isLiteral(nominal)) {
            this.visitLiteral(nominal);
            this._obj = this._factory.getOWLDataOneOf((OWLLiteral)this._obj);
        } else {
            this._obj = this._factory.getOWLObjectOneOf(this.convertIndividual(nominal));
        }
    }

    @Override
    public void visitSelf(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this._obj;
        this._obj = this._factory.getOWLObjectHasSelf(prop);
    }

    @Override
    public void visitOneOf(ATermAppl term) {
        ATermList list = (ATermList)term.getArgument(0);
        if (ATermUtils.isLiteral((ATermAppl)((ATermAppl)list.getFirst()).getArgument(0))) {
            HashSet<OWLLiteral> set = new HashSet<OWLLiteral>();
            while (!list.isEmpty()) {
                ATermAppl first = (ATermAppl)list.getFirst();
                if (!ATermUtils.isLiteral((ATermAppl)first.getArgument(0))) {
                    throw new InternalReasonerException("Conversion error, expecting literal but found: " + first);
                }
                this.visitLiteral((ATermAppl)first.getArgument(0));
                set.add((OWLLiteral)this._obj);
                list = list.getNext();
            }
            this._obj = this._factory.getOWLDataOneOf(set);
        } else {
            HashSet<OWLIndividual> set = new HashSet<OWLIndividual>();
            while (!list.isEmpty()) {
                ATermAppl first = (ATermAppl)list.getFirst();
                OWLIndividual ind = this.convertIndividual((ATermAppl)first.getArgument(0));
                set.add(ind);
                list = list.getNext();
            }
            this._obj = this._factory.getOWLObjectOneOf(set);
        }
    }

    @Override
    public void visitLiteral(ATermAppl term) {
        String lexValue = ((ATermAppl)term.getArgument(0)).toString();
        ATermAppl lang = (ATermAppl)term.getArgument(1);
        ATermAppl dtype = (ATermAppl)term.getArgument(2);
        if (dtype.equals(ATermUtils.PLAIN_LITERAL_DATATYPE)) {
            this._obj = lang.equals(ATermUtils.EMPTY) ? this._factory.getOWLLiteral(lexValue) : this._factory.getOWLLiteral(lexValue, lang.toString());
        } else {
            IRI dtypeIRI = IRI.create(dtype.toString());
            OWLDatatype datatype = this._factory.getOWLDatatype(dtypeIRI);
            this._obj = this._factory.getOWLLiteral(lexValue, datatype);
        }
    }

    @Override
    public void visitList(ATermList listParam) {
        ATermList list = listParam;
        this._set = null;
        HashSet<OWLObject> elements = new HashSet<OWLObject>();
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            this.visit(term);
            if (this._obj == null) {
                return;
            }
            elements.add(this._obj);
            list = list.getNext();
        }
        this._set = elements;
    }

    @Override
    public void visitInverse(ATermAppl p) {
        OWLObjectProperty prop = (OWLObjectProperty)this.convert((ATermAppl)p.getArgument(0));
        this._obj = this._factory.getOWLObjectInverseOf(prop);
    }

    @Override
    public void visitRestrictedDatatype(ATermAppl dt) {
        OWLDatatype baseDatatype = this._factory.getOWLDatatype(IRI.create(((ATermAppl)dt.getArgument(0)).getName()));
        HashSet<OWLFacetRestriction> restrictions = new HashSet<OWLFacetRestriction>();
        ATermList list = (ATermList)dt.getArgument(1);
        while (!list.isEmpty()) {
            ATermAppl facet = (ATermAppl)list.getFirst();
            String facetName = ((ATermAppl)facet.getArgument(0)).getName();
            ATermAppl facetValue = (ATermAppl)facet.getArgument(1);
            this.visitLiteral(facetValue);
            restrictions.add(this._factory.getOWLFacetRestriction(OWLFacet.getFacet(IRI.create(facetName)), (OWLLiteral)this._obj));
            list = list.getNext();
        }
        this._obj = this._factory.getOWLDatatypeRestriction(baseDatatype, restrictions);
    }
}

