/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.owlapi.EntailmentQueryVisitor;
import openllet.owlapi.OpenlletReasoner;
import openllet.owlapi.facet.FacetReasonerOWL;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class EntailmentChecker
implements OWLAxiomVisitor,
FacetReasonerOWL {
    public static Logger _logger = Log.getLogger(EntailmentChecker.class);
    public static final Set<AxiomType<?>> UNSUPPORTED_ENTAILMENT = Collections.unmodifiableSet(new HashSet<AxiomType>(Arrays.asList(AxiomType.DISJOINT_UNION, AxiomType.DATATYPE_DEFINITION, AxiomType.HAS_KEY, AxiomType.SUB_PROPERTY_CHAIN_OF, AxiomType.SWRL_RULE)));
    private final KnowledgeBase _kb;
    private final EntailmentQueryVisitor _queryVisitor;
    private final OpenlletReasoner _reasoner;
    private boolean _isDeferred = false;
    private boolean _isEntailed = false;

    @Override
    public OpenlletReasoner getReasoner() {
        return this._reasoner;
    }

    public EntailmentChecker(OpenlletReasoner reasoner) {
        this._reasoner = reasoner;
        this._kb = reasoner.getKB();
        this._queryVisitor = new EntailmentQueryVisitor(reasoner);
    }

    private void deferAxiom(OWLIndividualAxiom axiom) {
        this._isDeferred = true;
        axiom.accept(this._queryVisitor);
    }

    private boolean isEntailed(OWLAxiom axiom) {
        this._isDeferred = false;
        this._isEntailed = false;
        axiom.accept(this);
        return this._isDeferred || this._isEntailed;
    }

    public boolean isEntailed(Stream<? extends OWLAxiom> axioms) {
        this._queryVisitor.reset();
        Optional<OWLAxiom> unEntailed = axioms.filter(axiom -> !this.isEntailed((OWLAxiom)axiom)).findAny();
        if (unEntailed.isPresent()) {
            _logger.fine("Axiom not entailed: (" + unEntailed.get() + ")");
            return false;
        }
        return this._queryVisitor.isEntailed();
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axioms) {
        if (axioms.isEmpty()) {
            _logger.warning("Empty ontologies are entailed by any premise document!");
            return true;
        }
        return this.isEntailed(axioms.stream());
    }

    public Set<OWLAxiom> findNonEntailments(Set<? extends OWLAxiom> axioms, boolean findAll) {
        HashSet<OWLAxiom> nonEntailments = new HashSet<OWLAxiom>();
        if (axioms.isEmpty()) {
            _logger.warning("Empty ontologies are entailed by any premise document!");
        } else {
            HashSet<OWLAxiom> deferredAxioms = new HashSet<OWLAxiom>();
            this._queryVisitor.reset();
            for (OWLAxiom oWLAxiom : axioms) {
                if (!this.isEntailed(oWLAxiom)) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("Axiom not entailed: (" + oWLAxiom + ")");
                    }
                    nonEntailments.add(oWLAxiom);
                    if (!findAll) continue;
                    break;
                }
                if (!this._isDeferred) continue;
                deferredAxioms.add(oWLAxiom);
            }
            if ((findAll || nonEntailments.isEmpty()) && !this._queryVisitor.isEntailed()) {
                nonEntailments.addAll(deferredAxioms);
            }
        }
        return nonEntailments;
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        this._isEntailed = this._kb.isSubClassOf(this._reasoner.term(axiom.getSubClass()), this._reasoner.term(axiom.getSuperClass()));
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        OWLIndividual s = axiom.getSubject();
        OWLIndividual o = (OWLIndividual)axiom.getObject();
        if (s.isAnonymous() || o.isAnonymous()) {
            this.deferAxiom(axiom);
            return;
        }
        OWLDataFactory factory = this._reasoner.getManager().getOWLDataFactory();
        OWLObjectHasValue hasValue = factory.getOWLObjectHasValue((OWLObjectPropertyExpression)axiom.getProperty(), o);
        OWLObjectComplementOf doesNotHaveValue = factory.getOWLObjectComplementOf(hasValue);
        this._isEntailed = this._kb.isType(this._reasoner.term(s), this._reasoner.term(doesNotHaveValue));
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this._isEntailed = this._kb.isAsymmetricProperty(this._reasoner.term((OWLObject)axiom.getProperty()));
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this._isEntailed = this._kb.isReflexiveProperty(this._reasoner.term((OWLObject)axiom.getProperty()));
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this._isEntailed = true;
        ATermAppl[] terms = (ATermAppl[])axiom.classExpressions().map(this._reasoner::term).toArray(ATermAppl[]::new);
        int n = terms.length;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this._kb.isDisjoint(terms[i], terms[j])) continue;
                this._isEntailed = false;
                return;
            }
        }
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this._isEntailed = this._kb.hasDomain(this._reasoner.term((OWLObject)axiom.getProperty()), this._reasoner.term((OWLObject)axiom.getDomain()));
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this._isEntailed = this._kb.hasDomain(this._reasoner.term((OWLObject)axiom.getProperty()), this._reasoner.term((OWLObject)axiom.getDomain()));
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this._isEntailed = true;
        Iterator i = axiom.properties().iterator();
        if (i.hasNext()) {
            OWLObjectPropertyExpression head = (OWLObjectPropertyExpression)i.next();
            while (i.hasNext() && this._isEntailed) {
                OWLObjectPropertyExpression next = (OWLObjectPropertyExpression)i.next();
                this._isEntailed = this._kb.isEquivalentProperty(this._reasoner.term(head), this._reasoner.term(next));
            }
        }
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        OWLIndividual s = axiom.getSubject();
        if (s.isAnonymous()) {
            this.deferAxiom(axiom);
            return;
        }
        OWLDataFactory factory = this._reasoner.getManager().getOWLDataFactory();
        OWLDataHasValue hasValue = factory.getOWLDataHasValue((OWLDataPropertyExpression)axiom.getProperty(), (OWLLiteral)axiom.getObject());
        OWLObjectComplementOf doesNotHaveValue = factory.getOWLObjectComplementOf(hasValue);
        this._isEntailed = this._kb.isType(this._reasoner.term(s), this._reasoner.term(doesNotHaveValue));
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this._isEntailed = true;
        for (OWLIndividual ind : OWLAPIStreamUtils.asList(axiom.individuals())) {
            if (!ind.isAnonymous()) continue;
            this.deferAxiom(axiom);
            return;
        }
        OWLIndividual[] list = (OWLIndividual[])axiom.individuals().toArray(OWLIndividual[]::new);
        for (int i = 0; i < list.length - 1; ++i) {
            OWLIndividual head = list[i];
            for (int j = i + 1; j < list.length; ++j) {
                OWLIndividual next = list[j];
                if (this._kb.isDifferentFrom(this._reasoner.term(head), this._reasoner.term(next))) continue;
                this._isEntailed = false;
                return;
            }
        }
    }

    private void visitProperties(OWLObject[] properties) {
        this._isEntailed = true;
        int n = properties.length;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this._kb.isDisjointProperty(this._reasoner.term(properties[i]), this._reasoner.term(properties[j]))) continue;
                this._isEntailed = false;
                return;
            }
        }
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.visitProperties((OWLObject[])axiom.properties().toArray(OWLDataProperty[]::new));
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.visitProperties((OWLObject[])axiom.properties().toArray(OWLObjectPropertyExpression[]::new));
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this._isEntailed = this._kb.hasRange(this._reasoner.term((OWLObject)axiom.getProperty()), this._reasoner.term((OWLObject)axiom.getRange()));
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        OWLIndividual s = axiom.getSubject();
        OWLIndividual o = (OWLIndividual)axiom.getObject();
        if (s.isAnonymous() || o.isAnonymous()) {
            this.deferAxiom(axiom);
            return;
        }
        this._isEntailed = this._kb.hasPropertyValue(this._reasoner.term(s), this._reasoner.term(axiom.getProperty()), this._reasoner.term(o));
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this._isEntailed = this._kb.isFunctionalProperty(this._reasoner.term((OWLObject)axiom.getProperty()));
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this._isEntailed = this._kb.isSubPropertyOf(this._reasoner.term((OWLObject)axiom.getSubProperty()), this._reasoner.term((OWLObject)axiom.getSuperProperty()));
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        assert (UNSUPPORTED_ENTAILMENT.contains(axiom.getAxiomType()));
        throw new UnsupportedOperationException("Unsupported entailment query: " + axiom);
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        assert (UNSUPPORTED_ENTAILMENT.contains(axiom.getAxiomType()));
        throw new UnsupportedOperationException("Unsupported entailment query: " + axiom);
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        this._isEntailed = true;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Ignoring declaration " + axiom);
        }
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this._isEntailed = this._kb.isSymmetricProperty(this._reasoner.term((OWLObject)axiom.getProperty()));
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this._isEntailed = this._kb.hasRange(this._reasoner.term((OWLObject)axiom.getProperty()), this._reasoner.term((OWLObject)axiom.getRange()));
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this._isEntailed = this._kb.isFunctionalProperty(this._reasoner.term((OWLObject)axiom.getProperty()));
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this._isEntailed = true;
        Iterator i = axiom.properties().iterator();
        if (i.hasNext()) {
            OWLDataProperty first = (OWLDataProperty)i.next();
            while (i.hasNext() && this._isEntailed) {
                OWLDataProperty next = (OWLDataProperty)i.next();
                this._isEntailed = this._kb.isEquivalentProperty(this._reasoner.term(first), this._reasoner.term(next));
            }
        }
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        OWLIndividual ind = axiom.getIndividual();
        OWLClassExpression c = axiom.getClassExpression();
        if (ind.isAnonymous()) {
            this.deferAxiom(axiom);
            return;
        }
        this._isEntailed = this._kb.isType(this._reasoner.term(ind), this._reasoner.term(c));
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this._isEntailed = true;
        Iterator i = axiom.classExpressions().iterator();
        if (i.hasNext()) {
            OWLClassExpression first = (OWLClassExpression)i.next();
            while (i.hasNext() && this._isEntailed) {
                OWLClassExpression next = (OWLClassExpression)i.next();
                this._isEntailed = this._kb.isEquivalentClass(this._reasoner.term(first), this._reasoner.term(next));
            }
        }
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        OWLIndividual s = axiom.getSubject();
        if (s.isAnonymous()) {
            this.deferAxiom(axiom);
            return;
        }
        this._isEntailed = this._kb.hasPropertyValue(this._reasoner.term(s), this._reasoner.term(axiom.getProperty()), this._reasoner.term((OWLObject)axiom.getObject()));
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this._isEntailed = this._kb.isTransitiveProperty(this._reasoner.term((OWLObject)axiom.getProperty()));
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this._isEntailed = this._kb.isIrreflexiveProperty(this._reasoner.term((OWLObject)axiom.getProperty()));
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this._isEntailed = this._kb.isSubPropertyOf(this._reasoner.term((OWLObject)axiom.getSubProperty()), this._reasoner.term((OWLObject)axiom.getSuperProperty()));
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this._isEntailed = this._kb.isInverseFunctionalProperty(this._reasoner.term((OWLObject)axiom.getProperty()));
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
        assert (UNSUPPORTED_ENTAILMENT.contains(axiom.getAxiomType()));
        throw new UnsupportedOperationException("Unsupported entailment query: " + axiom);
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        for (OWLIndividual ind : OWLAPIStreamUtils.asList(axiom.individuals())) {
            if (!ind.isAnonymous()) continue;
            this.deferAxiom(axiom);
            return;
        }
        this._isEntailed = true;
        Iterator i = axiom.individuals().iterator();
        if (i.hasNext()) {
            OWLIndividual first = (OWLIndividual)i.next();
            while (i.hasNext()) {
                OWLIndividual next = (OWLIndividual)i.next();
                if (this._kb.isSameAs(this._reasoner.term(first), this._reasoner.term(next))) continue;
                this._isEntailed = false;
                return;
            }
        }
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        assert (UNSUPPORTED_ENTAILMENT.contains(axiom.getAxiomType()));
        throw new UnsupportedOperationException("Unsupported entailment query: " + axiom);
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this._isEntailed = this._kb.isInverse(this._reasoner.term(axiom.getFirstProperty()), this._reasoner.term(axiom.getSecondProperty()));
    }

    @Override
    public void visit(SWRLRule rule) {
        assert (UNSUPPORTED_ENTAILMENT.contains(rule.getAxiomType()));
        throw new UnsupportedOperationException("Unsupported entailment query: " + rule);
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this._isEntailed = true;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Ignoring annotation assertion axiom " + axiom);
        }
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this._isEntailed = true;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Ignoring annotation property domain " + axiom);
        }
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this._isEntailed = true;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Ignoring annotation property range " + axiom);
        }
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this._isEntailed = true;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Ignoring sub annotation property axiom " + axiom);
        }
    }
}

