/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Stream;
import openllet.atom.OpenError;
import openllet.owlapi.IRIUtils;
import openllet.owlapi.OWLGroup;
import openllet.owlapi.facet.FacetFactoryOWL;
import openllet.owlapi.facet.FacetManagerOWL;
import openllet.shared.tools.Log;
import openllet.shared.tools.Logging;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OWL
implements FacetManagerOWL,
FacetFactoryOWL,
Logging {
    private static final Logger _logger = Log.getLogger(OWL.class);
    public static final OWLOntologyManager _manager = OWLManager.createConcurrentOWLOntologyManager();
    public static final OWLGroup _managerGroup = OWLGroup.fromVolatileManager(_manager);
    public static final OWLDataFactory _factory = _manager.getOWLDataFactory();
    public static final OWLClass Nothing = _factory.getOWLNothing();
    public static final OWLClass Thing = _factory.getOWLThing();
    public static final OWLObjectProperty topObjectProperty = OWL.ObjectProperty("http://www.w3.org/2002/07/owl#topObjectProperty");
    public static final OWLObjectProperty bottomObjectProperty = OWL.ObjectProperty("http://www.w3.org/2002/07/owl#bottomObjectProperty");
    public static final OWLDataProperty topDataProperty = OWL.DataProperty("http://www.w3.org/2002/07/owl#topDataProperty");
    public static final OWLDataProperty bottomDataProperty = OWL.DataProperty("http://www.w3.org/2002/07/owl#bottomDataProperty");
    public static final OWLLiteral TRUE = _factory.getOWLLiteral(true);
    public static final OWLLiteral FALSE = _factory.getOWLLiteral(false);

    @Override
    public Logger getLogger() {
        return _logger;
    }

    @Override
    public OWLDataFactory getFactory() {
        return _factory;
    }

    @Override
    public OWLOntologyManager getManager() {
        return _manager;
    }

    @Override
    public OWLGroup getGroup() {
        return _managerGroup;
    }

    public static OWLOntology Ontology(OWLOntologyManager manager, Collection<? extends OWLAxiom> axioms) {
        return OWL.Ontology(manager, axioms.stream());
    }

    public static OWLOntology Ontology(OWLOntologyManager manager, Stream<? extends OWLAxiom> axioms) {
        return OWL.Ontology(manager, axioms, IRI.create("http://www.example.org/ontology" + UUID.randomUUID()));
    }

    public static OWLOntology Ontology(OWLOntologyManager manager, Collection<? extends OWLAxiom> axioms, IRI iri) {
        return OWL.Ontology(manager, axioms.stream(), iri);
    }

    public static OWLOntology Ontology(OWLOntologyManager manager, Stream<? extends OWLAxiom> axioms, IRI iri) {
        try {
            return manager.createOntology(axioms, iri);
        }
        catch (OWLOntologyCreationException e) {
            throw new OpenError(e);
        }
        catch (OWLOntologyChangeException e) {
            throw new OpenError(e);
        }
    }

    public static OWLOntology Ontology(OWLOntologyManager manager, OWLAxiom ... axioms) {
        return OWL.Ontology(manager, Arrays.asList(axioms));
    }

    public static OWLOntology Ontology(Collection<? extends OWLAxiom> axioms) {
        return OWL.Ontology(_manager, axioms.stream());
    }

    public static OWLOntology Ontology(Stream<? extends OWLAxiom> axioms) {
        return OWL.Ontology(_manager, axioms);
    }

    public static OWLOntology Ontology(Collection<? extends OWLAxiom> axioms, IRI iri) {
        return OWL.Ontology(_manager, axioms.stream(), iri);
    }

    public static OWLOntology Ontology(Stream<? extends OWLAxiom> axioms, IRI iri) {
        return OWL.Ontology(_manager, axioms, iri);
    }

    public static OWLOntology Ontology(OWLAxiom ... axioms) {
        return OWL.Ontology(Arrays.asList(axioms));
    }

    public static OWLDataAllValuesFrom all(OWLDataPropertyExpression property, OWLDataRange datatype) {
        return _factory.getOWLDataAllValuesFrom(property, datatype);
    }

    public static OWLObjectAllValuesFrom all(OWLObjectPropertyExpression property, OWLClassExpression description) {
        return _factory.getOWLObjectAllValuesFrom(property, description);
    }

    @Deprecated
    public static OWLObjectAllValuesFrom allValuesFrom(OWLObjectPropertyExpression property, OWLClassExpression description) {
        return _factory.getOWLObjectAllValuesFrom(property, description);
    }

    public static OWLObjectIntersectionOf and(OWLClassExpression ... descriptions) {
        return _factory.getOWLObjectIntersectionOf(OWL.set(descriptions));
    }

    public static OWLObjectIntersectionOf and(Set<? extends OWLClassExpression> descriptions) {
        return _factory.getOWLObjectIntersectionOf(descriptions);
    }

    public static OWLObjectIntersectionOf and(Stream<? extends OWLClassExpression> descriptions) {
        return _factory.getOWLObjectIntersectionOf(descriptions);
    }

    public static OWLDataIntersectionOf dataAnd(OWLDataRange ... descriptions) {
        return _factory.getOWLDataIntersectionOf(OWL.set(descriptions));
    }

    public static OWLDataIntersectionOf dataAnd(Set<? extends OWLDataRange> descriptions) {
        return _factory.getOWLDataIntersectionOf(descriptions);
    }

    public static OWLAnnotationAssertionAxiom annotation(OWLEntity entity, OWLAnnotation annotation) {
        return _factory.getOWLAnnotationAssertionAxiom(entity.getIRI(), annotation);
    }

    public static OWLAnnotationAssertionAxiom annotation(OWLEntity entity, IRI annotationIRI, OWLLiteral constant) {
        return _factory.getOWLAnnotationAssertionAxiom(_factory.getOWLAnnotationProperty(annotationIRI), entity.getIRI(), constant);
    }

    public static OWLAnnotationAssertionAxiom annotation(OWLEntity entity, IRI annotationIRI, OWLIndividual individual) {
        if (individual.isAnonymous()) {
            return _factory.getOWLAnnotationAssertionAxiom(entity.getIRI(), _factory.getOWLAnnotation(_factory.getOWLAnnotationProperty(annotationIRI), individual.asOWLAnonymousIndividual()));
        }
        return _factory.getOWLAnnotationAssertionAxiom(entity.getIRI(), _factory.getOWLAnnotation(_factory.getOWLAnnotationProperty(annotationIRI), individual.asOWLNamedIndividual().getIRI()));
    }

    public static OWLAnonymousIndividual AnonymousIndividual() {
        return _factory.getOWLAnonymousIndividual();
    }

    public static OWLAnonymousIndividual AnonymousIndividual(String anonId) {
        return _factory.getOWLAnonymousIndividual(anonId);
    }

    public static OWLAsymmetricObjectPropertyAxiom asymmetric(OWLObjectPropertyExpression p) {
        return _factory.getOWLAsymmetricObjectPropertyAxiom(p);
    }

    public static OWLClass Class(String iri) {
        return _factory.getOWLClass(IRI.create(iri));
    }

    public static OWLClass Class(IRI iri) {
        return _factory.getOWLClass(iri);
    }

    public static OWLClassAssertionAxiom classAssertion(OWLIndividual ind, OWLClassExpression desc) {
        return _factory.getOWLClassAssertionAxiom(desc, ind);
    }

    public static OWLAnnotationAssertionAxiom comment(OWLEntity entity, String comment) {
        return _factory.getOWLAnnotationAssertionAxiom(entity.getIRI(), _factory.getOWLAnnotation(_factory.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_COMMENT.getIRI()), _factory.getOWLLiteral(comment)));
    }

    @Deprecated
    public static OWLObjectComplementOf complementOf(OWLClassExpression description) {
        return _factory.getOWLObjectComplementOf(description);
    }

    public static OWLLiteral constant(boolean value) {
        return _factory.getOWLLiteral(value);
    }

    public static OWLLiteral constant(double value) {
        return _factory.getOWLLiteral(value);
    }

    public static OWLLiteral constant(float value) {
        return _factory.getOWLLiteral(value);
    }

    public static OWLLiteral constant(int value) {
        return _factory.getOWLLiteral(value);
    }

    public static OWLLiteral constant(String value) {
        return _factory.getOWLLiteral(value);
    }

    public static OWLLiteral constant(String value, OWLDatatype datatype) {
        return _factory.getOWLLiteral(value, datatype);
    }

    public static OWLLiteral constant(String value, String lang) {
        return _factory.getOWLLiteral(value, lang);
    }

    public static OWLDataProperty DataProperty(String iri) {
        return _factory.getOWLDataProperty(IRI.create(iri));
    }

    public static OWLDataProperty DataProperty(IRI iri) {
        return _factory.getOWLDataProperty(iri);
    }

    public static OWLDatatype Datatype(String datatypeURI) {
        return _factory.getOWLDatatype(IRI.create(datatypeURI));
    }

    public static OWLDatatype Datatype(IRI datatypeIRI) {
        return _factory.getOWLDatatype(datatypeIRI);
    }

    public static OWLDeclarationAxiom declaration(OWLEntity entity) {
        return _factory.getOWLDeclarationAxiom(entity);
    }

    public static OWLDifferentIndividualsAxiom differentFrom(OWLIndividual i1, OWLIndividual i2) {
        return _factory.getOWLDifferentIndividualsAxiom(OWL.set(i1, i2));
    }

    public static OWLDifferentIndividualsAxiom differentFrom(Set<OWLIndividual> inds) {
        return _factory.getOWLDifferentIndividualsAxiom(inds);
    }

    public static OWLDisjointClassesAxiom disjointClasses(OWLClassExpression d1, OWLClassExpression d2) {
        return _factory.getOWLDisjointClassesAxiom(OWL.set(d1, d2));
    }

    public static OWLDisjointClassesAxiom disjointClasses(Set<? extends OWLClassExpression> descriptions) {
        return _factory.getOWLDisjointClassesAxiom(descriptions);
    }

    public static OWLDisjointDataPropertiesAxiom disjointProperties(OWLDataPropertyExpression d1, OWLDataPropertyExpression d2) {
        return _factory.getOWLDisjointDataPropertiesAxiom(OWL.set(d1, d2));
    }

    public static OWLDisjointObjectPropertiesAxiom disjointProperties(OWLObjectPropertyExpression d1, OWLObjectPropertyExpression d2) {
        return _factory.getOWLDisjointObjectPropertiesAxiom(OWL.set(d1, d2));
    }

    public static OWLDataPropertyDomainAxiom domain(OWLDataPropertyExpression p, OWLClassExpression d) {
        return _factory.getOWLDataPropertyDomainAxiom(p, d);
    }

    public static OWLObjectPropertyDomainAxiom domain(OWLObjectPropertyExpression p, OWLClassExpression d) {
        return _factory.getOWLObjectPropertyDomainAxiom(p, d);
    }

    public static OWLDatatypeDefinitionAxiom datatypeDefinition(OWLDatatype d1, OWLDataRange d2) {
        return _factory.getOWLDatatypeDefinitionAxiom(d1, d2);
    }

    public static OWLEquivalentClassesAxiom equivalentClasses(OWLClassExpression d1, OWLClassExpression d2) {
        return _factory.getOWLEquivalentClassesAxiom(OWL.set(d1, d2));
    }

    public static OWLEquivalentClassesAxiom equivalentClasses(Set<? extends OWLClassExpression> descriptions) {
        return _factory.getOWLEquivalentClassesAxiom(descriptions);
    }

    public static OWLEquivalentClassesAxiom equivalentClasses(Stream<? extends OWLClassExpression> descriptions) {
        return _factory.getOWLEquivalentClassesAxiom(descriptions);
    }

    public static OWLEquivalentDataPropertiesAxiom equivalentDataProperties(OWLDataPropertyExpression p1, OWLDataPropertyExpression p2) {
        return _factory.getOWLEquivalentDataPropertiesAxiom(OWL.set(p1, p2));
    }

    public static OWLEquivalentDataPropertiesAxiom equivalentDataProperties(Set<? extends OWLDataPropertyExpression> properties) {
        return _factory.getOWLEquivalentDataPropertiesAxiom(properties);
    }

    public static OWLEquivalentObjectPropertiesAxiom equivalentProperties(OWLObjectPropertyExpression p1, OWLObjectPropertyExpression p2) {
        return _factory.getOWLEquivalentObjectPropertiesAxiom(OWL.set(p1, p2));
    }

    public static OWLEquivalentObjectPropertiesAxiom equivalentProperties(Set<? extends OWLObjectPropertyExpression> properties) {
        return _factory.getOWLEquivalentObjectPropertiesAxiom(properties);
    }

    public static OWLClassExpression exactly(OWLDataProperty p, int card) {
        return _factory.getOWLDataExactCardinality(card, p);
    }

    public static OWLClassExpression exactly(OWLDataProperty p, int card, OWLDataRange d) {
        return _factory.getOWLDataExactCardinality(card, (OWLDataPropertyExpression)p, d);
    }

    public static OWLClassExpression exactly(OWLObjectProperty p, int card) {
        return _factory.getOWLObjectExactCardinality(card, p);
    }

    public static OWLClassExpression exactly(OWLObjectProperty p, int card, OWLClassExpression desc) {
        return _factory.getOWLObjectExactCardinality(card, p, desc);
    }

    public static OWLFunctionalDataPropertyAxiom functional(OWLDataPropertyExpression p) {
        return _factory.getOWLFunctionalDataPropertyAxiom(p);
    }

    public static OWLFunctionalObjectPropertyAxiom functional(OWLObjectPropertyExpression p) {
        return _factory.getOWLFunctionalObjectPropertyAxiom(p);
    }

    public static OWLNamedIndividual Individual(String iri) {
        return _factory.getOWLNamedIndividual(IRI.create(iri));
    }

    public static OWLNamedIndividual Individual(IRI iri) {
        return _factory.getOWLNamedIndividual(iri);
    }

    public static OWLObjectInverseOf inverse(OWLObjectProperty p) {
        return _factory.getOWLObjectInverseOf(p);
    }

    public static OWLInverseFunctionalObjectPropertyAxiom inverseFunctional(OWLObjectPropertyExpression p) {
        return _factory.getOWLInverseFunctionalObjectPropertyAxiom(p);
    }

    public static OWLInverseObjectPropertiesAxiom inverseProperties(OWLObjectPropertyExpression p1, OWLObjectPropertyExpression p2) {
        return _factory.getOWLInverseObjectPropertiesAxiom(p1, p2);
    }

    public static OWLIrreflexiveObjectPropertyAxiom irreflexive(OWLObjectPropertyExpression p) {
        return _factory.getOWLIrreflexiveObjectPropertyAxiom(p);
    }

    public static OWLAnnotationAssertionAxiom label(OWLEntity entity, String label) {
        return _factory.getOWLAnnotationAssertionAxiom(_factory.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_LABEL.getIRI()), entity.getIRI(), _factory.getOWLLiteral(label));
    }

    public static OWLFacetRestriction length(int constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.LENGTH, constant);
    }

    public static OWLFacetRestriction length(OWLLiteral constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.LENGTH, constant);
    }

    public static OWLDataMaxCardinality max(OWLDataPropertyExpression p, int max) {
        return _factory.getOWLDataMaxCardinality(max, p);
    }

    public static OWLDataMaxCardinality max(OWLDataPropertyExpression p, int max, OWLDataRange filler) {
        return _factory.getOWLDataMaxCardinality(max, p, filler);
    }

    public static OWLObjectMaxCardinality max(OWLObjectPropertyExpression p, int max) {
        return _factory.getOWLObjectMaxCardinality(max, p);
    }

    public static OWLObjectMaxCardinality max(OWLObjectPropertyExpression p, int max, OWLClassExpression filler) {
        return _factory.getOWLObjectMaxCardinality(max, p, filler);
    }

    public static OWLFacetRestriction maxExclusive(double constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, constant);
    }

    public static OWLFacetRestriction maxExclusive(float constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, constant);
    }

    public static OWLFacetRestriction maxExclusive(int constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, constant);
    }

    public static OWLFacetRestriction maxExclusive(OWLLiteral constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, constant);
    }

    public static OWLFacetRestriction maxInclusive(double constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, constant);
    }

    public static OWLFacetRestriction maxInclusive(float constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, constant);
    }

    public static OWLFacetRestriction maxInclusive(int constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, constant);
    }

    public static OWLFacetRestriction maxInclusive(OWLLiteral constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, constant);
    }

    public static OWLFacetRestriction maxLength(int constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MAX_LENGTH, constant);
    }

    public static OWLFacetRestriction maxLength(OWLLiteral constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MAX_LENGTH, constant);
    }

    public static OWLDataMinCardinality min(OWLDataPropertyExpression p, int min) {
        return _factory.getOWLDataMinCardinality(min, p);
    }

    public static OWLDataMinCardinality min(OWLDataPropertyExpression p, int min, OWLDataRange filler) {
        return _factory.getOWLDataMinCardinality(min, p, filler);
    }

    public static OWLObjectMinCardinality min(OWLObjectPropertyExpression p, int min) {
        return _factory.getOWLObjectMinCardinality(min, p);
    }

    public static OWLObjectMinCardinality min(OWLObjectPropertyExpression p, int min, OWLClassExpression filler) {
        return _factory.getOWLObjectMinCardinality(min, p, filler);
    }

    public static OWLFacetRestriction minExclusive(double constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, constant);
    }

    public static OWLFacetRestriction minExclusive(float constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, constant);
    }

    public static OWLFacetRestriction minExclusive(int constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, constant);
    }

    public static OWLFacetRestriction minExclusive(OWLLiteral constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, constant);
    }

    public static OWLFacetRestriction minInclusive(double constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, constant);
    }

    public static OWLFacetRestriction minInclusive(float constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, constant);
    }

    public static OWLFacetRestriction minInclusive(int constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, constant);
    }

    public static OWLFacetRestriction minInclusive(OWLLiteral constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, constant);
    }

    public static OWLFacetRestriction minLength(int constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MIN_LENGTH, constant);
    }

    public static OWLFacetRestriction minLength(OWLLiteral constant) {
        return _factory.getOWLFacetRestriction(OWLFacet.MIN_LENGTH, constant);
    }

    public static OWLObjectComplementOf not(OWLClassExpression description) {
        return _factory.getOWLObjectComplementOf(description);
    }

    public static OWLDataComplementOf dataNot(OWLDataRange description) {
        return _factory.getOWLDataComplementOf(description);
    }

    public static OWLObjectProperty ObjectProperty(String iri) {
        return _factory.getOWLObjectProperty(IRI.create(iri));
    }

    public static OWLObjectProperty ObjectProperty(IRI iri) {
        return _factory.getOWLObjectProperty(iri);
    }

    public static OWLDataOneOf oneOf(OWLLiteral ... constants) {
        return _factory.getOWLDataOneOf(OWL.set(constants));
    }

    public static OWLObjectOneOf oneOf(OWLIndividual ... individuals) {
        return _factory.getOWLObjectOneOf(OWL.set(individuals));
    }

    public static OWLDataOneOf dataOneOf(Set<? extends OWLLiteral> constants) {
        return _factory.getOWLDataOneOf(constants);
    }

    public static OWLObjectOneOf objectOneOf(Set<OWLIndividual> individuals) {
        return _factory.getOWLObjectOneOf(individuals);
    }

    public static OWLObjectOneOf objectOneOf(Stream<OWLIndividual> individuals) {
        return _factory.getOWLObjectOneOf(individuals);
    }

    public static OWLDataAllValuesFrom only(OWLDataPropertyExpression property, OWLDataRange datatype) {
        return _factory.getOWLDataAllValuesFrom(property, datatype);
    }

    public static OWLObjectAllValuesFrom only(OWLObjectPropertyExpression property, OWLClassExpression description) {
        return _factory.getOWLObjectAllValuesFrom(property, description);
    }

    public static OWLObjectUnionOf or(OWLClassExpression ... descriptions) {
        return _factory.getOWLObjectUnionOf(OWL.set(descriptions));
    }

    public static OWLObjectUnionOf or(Set<? extends OWLClassExpression> descriptions) {
        return _factory.getOWLObjectUnionOf(descriptions);
    }

    public static OWLObjectUnionOf or(Stream<? extends OWLClassExpression> descriptions) {
        return _factory.getOWLObjectUnionOf(descriptions);
    }

    public static OWLDataUnionOf dataOr(OWLDataRange ... descriptions) {
        return _factory.getOWLDataUnionOf(OWL.set(descriptions));
    }

    public static OWLDataUnionOf dataOr(Set<? extends OWLDataRange> descriptions) {
        return _factory.getOWLDataUnionOf(descriptions);
    }

    public static OWLDataUnionOf dataOr(Stream<? extends OWLDataRange> descriptions) {
        return _factory.getOWLDataUnionOf(descriptions);
    }

    public static OWLDataPropertyAssertionAxiom propertyAssertion(OWLIndividual subj, OWLDataPropertyExpression pred, OWLLiteral obj) {
        return _factory.getOWLDataPropertyAssertionAxiom(pred, subj, obj);
    }

    public static OWLObjectPropertyAssertionAxiom propertyAssertion(OWLIndividual subj, OWLObjectPropertyExpression pred, OWLIndividual obj) {
        return _factory.getOWLObjectPropertyAssertionAxiom(pred, subj, obj);
    }

    public static OWLDataPropertyRangeAxiom range(OWLDataPropertyExpression p, OWLDataRange d) {
        return _factory.getOWLDataPropertyRangeAxiom(p, d);
    }

    public static OWLObjectPropertyRangeAxiom range(OWLObjectPropertyExpression p, OWLClassExpression d) {
        return _factory.getOWLObjectPropertyRangeAxiom(p, d);
    }

    public static OWLReflexiveObjectPropertyAxiom reflexive(OWLObjectPropertyExpression p) {
        return _factory.getOWLReflexiveObjectPropertyAxiom(p);
    }

    public static OWLDataRange restrict(OWLDatatype datatype, OWLFacetRestriction ... restrictions) {
        return _factory.getOWLDatatypeRestriction(datatype, restrictions);
    }

    public static OWLDataRange restrict(OWLDatatype datatype, Set<OWLFacetRestriction> restrictions) {
        return _factory.getOWLDatatypeRestriction(datatype, restrictions);
    }

    public static OWLFacetRestriction facetRestriction(OWLFacet facet, OWLLiteral facetValue) {
        return _factory.getOWLFacetRestriction(facet, facetValue);
    }

    public static OWLSameIndividualAxiom sameAs(OWLIndividual i1, OWLIndividual i2) {
        return _factory.getOWLSameIndividualAxiom(OWL.set(i1, i2));
    }

    public static OWLSameIndividualAxiom sameAs(Set<OWLIndividual> inds) {
        return _factory.getOWLSameIndividualAxiom(inds);
    }

    public static OWLObjectHasSelf self(OWLObjectPropertyExpression p) {
        return _factory.getOWLObjectHasSelf(p);
    }

    @SafeVarargs
    private static <T> Set<T> set(T ... elements) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T e : elements) {
            set.add(e);
        }
        return set;
    }

    private static <T> Set<T> set(T e1, T e2) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        set.add(e1);
        set.add(e2);
        return set;
    }

    public static OWLDataSomeValuesFrom some(OWLDataPropertyExpression property, OWLDataRange datatype) {
        return _factory.getOWLDataSomeValuesFrom(property, datatype);
    }

    public static OWLObjectSomeValuesFrom some(OWLObjectPropertyExpression property, OWLClassExpression description) {
        return _factory.getOWLObjectSomeValuesFrom(property, description);
    }

    public static OWLSubClassOfAxiom subClassOf(OWLClassExpression sub, OWLClassExpression sup) {
        return _factory.getOWLSubClassOfAxiom(sub, sup);
    }

    public static OWLSubDataPropertyOfAxiom subPropertyOf(OWLDataPropertyExpression sub, OWLDataPropertyExpression sup) {
        return _factory.getOWLSubDataPropertyOfAxiom(sub, sup);
    }

    public static OWLSubObjectPropertyOfAxiom subPropertyOf(OWLObjectPropertyExpression sub, OWLObjectPropertyExpression sup) {
        return _factory.getOWLSubObjectPropertyOfAxiom(sub, sup);
    }

    public static OWLSubPropertyChainOfAxiom subPropertyOf(OWLObjectPropertyExpression[] subChain, OWLObjectPropertyExpression sup) {
        return _factory.getOWLSubPropertyChainOfAxiom(Arrays.asList(subChain), sup);
    }

    public static OWLSymmetricObjectPropertyAxiom symmetric(OWLObjectPropertyExpression p) {
        return _factory.getOWLSymmetricObjectPropertyAxiom(p);
    }

    public static OWLTransitiveObjectPropertyAxiom transitive(OWLObjectPropertyExpression p) {
        return _factory.getOWLTransitiveObjectPropertyAxiom(p);
    }

    public static OWLDataHasValue value(OWLDataPropertyExpression property, OWLLiteral constant) {
        return _factory.getOWLDataHasValue(property, constant);
    }

    public static OWLObjectHasValue value(OWLObjectPropertyExpression property, OWLIndividual value) {
        return _factory.getOWLObjectHasValue(property, value);
    }

    public static OWLClassExpression and(Set<OWLObjectPropertyExpression> objects, Set<OWLDataPropertyExpression> datas, Set<OWLClassExpression> classes) {
        LinkedHashSet<OWLClassExpression> expr = new LinkedHashSet<OWLClassExpression>(objects.size() + datas.size() + classes.size());
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : objects) {
            expr.add(_factory.getOWLObjectMaxCardinality(1, oWLObjectPropertyExpression));
        }
        for (OWLDataPropertyExpression oWLDataPropertyExpression : datas) {
            expr.add(_factory.getOWLDataMaxCardinality(1, oWLDataPropertyExpression));
        }
        expr.addAll(classes);
        return _factory.getOWLObjectIntersectionOf(expr);
    }

    public static <T> Set<OWLAxiom> schema(Class<T> iface) {
        LinkedHashSet<OWLObjectPropertyExpression> objectMethods = new LinkedHashSet<OWLObjectPropertyExpression>();
        LinkedHashSet<OWLDataPropertyExpression> dataMethods = new LinkedHashSet<OWLDataPropertyExpression>();
        block16: for (Method method : iface.getMethods()) {
            String name;
            if (method.getParameterCount() != 0 || !method.getName().startsWith("get") && !method.getName().startsWith("is") || method.getName().length() <= 3 || method.isVarArgs()) continue;
            switch (name = method.getGenericReturnType().getTypeName()) {
                case "boolean": 
                case "int": 
                case "long": 
                case "float": 
                case "double": 
                case "Boolean": 
                case "Integer": 
                case "Long": 
                case "Float": 
                case "Double": 
                case "String": {
                    dataMethods.add(OWL.DataProperty(IRIUtils.core(iface, method)));
                    continue block16;
                }
                default: {
                    objectMethods.add(OWL.ObjectProperty(IRIUtils.core(iface, method)));
                }
            }
        }
        LinkedHashSet<OWLClassExpression> classes = new LinkedHashSet<OWLClassExpression>();
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (Class<?> clazz : iface.getInterfaces()) {
            classes.add(OWL.Class(IRIUtils.clazz(clazz)));
            result.addAll(OWL.schema(clazz));
        }
        result.add(OWL.subClassOf(OWL.Class(IRIUtils.clazz(iface)), OWL.and(objectMethods, dataMethods, classes)));
        return result;
    }
}

