/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import openllet.atom.OpenError;
import openllet.core.utils.SetUtils;
import openllet.owlapi.OWLException;
import openllet.owlapi.OWLGenericTools;
import openllet.owlapi.OWLGroup;
import openllet.owlapi.OWLHelper;
import openllet.owlapi.OWLManagerGroup;
import openllet.owlapi.parser.OWLFunctionalSyntaxParser;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.io.ToStringRenderer;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AnnotationChange;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.ImportChange;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.util.SimpleRenderer;
import uk.ac.manchester.cs.owl.owlapi.OWLImportsDeclarationImpl;

public class OWLIncrementalFlatFileStorageManagerListener
implements OWLOntologyChangeListener {
    private static final Logger _logger = Log.getLogger(OWLIncrementalFlatFileStorageManagerListener.class);
    public static final int _flushTimeInMinute = 1;
    public static final byte[] _lineSeparator = "\n".getBytes();
    private final File _delta;
    private final File _directory;
    private final ScheduledThreadPoolExecutor _timer = new ScheduledThreadPoolExecutor(1);
    private final Set<OWLOntologyID> _changed = SetUtils.create();
    private final Map<OWLOntologyID, OWLFunctionalSyntaxParser> _parsers = new ConcurrentHashMap<OWLOntologyID, OWLFunctionalSyntaxParser>();
    private final OWLManagerGroup _owlManagerGroup;
    private final Lock _sequential = new ReentrantLock();
    private volatile Optional<OutputStream> _deltaStream = Optional.empty();
    private volatile ScheduledFuture<?> _future;
    private final Runnable _task = () -> {
        try {
            this.flush();
        }
        catch (Exception e) {
            Log.error(_logger, e);
        }
    };

    public OWLIncrementalFlatFileStorageManagerListener(File directory, File log, OWLManagerGroup owlManagerGroup) throws OWLOntologyCreationException {
        this._delta = log;
        this._directory = directory;
        this._owlManagerGroup = owlManagerGroup;
        this._owlManagerGroup.loadDirectory(this._directory);
        this.rebuild();
        this.sync();
        this.flush();
        _logger.info("Starting incremental storage.");
        this._future = this._timer.scheduleAtFixedRate(this._task, 0L, 1L, TimeUnit.MINUTES);
    }

    public String ontology2filename(OWLOntology ontology) {
        return OWLHelper.ontology2filename(this._directory, ontology);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ArrayList<OWLOntologyID> changed;
        Set<OWLOntologyID> set = this._changed;
        synchronized (set) {
            changed = new ArrayList<OWLOntologyID>(this._changed);
            this._changed.clear();
        }
        OWLOntologyManager manager = this._owlManagerGroup.getPersistentManager();
        ((Stream)manager.ontologies().parallel()).filter(ontology -> ontology.getOntologyID().getOntologyIRI().isPresent()).filter(ontology -> changed.contains(ontology.getOntologyID())).filter(ontology -> !ontology.isAnonymous()).forEach(ontology -> {
            _logger.info("Saving " + ontology.getOntologyID());
            String filenameOld = this.ontology2filename((OWLOntology)ontology);
            String filenamePart = filenameOld + ".part";
            boolean firstPhaseOk = false;
            try (FileOutputStream stream = new FileOutputStream(filenamePart);){
                manager.saveOntology((OWLOntology)ontology, OWLHelper._format, stream);
                firstPhaseOk = true;
            }
            catch (Exception e) {
                Log.error(_logger, "Crash when saving " + ontology.getOntologyID(), e);
            }
            if (firstPhaseOk) {
                File old = new File(filenameOld);
                if (!old.exists() || old.delete()) {
                    new File(filenamePart).renameTo(old);
                } else {
                    _logger.severe("Can't commit change of " + ontology.getOntologyID());
                }
            }
        });
        _logger.fine("flush done");
        this.releaseDeltaStream();
    }

    private void releaseDeltaStream() {
        try {
            this._sequential.lock();
            this._delta.delete();
            if (this._deltaStream.isPresent()) {
                this._deltaStream.get().close();
                this._deltaStream = Optional.empty();
            }
        }
        catch (Exception e) {
            Log.error(_logger, e);
        }
        finally {
            this._sequential.unlock();
        }
    }

    private static byte[] bytesOfOntologyId(OWLOntologyID ontologyID) {
        if (ontologyID.getVersionIRI().isPresent()) {
            return (ontologyID.getOntologyIRI().get() + " " + ontologyID.getVersionIRI().get()).getBytes();
        }
        return ontologyID.getOntologyIRI().get().toString().getBytes();
    }

    private static void writeOntologyId(OutputStream stream, OWLOntologyID ontologyID) throws IOException {
        stream.write(OWLIncrementalFlatFileStorageManagerListener.bytesOfOntologyId(ontologyID));
    }

    private static OWLOntologyID parseOntologyId(String ontologyId) {
        String[] parts = ontologyId.split(" ");
        if (parts.length == 2) {
            return new OWLOntologyID(IRI.create(parts[0]), IRI.create(parts[1]));
        }
        if (parts.length == 1) {
            return new OWLOntologyID(IRI.create(ontologyId));
        }
        _logger.log(Level.SEVERE, "Malformed OntologyID " + ontologyId);
        return null;
    }

    private static byte[] bytesOfChange(OWLOntologyChange change) {
        if (change instanceof OWLAxiomChange) {
            ToStringRenderer.setRenderer(SimpleRenderer::new);
            return ToStringRenderer.getInstance().render(change.getAxiom()).getBytes();
        }
        if (change instanceof AnnotationChange) {
            return ToStringRenderer.getInstance().render(((AnnotationChange)change).getAnnotation()).getBytes();
        }
        if (change instanceof ImportChange) {
            return ((ImportChange)change).getImportDeclaration().getIRI().toString().getBytes();
        }
        if (change instanceof SetOntologyID) {
            return OWLIncrementalFlatFileStorageManagerListener.bytesOfOntologyId(((SetOntologyID)change).getNewOntologyID());
        }
        _logger.severe("No bytes available for " + change);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
        ArrayList<? extends OWLOntologyChange> copyOfChanges = new ArrayList<OWLOntologyChange>(changes);
        try {
            try {
                this._sequential.lock();
                if (!this._deltaStream.isPresent()) {
                    this._deltaStream = Optional.of(new FileOutputStream(this._delta, true));
                }
            }
            finally {
                this._sequential.unlock();
            }
            OutputStream stream = this._deltaStream.orElseThrow(() -> new OpenError("Can't open write stream to " + this._delta));
            for (OWLOntologyChange oWLOntologyChange : copyOfChanges) {
                byte[] bytes = OWLIncrementalFlatFileStorageManagerListener.bytesOfChange(oWLOntologyChange);
                if (bytes == null) continue;
                OWLOntologyID ontologyId = oWLOntologyChange.getOntology().getOntologyID();
                stream.write(oWLOntologyChange.getClass().getSimpleName().getBytes());
                stream.write(_lineSeparator);
                OWLIncrementalFlatFileStorageManagerListener.writeOntologyId(stream, ontologyId);
                stream.write(_lineSeparator);
                stream.write(Base64.getEncoder().encode(bytes));
                stream.write(_lineSeparator);
                Set<OWLOntologyID> set = this._changed;
                synchronized (set) {
                    this._changed.add(ontologyId);
                }
            }
            stream.flush();
        }
        catch (Exception e1) {
            Log.error(_logger, e1);
            this.releaseDeltaStream();
        }
    }

    private void rebuild() throws OWLOntologyCreationException {
        if (this._delta.exists()) {
            for (String sIri : new Builder().scan()) {
                if (sIri == null || sIri.equals("")) continue;
                String[] parts = sIri.split(" ");
                OWLOntologyID ontId = parts.length == 2 ? new OWLOntologyID(IRI.create(parts[0]), IRI.create(parts[1])) : new OWLOntologyID(IRI.create(sIri));
                OWLGenericTools tools = new OWLGenericTools((OWLGroup)this._owlManagerGroup, ontId, false);
                _logger.info(tools.getOntology().getOntologyID() + " have been load.");
                this._changed.add(ontId);
            }
        }
    }

    private void sync() {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        if (this._delta.exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(this._delta));
                 DeltaReader reader = new DeltaReader(br);){
                while (reader.hasNext()) {
                    changes.add(reader.next());
                }
            }
            catch (Exception e) {
                Log.error(_logger, e);
            }
        }
    }

    public void close() {
        try {
            this.flush();
        }
        catch (Exception exception) {
            Log.error(_logger, exception);
        }
        try {
            this._future.cancel(true);
            _logger.log(Level.INFO, "The task that save ontologies have been removed.");
        }
        catch (Exception exception) {
            Log.warning(_logger, exception);
        }
        try {
            this._timer.purge();
            this._timer.shutdown();
        }
        catch (Exception exception) {
            Log.warning(_logger, exception);
        }
    }

    static /* synthetic */ File access$400(OWLIncrementalFlatFileStorageManagerListener x0) {
        return x0._delta;
    }

    private class Builder {
        private Builder() {
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Set<String> scan() {
            block20: {
                result = new HashSet<String>();
                line = 0;
                try {
                    in = new BufferedReader(new FileReader(OWLIncrementalFlatFileStorageManagerListener.access$400(OWLIncrementalFlatFileStorageManagerListener.this)));
                    var4_5 = null;
                    ** try [egrp 1[TRYBLOCK] [3, 4 : 35->103)] { 
lbl7:
                    // 1 sources

                    break block20;
lbl8:
                    // 1 sources

                    catch (Throwable var5_8) {
                        var4_5 = var5_8;
                        throw var5_8;
                    }
                }
                catch (Exception e) {
                    Log.error(OWLIncrementalFlatFileStorageManagerListener.access$200(), e);
                }
                return result;
            }
            while (in.ready() != false) {
                try {
                    in.readLine();
                    result.add(in.readLine());
                    in.readLine();
                    ++line;
                }
                catch (Exception e) {
                    Log.error(OWLIncrementalFlatFileStorageManagerListener.access$200(), "Malformed File near " + line * 3, e);
                    var6_9 = null;
                    if (in == null) return var6_9;
                    if (var4_5 != null) {
                        try {
                            in.close();
                            return var6_9;
                        }
                        catch (Throwable var7_10) {
                            var4_5.addSuppressed(var7_10);
                            return var6_9;
                        }
                    }
                    in.close();
                    return var6_9;
                }
            }
            return result;
lbl39:
            // 1 sources

            finally {
                if (in != null) {
                    if (var4_5 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable var5_7) {
                            var4_5.addSuppressed(var5_7);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
    }

    private class DeltaReader
    extends Reader
    implements Iterator<OWLOntologyChange> {
        private final OWLOntologyManager _manager;
        private final BufferedReader _in;
        private volatile char[] _data;
        private volatile int _localOffset;
        private volatile int _line;

        public DeltaReader(BufferedReader in) {
            this._manager = OWLIncrementalFlatFileStorageManagerListener.this._owlManagerGroup.getPersistentManager();
            this._localOffset = 0;
            this._line = 0;
            this._in = in;
        }

        public OWLFunctionalSyntaxParser getParser(OWLOntologyID ontId) {
            OWLFunctionalSyntaxParser parser = (OWLFunctionalSyntaxParser)OWLIncrementalFlatFileStorageManagerListener.this._parsers.get(ontId);
            if (parser == null) {
                parser = new OWLFunctionalSyntaxParser(this);
                OWLOntology ontology = this._manager.getOntology(ontId);
                if (ontology == null) {
                    try {
                        _logger.info("Creation of " + ontId.getOntologyIRI());
                        ontology = new OWLGenericTools((OWLGroup)OWLIncrementalFlatFileStorageManagerListener.this._owlManagerGroup, ontId, false).getOntology();
                    }
                    catch (OWLOntologyCreationException exception) {
                        throw new OWLException("Ontology id lead to non existant ontology : " + ontId + ". And we can't create it.", exception);
                    }
                }
                parser.setUp(ontology, new OWLOntologyLoaderConfiguration());
                OWLIncrementalFlatFileStorageManagerListener.this._parsers.put(ontId, parser);
            }
            return parser;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int wrote;
            if (this._data == null) {
                return 0;
            }
            int i = this._localOffset;
            int j = off;
            for (wrote = 0; j < cbuf.length && wrote < len && i < this._data.length; ++i, ++j, ++wrote) {
                cbuf[j] = this._data[i];
            }
            this._localOffset = i;
            return wrote;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean hasNext() {
            try {
                return this._in.ready();
            }
            catch (IOException e) {
                Log.error(_logger, e);
                return false;
            }
        }

        private OWLAxiom parseAxiom(OWLOntologyID ontId, String axiomStr) {
            this._data = axiomStr.toCharArray();
            this._localOffset = 0;
            try {
                return this.getParser(ontId).Axiom();
            }
            catch (OWLException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new OWLException("Malformed File near " + this._line * 3 + " on " + axiomStr, exception);
            }
        }

        private OWLAnnotation getAnnotation(OWLOntologyID ontId, String data) {
            OWLAxiom axiom = this.parseAxiom(ontId, data);
            if (axiom instanceof OWLAnnotationAxiom) {
                OWLAnnotationAxiom aa = (OWLAnnotationAxiom)axiom;
                return aa.annotations().findAny().orElseThrow(() -> new OWLException("Invalid annotation axiom : " + data));
            }
            throw new OWLException("Invalid annotation near " + this._line * 3 + "(line " + this._line + ") on axiom : " + data);
        }

        @Override
        public OWLOntologyChange next() {
            OWLOntologyChange change;
            String data;
            String ontologyId;
            String kind;
            try {
                kind = this._in.readLine();
                ontologyId = this._in.readLine();
                data = this._in.readLine();
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "Malformed File near " + this._line * 3, e);
                return null;
            }
            data = new String(Base64.getDecoder().decode(data));
            OWLOntologyID ontId = OWLIncrementalFlatFileStorageManagerListener.parseOntologyId(ontologyId);
            OWLOntology ontology = this._manager.getOntology(ontId);
            switch (kind) {
                case "SetOntologyID": {
                    change = new SetOntologyID(ontology, OWLIncrementalFlatFileStorageManagerListener.parseOntologyId(data));
                    break;
                }
                case "AddOntologyAnnotation": {
                    change = new AddOntologyAnnotation(ontology, this.getAnnotation(ontId, data));
                    break;
                }
                case "RemoveOntologyAnnotation": {
                    change = new RemoveOntologyAnnotation(ontology, this.getAnnotation(ontId, data));
                    break;
                }
                case "AddImport": {
                    change = new AddImport(ontology, new OWLImportsDeclarationImpl(IRI.create(new String(data))));
                    break;
                }
                case "RemoveImport": {
                    change = new RemoveImport(ontology, new OWLImportsDeclarationImpl(IRI.create(new String(data))));
                    break;
                }
                case "AddAxiom": {
                    change = new AddAxiom(ontology, this.parseAxiom(ontId, data));
                    break;
                }
                case "RemoveAxiom": {
                    change = new RemoveAxiom(ontology, this.parseAxiom(ontId, data));
                    break;
                }
                default: {
                    throw new OWLException("Don't know what to do with change kind " + kind);
                }
            }
            ++this._line;
            return change;
        }
    }
}

