/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.engine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.exceptions.UnsupportedQueryException;
import openllet.core.utils.ATermUtils;
import openllet.query.sparqldl.engine.QueryCost;
import openllet.query.sparqldl.engine.QueryPlan;
import openllet.query.sparqldl.engine.QuerySizeEstimator;
import openllet.query.sparqldl.model.Query;
import openllet.query.sparqldl.model.QueryAtom;
import openllet.query.sparqldl.model.QueryPredicate;
import openllet.query.sparqldl.model.ResultBinding;
import openllet.shared.tools.Log;

public class CostBasedQueryPlanNew
extends QueryPlan {
    private static final Logger _logger = Log.getLogger(CostBasedQueryPlanNew.class);
    private List<QueryAtom> _sortedAtoms;
    private int _index;
    private int _size;
    private QueryCost _cost;

    public CostBasedQueryPlanNew(Query query) {
        super(query);
        QuerySizeEstimator.computeSizeEstimate(query);
        this._index = 0;
        this._size = query.getAtoms().size();
        this._cost = new QueryCost(query.getKB());
        this._sortedAtoms = null;
        if (this._size == 0) {
            return;
        }
        if (this._size == 1) {
            this._sortedAtoms = query.getAtoms();
        } else {
            double minCost = this.chooseOrdering(new ArrayList<QueryAtom>(query.getAtoms()), new ArrayList<QueryAtom>(this._size), new HashSet<ATermAppl>(), false, Double.POSITIVE_INFINITY);
            if (this._sortedAtoms == null) {
                throw new UnsupportedQueryException("No safe ordering for query: " + query);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "WINNER : Cost=" + minCost + " ,atoms=" + this._sortedAtoms);
            }
        }
    }

    private double chooseOrdering(List<QueryAtom> atoms, List<QueryAtom> orderedAtoms, Set<ATermAppl> boundVars, boolean notOptimal, double minCostParam) {
        double minCost = minCostParam;
        if (atoms.isEmpty()) {
            if (notOptimal) {
                if (this._sortedAtoms == null) {
                    this._sortedAtoms = new ArrayList<QueryAtom>(orderedAtoms);
                }
            } else {
                double queryCost = this._cost.estimate(orderedAtoms);
                _logger.fine("Cost " + queryCost + " for " + orderedAtoms);
                if (queryCost < minCost) {
                    this._sortedAtoms = new ArrayList<QueryAtom>(orderedAtoms);
                    minCost = queryCost;
                }
            }
            return minCost;
        }
        block0: for (int i = 0; i < atoms.size(); ++i) {
            QueryAtom atom = atoms.get(i);
            boolean newNonOptimal = notOptimal;
            HashSet<ATermAppl> newBoundVars = new HashSet<ATermAppl>(boundVars);
            if (!atom.isGround()) {
                int boundCount = 0;
                int unboundCount = 0;
                for (ATermAppl a : atom.getArguments()) {
                    if (!ATermUtils.isVar(a)) continue;
                    if (newBoundVars.add(a)) {
                        ++unboundCount;
                        if (!atom.getPredicate().equals((Object)QueryPredicate.NotKnown)) continue;
                        for (int j = 0; j < atoms.size(); ++j) {
                            QueryAtom nextAtom = atoms.get(j);
                            if (i == j || nextAtom.getPredicate().equals((Object)QueryPredicate.NotKnown) || !nextAtom.getArguments().contains(a)) continue;
                            if (!_logger.isLoggable(Level.FINE)) continue block0;
                            _logger.fine("Unbound vars for not");
                            continue block0;
                        }
                        continue;
                    }
                    ++boundCount;
                }
                if (boundCount == 0 && newBoundVars.size() > unboundCount) {
                    if (this._sortedAtoms != null) {
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.fine("Stop at not optimal ordering");
                        continue;
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("Continue not optimal ordering, no solution yet.");
                    }
                    newNonOptimal = true;
                }
            }
            atoms.remove(atom);
            orderedAtoms.add(atom);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Atom[" + i + "/" + atoms.size() + "] " + atom + " from " + atoms + " to " + orderedAtoms);
            }
            minCost = this.chooseOrdering(atoms, orderedAtoms, newBoundVars, newNonOptimal, minCost);
            atoms.add(i, atom);
            orderedAtoms.remove(orderedAtoms.size() - 1);
        }
        return minCost;
    }

    @Override
    public QueryAtom next(ResultBinding binding) {
        return this._sortedAtoms.get(this._index++).apply(binding);
    }

    @Override
    public boolean hasNext() {
        return this._index < this._size;
    }

    @Override
    public void back() {
        --this._index;
    }

    @Override
    public void reset() {
        this._index = 0;
    }
}

