/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.exceptions.UnsupportedFeatureException;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.KBOperation;
import openllet.core.utils.SizeEstimate;
import openllet.query.sparqldl.engine.QueryEngine;
import openllet.query.sparqldl.model.Core;
import openllet.query.sparqldl.model.NotKnownQueryAtom;
import openllet.query.sparqldl.model.QueryAtom;
import openllet.query.sparqldl.model.UnionQueryAtom;

public class QueryCost {
    private double _staticCost;
    private double _branchCount;
    private final KnowledgeBase _kb;
    private final SizeEstimate _estimate;

    public QueryCost(KnowledgeBase kb) {
        this._kb = kb;
        this._estimate = kb.getSizeEstimate();
    }

    public double estimate(List<QueryAtom> atoms) {
        return this.estimate(atoms, new HashSet<ATermAppl>());
    }

    public double estimate(List<QueryAtom> atoms, Collection<ATermAppl> bound) {
        QueryAtom atom;
        int i;
        double totalStaticCount = 1.0;
        double totalBranchCount = 1.0;
        this._branchCount = 1.0;
        this._staticCost = 1.0;
        int n = atoms.size();
        HashSet<ATermAppl> lastBound = new HashSet<ATermAppl>(bound);
        ArrayList<HashSet<ATermAppl>> boundList = new ArrayList<HashSet<ATermAppl>>(n);
        for (i = 0; i < n; ++i) {
            atom = atoms.get(i);
            boundList.add(lastBound);
            lastBound = new HashSet<ATermAppl>(lastBound);
            lastBound.addAll(atom.getArguments());
        }
        for (i = n - 1; i >= 0; --i) {
            atom = atoms.get(i);
            this.estimate(atom, (Collection<ATermAppl>)((Collection)boundList.get(i)));
            totalBranchCount *= this._branchCount;
            totalStaticCount = this._staticCost + this._branchCount * totalStaticCount;
        }
        this._staticCost = totalStaticCount;
        this._branchCount = totalBranchCount;
        return this._staticCost;
    }

    public double estimate(QueryAtom atom) {
        return this.estimate(atom, new HashSet<ATermAppl>());
    }

    public double estimate(QueryAtom atom, Collection<ATermAppl> bound) {
        boolean direct = false;
        boolean strict = false;
        List<ATermAppl> arguments = atom.getArguments();
        for (ATermAppl a : arguments) {
            if (!this.isConstant(a)) continue;
            bound.add(a);
        }
        block0 : switch (atom.getPredicate()) {
            case DirectType: {
                direct = true;
            }
            case Type: {
                ATermAppl instance = arguments.get(0);
                ATermAppl clazz = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this._staticCost = direct ? (double)this._estimate.getCost(KBOperation.IS_DIRECT_TYPE) : (double)this._estimate.getCost(KBOperation.IS_TYPE);
                    this._branchCount = 1.0;
                    break;
                }
                if (bound.contains(clazz)) {
                    this._staticCost = direct ? (double)this._estimate.getCost(KBOperation.GET_DIRECT_INSTANCES) : (double)this._estimate.getCost(KBOperation.GET_INSTANCES);
                    this._branchCount = this.isConstant(clazz) ? (double)this._estimate.size(clazz) : this._estimate.avgInstancesPerClass(direct);
                    break;
                }
                if (bound.contains(instance)) {
                    this._staticCost = this._estimate.getCost(KBOperation.GET_TYPES);
                    this._branchCount = this.isConstant(instance) ? (double)this._estimate.classesPerInstance(instance, direct) : this._estimate.avgClassesPerInstance(direct);
                    break;
                }
                this._staticCost = (long)this._estimate.getClassCount() * (direct ? this._estimate.getCost(KBOperation.GET_DIRECT_INSTANCES) : this._estimate.getCost(KBOperation.GET_INSTANCES));
                this._branchCount = (double)this._estimate.getClassCount() * this._estimate.avgInstancesPerClass(direct);
                break;
            }
            case Annotation: 
            case PropertyValue: {
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.HAS_PROPERTY_VALUE);
                    this._branchCount = 1.0;
                    break;
                }
                ATermAppl subject = arguments.get(0);
                ATermAppl predicate = arguments.get(1);
                ATermAppl object = arguments.get(2);
                if (bound.contains(predicate)) {
                    if (bound.contains(subject)) {
                        this._staticCost = this._estimate.getCost(KBOperation.GET_PROPERTY_VALUE);
                        this._branchCount = this.isConstant(predicate) ? this._estimate.avg(predicate) : this._estimate.avgSubjectsPerProperty();
                        break;
                    }
                    if (bound.contains(object)) {
                        this._staticCost = this._estimate.getCost(KBOperation.GET_PROPERTY_VALUE);
                        if (this.isConstant(predicate)) {
                            if (this._kb.isObjectProperty(predicate)) {
                                this._branchCount = this._estimate.avg(this.inv(predicate));
                                break;
                            }
                            this._branchCount = this._estimate.avgSubjectsPerProperty();
                            break;
                        }
                        this._branchCount = this._estimate.avgSubjectsPerProperty();
                        break;
                    }
                    this._staticCost = (double)this._estimate.getCost(KBOperation.GET_PROPERTY_VALUE) + (this.isConstant(predicate) ? this._estimate.avg(predicate) : this._estimate.avgSubjectsPerProperty()) * (double)this._estimate.getCost(KBOperation.GET_PROPERTY_VALUE);
                    this._branchCount = this.isConstant(predicate) ? (double)this._estimate.size(predicate) : this._estimate.avgPairsPerProperty();
                    break;
                }
                if (bound.contains(subject) || bound.contains(object)) {
                    this._staticCost = (long)this._estimate.getPropertyCount() * this._estimate.getCost(KBOperation.GET_PROPERTY_VALUE);
                    this._branchCount = (double)this._estimate.getPropertyCount() * this._estimate.avgSubjectsPerProperty();
                    break;
                }
                this._staticCost = (double)this._estimate.getPropertyCount() * ((double)this._estimate.getCost(KBOperation.GET_PROPERTY_VALUE) + this._estimate.avgSubjectsPerProperty() * (double)this._estimate.getCost(KBOperation.GET_PROPERTY_VALUE));
                this._branchCount = this._estimate.avgPairsPerProperty() * (double)this._estimate.getPropertyCount();
                break;
            }
            case SameAs: {
                ATermAppl saLHS = arguments.get(0);
                ATermAppl saRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_SAME_AS);
                    this._branchCount = 1.0;
                    break;
                }
                if (bound.contains(saLHS) || bound.contains(saRHS)) {
                    this._staticCost = this._estimate.getCost(KBOperation.GET_SAMES);
                    if (bound.contains(saLHS)) {
                        this._branchCount = this.isConstant(saLHS) ? this._estimate.sames(saLHS) : this._estimate.avgSamesPerInstance();
                        break;
                    }
                    this._branchCount = this.isConstant(saRHS) ? this._estimate.sames(saRHS) : this._estimate.avgSamesPerInstance();
                    break;
                }
                this._staticCost = (long)this._estimate.getInstanceCount() * this._estimate.getCost(KBOperation.GET_SAMES);
                this._branchCount = (double)this._estimate.getInstanceCount() * this._estimate.avgSamesPerInstance();
                break;
            }
            case DifferentFrom: {
                ATermAppl dfLHS = arguments.get(0);
                ATermAppl dfRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_DIFFERENT_FROM);
                    this._branchCount = 1.0;
                    break;
                }
                if (bound.contains(dfLHS) || bound.contains(dfRHS)) {
                    this._staticCost = this._estimate.getCost(KBOperation.GET_DIFFERENTS);
                    if (bound.contains(dfLHS)) {
                        this._branchCount = this.isConstant(dfLHS) ? this._estimate.differents(dfLHS) : this._estimate.avgDifferentsPerInstance();
                        break;
                    }
                    this._branchCount = this.isConstant(dfRHS) ? this._estimate.differents(dfRHS) : this._estimate.avgDifferentsPerInstance();
                    break;
                }
                this._staticCost = (long)this._estimate.getInstanceCount() * this._estimate.getCost(KBOperation.GET_DIFFERENTS);
                this._branchCount = (double)this._estimate.getInstanceCount() * this._estimate.avgDifferentsPerInstance();
                break;
            }
            case DirectSubClassOf: {
                direct = true;
            }
            case StrictSubClassOf: {
                strict = true;
            }
            case SubClassOf: {
                ATermAppl clazzLHS = arguments.get(0);
                ATermAppl clazzRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this._staticCost = strict ? (direct ? (double)this._estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERCLASSES) : (double)(this._estimate.getCost(KBOperation.IS_SUBCLASS_OF) + this._estimate.getCost(KBOperation.GET_EQUIVALENT_CLASSES))) : (double)this._estimate.getCost(KBOperation.IS_SUBCLASS_OF);
                    this._branchCount = 1.0;
                    break;
                }
                if (bound.contains(clazzLHS) || bound.contains(clazzRHS)) {
                    if (strict && !direct) {
                        this._staticCost = this._estimate.getCost(KBOperation.GET_SUB_OR_SUPERCLASSES) + this._estimate.getCost(KBOperation.GET_EQUIVALENT_CLASSES);
                    } else {
                        double d = this._staticCost = direct ? (double)this._estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERCLASSES) : (double)this._estimate.getCost(KBOperation.GET_SUB_OR_SUPERCLASSES);
                    }
                    if (bound.contains(clazzLHS)) {
                        double d = this._branchCount = this.isConstant(clazzLHS) ? this._estimate.superClasses(clazzLHS, direct) : this._estimate.avgSuperClasses(direct);
                        if (!strict) break;
                        this._branchCount -= this.isConstant(clazzLHS) ? this._estimate.equivClasses(clazzLHS) : this._estimate.avgEquivClasses();
                        this._branchCount = Math.max(this._branchCount, 0.0);
                        break;
                    }
                    double d = this._branchCount = this.isConstant(clazzRHS) ? this._estimate.superClasses(clazzRHS, direct) : this._estimate.avgSuperClasses(direct);
                    if (!strict) break;
                    this._branchCount -= this.isConstant(clazzRHS) ? this._estimate.equivClasses(clazzRHS) : this._estimate.avgEquivClasses();
                    this._branchCount = Math.max(this._branchCount, 0.0);
                    break;
                }
                this._staticCost = strict && !direct ? (double)(this._estimate.getCost(KBOperation.GET_SUB_OR_SUPERCLASSES) + this._estimate.getCost(KBOperation.GET_EQUIVALENT_CLASSES)) : (direct ? (double)this._estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERCLASSES) : (double)this._estimate.getCost(KBOperation.GET_SUB_OR_SUPERCLASSES));
                this._staticCost *= (double)this._estimate.getClassCount();
                this._branchCount = (double)this._estimate.getClassCount() * this._estimate.avgSubClasses(direct);
                if (!strict) break;
                this._branchCount -= this._estimate.avgEquivClasses();
                this._branchCount = Math.max(this._branchCount, 0.0);
                break;
            }
            case EquivalentClass: {
                ATermAppl eqcLHS = arguments.get(0);
                ATermAppl eqcRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_EQUIVALENT_CLASS);
                    this._branchCount = 1.0;
                    break;
                }
                if (bound.contains(eqcLHS) || bound.contains(eqcRHS)) {
                    this._staticCost = this._estimate.getCost(KBOperation.GET_EQUIVALENT_CLASSES);
                    if (bound.contains(eqcLHS)) {
                        this._branchCount = this.isConstant(eqcLHS) ? this._estimate.equivClasses(eqcLHS) : this._estimate.avgEquivClasses();
                        break;
                    }
                    this._branchCount = this.isConstant(eqcRHS) ? this._estimate.equivClasses(eqcRHS) : this._estimate.avgEquivClasses();
                    break;
                }
                this._staticCost = (long)this._estimate.getClassCount() * this._estimate.getCost(KBOperation.GET_EQUIVALENT_CLASSES);
                this._branchCount = (double)this._estimate.getClassCount() * this._estimate.avgEquivClasses();
                break;
            }
            case DisjointWith: {
                ATermAppl dwLHS = arguments.get(0);
                ATermAppl dwRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_DISJOINT_WITH);
                    this._branchCount = 1.0;
                    break;
                }
                if (bound.contains(dwLHS) || bound.contains(dwRHS)) {
                    this._staticCost = this._estimate.getCost(KBOperation.GET_DISJOINT_CLASSES);
                    if (bound.contains(dwLHS)) {
                        this._branchCount = this.isConstant(dwLHS) ? this._estimate.disjoints(dwLHS) : this._estimate.avgDisjointClasses();
                        break;
                    }
                    this._branchCount = this.isConstant(dwRHS) ? this._estimate.disjoints(dwRHS) : this._estimate.avgDisjointClasses();
                    break;
                }
                this._staticCost = (long)this._estimate.getClassCount() * this._estimate.getCost(KBOperation.GET_DISJOINT_CLASSES);
                this._branchCount = (double)this._estimate.getClassCount() * this._estimate.avgDisjointClasses();
                break;
            }
            case ComplementOf: {
                ATermAppl coLHS = arguments.get(0);
                ATermAppl coRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_COMPLEMENT_OF);
                    this._branchCount = 1.0;
                    break;
                }
                if (bound.contains(coLHS) || bound.contains(coRHS)) {
                    this._staticCost = this._estimate.getCost(KBOperation.GET_COMPLEMENT_CLASSES);
                    if (bound.contains(coLHS)) {
                        this._branchCount = this.isConstant(coLHS) ? this._estimate.complements(coLHS) : this._estimate.avgComplementClasses();
                        break;
                    }
                    this._branchCount = this.isConstant(coRHS) ? this._estimate.complements(coRHS) : this._estimate.avgComplementClasses();
                    break;
                }
                this._staticCost = (long)this._estimate.getClassCount() * this._estimate.getCost(KBOperation.GET_COMPLEMENT_CLASSES);
                this._branchCount = (double)this._estimate.getClassCount() * this._estimate.avgComplementClasses();
                break;
            }
            case DirectSubPropertyOf: {
                direct = true;
            }
            case StrictSubPropertyOf: {
                strict = true;
            }
            case SubPropertyOf: {
                ATermAppl spLHS = arguments.get(0);
                ATermAppl spRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this._staticCost = strict ? (direct ? (double)this._estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERPROPERTIES) : (double)(this._estimate.getCost(KBOperation.IS_SUBPROPERTY_OF) + this._estimate.getCost(KBOperation.GET_EQUIVALENT_PROPERTIES))) : (double)this._estimate.getCost(KBOperation.IS_SUBPROPERTY_OF);
                    this._branchCount = 1.0;
                    break;
                }
                if (bound.contains(spLHS) || bound.contains(spRHS)) {
                    if (strict && !direct) {
                        this._staticCost = this._estimate.getCost(KBOperation.GET_SUB_OR_SUPERPROPERTIES) + this._estimate.getCost(KBOperation.GET_EQUIVALENT_PROPERTIES);
                    } else {
                        double d = this._staticCost = direct ? (double)this._estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERPROPERTIES) : (double)this._estimate.getCost(KBOperation.GET_SUB_OR_SUPERPROPERTIES);
                    }
                    if (bound.contains(spLHS)) {
                        double d = this._branchCount = this.isConstant(spLHS) ? this._estimate.superProperties(spLHS, direct) : this._estimate.avgSuperProperties(direct);
                        if (!strict) break;
                        this._branchCount -= this.isConstant(spLHS) ? this._estimate.equivProperties(spLHS) : this._estimate.avgEquivProperties();
                        this._branchCount = Math.max(this._branchCount, 0.0);
                        break;
                    }
                    double d = this._branchCount = this.isConstant(spRHS) ? this._estimate.superProperties(spRHS, direct) : this._estimate.avgSuperProperties(direct);
                    if (!strict) break;
                    this._branchCount -= this.isConstant(spRHS) ? this._estimate.equivProperties(spRHS) : this._estimate.avgEquivProperties();
                    this._branchCount = Math.max(this._branchCount, 0.0);
                    break;
                }
                this._staticCost = strict && !direct ? (double)(this._estimate.getCost(KBOperation.GET_SUB_OR_SUPERPROPERTIES) + this._estimate.getCost(KBOperation.GET_EQUIVALENT_PROPERTIES)) : (direct ? (double)this._estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERPROPERTIES) : (double)this._estimate.getCost(KBOperation.GET_SUB_OR_SUPERPROPERTIES));
                this._staticCost *= (double)this._estimate.getPropertyCount();
                this._branchCount = (double)this._estimate.getPropertyCount() * this._estimate.avgSubProperties(direct);
                if (!strict) break;
                this._branchCount -= this._estimate.avgEquivProperties();
                this._branchCount = Math.max(this._branchCount, 0.0);
                break;
            }
            case EquivalentProperty: {
                ATermAppl eqpLHS = arguments.get(0);
                ATermAppl eqpRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_EQUIVALENT_PROPERTY);
                    this._branchCount = 1.0;
                    break;
                }
                if (bound.contains(eqpLHS) || bound.contains(eqpRHS)) {
                    this._staticCost = this._estimate.getCost(KBOperation.GET_EQUIVALENT_PROPERTIES);
                    if (bound.contains(eqpLHS)) {
                        this._branchCount = this.isConstant(eqpLHS) ? this._estimate.equivProperties(eqpLHS) : this._estimate.avgEquivProperties();
                        break;
                    }
                    this._branchCount = this.isConstant(eqpRHS) ? this._estimate.equivProperties(eqpRHS) : this._estimate.avgEquivProperties();
                    break;
                }
                this._staticCost = (long)this._estimate.getPropertyCount() * this._estimate.getCost(KBOperation.GET_EQUIVALENT_PROPERTIES);
                this._branchCount = (double)this._estimate.getPropertyCount() * this._estimate.avgEquivProperties();
                break;
            }
            case Domain: {
                ATermAppl domLHS = arguments.get(0);
                ATermAppl domRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_DOMAIN);
                    this._branchCount = 1.0;
                    break;
                }
                if (bound.contains(domLHS) || bound.contains(domRHS)) {
                    this._staticCost = this._estimate.getCost(KBOperation.GET_DOMAINS);
                    if (bound.contains(domLHS)) {
                        this._branchCount = this.isConstant(domLHS) ? this._estimate.equivProperties(domLHS) : this._estimate.avgEquivProperties();
                        break;
                    }
                    this._branchCount = this.isConstant(domRHS) ? this._estimate.equivClasses(domRHS) : this._estimate.avgEquivClasses();
                    break;
                }
                this._staticCost = (long)this._estimate.getPropertyCount() * this._estimate.getCost(KBOperation.GET_DOMAINS);
                this._branchCount = (double)this._estimate.getPropertyCount() * this._estimate.avgEquivProperties();
                break;
            }
            case Range: {
                ATermAppl rangeLHS = arguments.get(0);
                ATermAppl rangeRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_RANGE);
                    this._branchCount = 1.0;
                    break;
                }
                if (bound.contains(rangeLHS) || bound.contains(rangeRHS)) {
                    this._staticCost = this._estimate.getCost(KBOperation.GET_RANGES);
                    if (bound.contains(rangeLHS)) {
                        this._branchCount = this.isConstant(rangeLHS) ? this._estimate.equivProperties(rangeLHS) : this._estimate.avgEquivProperties();
                        break;
                    }
                    this._branchCount = this.isConstant(rangeRHS) ? this._estimate.equivClasses(rangeRHS) : this._estimate.avgEquivClasses();
                    break;
                }
                this._staticCost = (long)this._estimate.getPropertyCount() * this._estimate.getCost(KBOperation.GET_RANGES);
                this._branchCount = (double)this._estimate.getPropertyCount() * this._estimate.avgEquivProperties();
                break;
            }
            case InverseOf: {
                ATermAppl ioLHS = arguments.get(0);
                ATermAppl ioRHS = arguments.get(1);
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_INVERSE_OF);
                    this._branchCount = 1.0;
                    break;
                }
                if (bound.contains(ioLHS) || bound.contains(ioRHS)) {
                    this._staticCost = this._estimate.getCost(KBOperation.GET_INVERSES);
                    if (bound.contains(ioLHS)) {
                        this._branchCount = this.isConstant(ioLHS) ? this._estimate.inverses(ioLHS) : this._estimate.avgInverseProperties();
                        break;
                    }
                    this._branchCount = this.isConstant(ioRHS) ? this._estimate.inverses(ioRHS) : this._estimate.avgInverseProperties();
                    break;
                }
                this._staticCost = (long)this._estimate.getPropertyCount() * this._estimate.getCost(KBOperation.GET_INVERSES);
                this._branchCount = (double)this._estimate.getPropertyCount() * this._estimate.avgInverseProperties();
                break;
            }
            case ObjectProperty: {
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_OBJECT_PROPERTY);
                    this._branchCount = 1.0;
                    break;
                }
                this._staticCost = this._estimate.getCost(KBOperation.GET_OBJECT_PROPERTIES);
                this._branchCount = this._estimate.getObjectPropertyCount();
                break;
            }
            case DatatypeProperty: {
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_DATATYPE_PROPERTY);
                    this._branchCount = 1.0;
                    break;
                }
                this._staticCost = this._estimate.getCost(KBOperation.GET_DATATYPE_PROPERTIES);
                this._branchCount = this._estimate.getDataPropertyCount();
                break;
            }
            case Functional: {
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_FUNCTIONAL_PROPERTY);
                    this._branchCount = 1.0;
                    break;
                }
                this._staticCost = this._estimate.getCost(KBOperation.GET_FUNCTIONAL_PROPERTIES);
                this._branchCount = this._estimate.getFunctionalPropertyCount();
                break;
            }
            case InverseFunctional: {
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_INVERSE_FUNCTIONAL_PROPERTY);
                    this._branchCount = 1.0;
                    break;
                }
                this._staticCost = this._estimate.getCost(KBOperation.GET_INVERSE_FUNCTIONAL_PROPERTIES);
                this._branchCount = this._estimate.getInverseFunctionalPropertyCount();
                break;
            }
            case Transitive: {
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_TRANSITIVE_PROPERTY);
                    this._branchCount = 1.0;
                    break;
                }
                this._staticCost = this._estimate.getCost(KBOperation.GET_TRANSITIVE_PROPERTIES);
                this._branchCount = this._estimate.getTransitivePropertyCount();
                break;
            }
            case Symmetric: {
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_SYMMETRIC_PROPERTY);
                    this._branchCount = 1.0;
                    break;
                }
                this._staticCost = this._estimate.getCost(KBOperation.GET_SYMMETRIC_PROPERTIES);
                this._branchCount = this._estimate.getSymmetricPropertyCount();
                break;
            }
            case Asymmetric: {
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_ASYMMETRIC_PROPERTY);
                    this._branchCount = 1.0;
                    break;
                }
                this._staticCost = this._estimate.getCost(KBOperation.GET_ASYMMETRIC_PROPERTIES);
                this._branchCount = this._estimate.getSymmetricPropertyCount();
                break;
            }
            case Reflexive: {
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_REFLEXIVE_PROPERTY);
                    this._branchCount = 1.0;
                    break;
                }
                this._staticCost = this._estimate.getCost(KBOperation.GET_REFLEXIVE_PROPERTIES);
                this._branchCount = this._estimate.getSymmetricPropertyCount();
                break;
            }
            case Irreflexive: {
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_IRREFLEXIVE_PROPERTY);
                    this._branchCount = 1.0;
                    break;
                }
                this._staticCost = this._estimate.getCost(KBOperation.GET_IRREFLEXIVE_PROPERTIES);
                this._branchCount = this._estimate.getSymmetricPropertyCount();
                break;
            }
            case NotKnown: {
                this.estimate(((NotKnownQueryAtom)atom).getAtoms(), bound);
                break;
            }
            case Union: {
                double totalStaticCount = 1.0;
                double totalBranchCount = 1.0;
                for (List<QueryAtom> atoms : ((UnionQueryAtom)atom).getUnion()) {
                    this.estimate(atoms, bound);
                    totalBranchCount += this._branchCount;
                    totalStaticCount += this._staticCost;
                }
                this._staticCost = totalStaticCount;
                this._branchCount = totalBranchCount;
                break;
            }
            case UndistVarCore: {
                double b;
                if (bound.containsAll(arguments)) {
                    this._staticCost = this._estimate.getCost(KBOperation.IS_TYPE);
                    this._branchCount = 1.0;
                    break;
                }
                Core core = (Core)atom;
                int n = core.getDistVars().size();
                this._branchCount = b = Math.pow(this._estimate.avgInstancesPerClass(false), n);
                switch (QueryEngine.getStrategy(atom)) {
                    case ALLFAST: 
                    case SIMPLE: {
                        this._staticCost = (double)((long)n * this._estimate.getCost(KBOperation.GET_INSTANCES)) + b * (double)this._estimate.getCost(KBOperation.IS_TYPE);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Not yet implemented.");
            }
            case Datatype: {
                this._staticCost = bound.containsAll(arguments) ? 1.0 : 2.147483647E9;
                this._branchCount = 1.0;
                break;
            }
            default: {
                throw new UnsupportedFeatureException("Unknown atom type " + (Object)((Object)atom.getPredicate()) + ".");
            }
        }
        return this._staticCost;
    }

    public double getBranchCount() {
        return this._branchCount;
    }

    public double getStaticCost() {
        return this._staticCost;
    }

    private ATermAppl inv(ATermAppl pred) {
        return this._kb.getRBox().getRole(pred).getInverse().getName();
    }

    private boolean isConstant(ATermAppl a) {
        return !ATermUtils.isVar(a);
    }
}

