/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqlowl.parser;

import java.text.StringCharacterIterator;

public class ParserUtilities {
    public static String dropFirstAndLast(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        int n = s.length();
        if (n < 3) {
            if (n == 2) {
                return "";
            }
            throw new IllegalArgumentException();
        }
        return s.substring(1, n - 1);
    }

    public static String dropFirstAndLast3(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        int n = s.length();
        if (n < 7) {
            if (n == 6) {
                return "";
            }
            throw new IllegalArgumentException();
        }
        return s.substring(3, n - 3);
    }

    public static String sparqlUnescape(String s) {
        StringBuilder buf = new StringBuilder();
        StringCharacterIterator it = new StringCharacterIterator(s);
        char c = it.current();
        while (c != '\uffff') {
            if (c == '\\') {
                c = it.next();
                switch (c) {
                    case 't': {
                        buf.append('\t');
                        break;
                    }
                    case 'b': {
                        buf.append('\b');
                        break;
                    }
                    case 'n': {
                        buf.append('\n');
                        break;
                    }
                    case 'r': {
                        buf.append('\r');
                        break;
                    }
                    case 'f': {
                        buf.append('\f');
                        break;
                    }
                    case '\\': {
                        buf.append('\\');
                        break;
                    }
                    case '\"': {
                        buf.append('\"');
                        break;
                    }
                    case '\'': {
                        buf.append('\'');
                        break;
                    }
                    case '\uffff': {
                        buf.append('\\');
                        break;
                    }
                    default: {
                        buf.append('\\');
                        buf.append(c);
                        break;
                    }
                }
            } else {
                buf.append(c);
            }
            c = it.next();
        }
        return buf.toString();
    }
}

