/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.rdf4j.model.Graph;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.GraphImpl;
import org.eclipse.rdf4j.model.util.GraphUtil;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.RDFHandlerWrapper;

public class BufferedGroupingRDFHandler
extends RDFHandlerWrapper {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private final int bufferSize;
    private final Graph bufferedStatements;
    private final Set<Resource> contexts;
    private final Object bufferLock = new Object();

    public BufferedGroupingRDFHandler(RDFHandler ... handlers) {
        this(1024, handlers);
    }

    public BufferedGroupingRDFHandler(int bufferSize, RDFHandler ... handlers) {
        super(handlers);
        this.bufferSize = bufferSize;
        this.bufferedStatements = new GraphImpl();
        this.contexts = new HashSet<Resource>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        Object object = this.bufferLock;
        synchronized (object) {
            this.bufferedStatements.add(st);
            this.contexts.add(st.getContext());
            if (this.bufferedStatements.size() >= this.bufferSize) {
                this.processBuffer();
            }
        }
    }

    private void processBuffer() throws RDFHandlerException {
        for (Resource context : this.contexts) {
            Set<Resource> subjects = GraphUtil.getSubjects(this.bufferedStatements, null, null, context);
            for (Resource subject : subjects) {
                HashSet<IRI> processedPredicates = new HashSet<IRI>();
                Iterator<Statement> typeStatements = this.bufferedStatements.match(subject, RDF.TYPE, null, context);
                while (typeStatements.hasNext()) {
                    Statement typeStatement = typeStatements.next();
                    super.handleStatement(typeStatement);
                }
                processedPredicates.add(RDF.TYPE);
                Iterator<Statement> subjectStatements = this.bufferedStatements.match(subject, null, null, context);
                while (subjectStatements.hasNext()) {
                    Statement subjectStatement = subjectStatements.next();
                    IRI predicate = subjectStatement.getPredicate();
                    if (processedPredicates.contains(predicate)) continue;
                    Iterator<Statement> toWrite = this.bufferedStatements.match(subject, predicate, null, context);
                    while (toWrite.hasNext()) {
                        Statement toWriteSt = toWrite.next();
                        super.handleStatement(toWriteSt);
                    }
                    processedPredicates.add(predicate);
                }
            }
        }
        this.bufferedStatements.clear();
        this.contexts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endRDF() throws RDFHandlerException {
        Object object = this.bufferLock;
        synchronized (object) {
            this.processBuffer();
        }
        super.endRDF();
    }
}

