/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.specifics;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.EdgeSetFactory;
import org.jgrapht.graph.specifics.ArrayUnenforcedSetEdgeSetFactory;
import org.jgrapht.graph.specifics.DirectedEdgeContainer;
import org.jgrapht.graph.specifics.Specifics;
import org.jgrapht.util.ArrayUnenforcedSet;

public class DirectedSpecifics<V, E>
implements Specifics<V, E>,
Serializable {
    private static final long serialVersionUID = 8971725103718958232L;
    protected AbstractBaseGraph<V, E> abstractBaseGraph;
    protected Map<V, DirectedEdgeContainer<V, E>> vertexMapDirected;
    protected EdgeSetFactory<V, E> edgeSetFactory;

    public DirectedSpecifics(AbstractBaseGraph<V, E> abstractBaseGraph) {
        this(abstractBaseGraph, new LinkedHashMap(), new ArrayUnenforcedSetEdgeSetFactory());
    }

    public DirectedSpecifics(AbstractBaseGraph<V, E> abstractBaseGraph, Map<V, DirectedEdgeContainer<V, E>> vertexMap) {
        this(abstractBaseGraph, vertexMap, new ArrayUnenforcedSetEdgeSetFactory());
    }

    public DirectedSpecifics(AbstractBaseGraph<V, E> abstractBaseGraph, Map<V, DirectedEdgeContainer<V, E>> vertexMap, EdgeSetFactory<V, E> edgeSetFactory) {
        this.abstractBaseGraph = abstractBaseGraph;
        this.vertexMapDirected = vertexMap;
        this.edgeSetFactory = edgeSetFactory;
    }

    @Override
    public void addVertex(V v) {
        this.vertexMapDirected.put(v, null);
    }

    @Override
    public Set<V> getVertexSet() {
        return this.vertexMapDirected.keySet();
    }

    @Override
    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        ArrayUnenforcedSet edges = null;
        if (this.abstractBaseGraph.containsVertex(sourceVertex) && this.abstractBaseGraph.containsVertex(targetVertex)) {
            edges = new ArrayUnenforcedSet();
            DirectedEdgeContainer<V, E> ec = this.getEdgeContainer(sourceVertex);
            for (Object e : ec.outgoing) {
                if (!this.abstractBaseGraph.getEdgeTarget(e).equals(targetVertex)) continue;
                edges.add(e);
            }
        }
        return edges;
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        if (this.abstractBaseGraph.containsVertex(sourceVertex) && this.abstractBaseGraph.containsVertex(targetVertex)) {
            DirectedEdgeContainer<V, E> ec = this.getEdgeContainer(sourceVertex);
            for (Object e : ec.outgoing) {
                if (!this.abstractBaseGraph.getEdgeTarget(e).equals(targetVertex)) continue;
                return e;
            }
        }
        return null;
    }

    @Override
    public void addEdgeToTouchingVertices(E e) {
        V source = this.abstractBaseGraph.getEdgeSource(e);
        V target = this.abstractBaseGraph.getEdgeTarget(e);
        this.getEdgeContainer(source).addOutgoingEdge(e);
        this.getEdgeContainer(target).addIncomingEdge(e);
    }

    @Override
    public int degreeOf(V vertex) {
        return this.inDegreeOf(vertex) + this.outDegreeOf(vertex);
    }

    @Override
    public Set<E> edgesOf(V vertex) {
        ArrayUnenforcedSet inAndOut = new ArrayUnenforcedSet(this.getEdgeContainer(vertex).incoming);
        inAndOut.addAll(this.getEdgeContainer(vertex).outgoing);
        if (this.abstractBaseGraph.isAllowingLoops()) {
            Set<E> loops = this.getAllEdges(vertex, vertex);
            int i = 0;
            while (i < inAndOut.size()) {
                Object e = inAndOut.get(i);
                if (loops.contains(e)) {
                    inAndOut.remove(i);
                    loops.remove(e);
                    continue;
                }
                ++i;
            }
        }
        return Collections.unmodifiableSet(inAndOut);
    }

    @Override
    public int inDegreeOf(V vertex) {
        return this.getEdgeContainer(vertex).incoming.size();
    }

    @Override
    public Set<E> incomingEdgesOf(V vertex) {
        return this.getEdgeContainer(vertex).getUnmodifiableIncomingEdges();
    }

    @Override
    public int outDegreeOf(V vertex) {
        return this.getEdgeContainer(vertex).outgoing.size();
    }

    @Override
    public Set<E> outgoingEdgesOf(V vertex) {
        return this.getEdgeContainer(vertex).getUnmodifiableOutgoingEdges();
    }

    @Override
    public void removeEdgeFromTouchingVertices(E e) {
        V source = this.abstractBaseGraph.getEdgeSource(e);
        V target = this.abstractBaseGraph.getEdgeTarget(e);
        this.getEdgeContainer(source).removeOutgoingEdge(e);
        this.getEdgeContainer(target).removeIncomingEdge(e);
    }

    protected DirectedEdgeContainer<V, E> getEdgeContainer(V vertex) {
        DirectedEdgeContainer<V, E> ec = this.vertexMapDirected.get(vertex);
        if (ec == null) {
            ec = new DirectedEdgeContainer<V, E>(this.edgeSetFactory, vertex);
            this.vertexMapDirected.put((DirectedEdgeContainer<V, E>)vertex, (DirectedEdgeContainer<DirectedEdgeContainer<V, E>, E>)ec);
        }
        return ec;
    }
}

