/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class AmalgamateSubClassAxioms
extends AbstractCompositeOntologyChange {
    public AmalgamateSubClassAxioms(OWLDataFactory dataFactory, Collection<OWLOntology> ontologies) {
        super(dataFactory);
        OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
        ontologies.forEach(o -> o.classesInSignature().forEach(cls -> this.amalgamate((OWLOntology)o, (OWLClass)cls)));
    }

    protected void amalgamate(OWLOntology ont, OWLClass cls) {
        List<OWLSubClassOfAxiom> axioms = OWLAPIStreamUtils.asList(ont.subClassAxiomsForSubClass(cls));
        if (axioms.size() < 2) {
            return;
        }
        axioms.forEach(ax -> this.addChange(new RemoveAxiom(ont, (OWLAxiom)ax)));
        Stream<OWLClassExpression> superclasses = axioms.stream().map(OWLSubClassOfAxiom::getSuperClass);
        OWLObjectIntersectionOf intersection = this.df.getOWLObjectIntersectionOf(superclasses);
        this.addChange(new AddAxiom(ont, this.df.getOWLSubClassOfAxiom(cls, intersection)));
    }
}

