/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public interface OWLAxiom
extends OWLObject,
HasAnnotations {
    public static <T extends OWLAxiom> T getAxiomWithoutAnnotations(T axiom) {
        return (T)axiom.getAxiomWithoutAnnotations(axiom.getClass());
    }

    public static <T extends OWLAxiom> T getAnnotatedAxiom(Stream<OWLAnnotation> annotations, T axiom) {
        return (T)axiom.getAnnotatedAxiom(axiom.getClass(), annotations);
    }

    public static <T extends OWLAxiom> T getAnnotatedAxiom(Collection<OWLAnnotation> annotations, T axiom) {
        return OWLAxiom.getAnnotatedAxiom(annotations.stream(), axiom);
    }

    @Override
    default public int typeIndex() {
        return 2000 + this.getAxiomType().getIndex();
    }

    @Override
    default public boolean isIndividual() {
        return false;
    }

    @Override
    default public boolean isAxiom() {
        return true;
    }

    public void accept(OWLAxiomVisitor var1);

    public <O> O accept(OWLAxiomVisitorEx<O> var1);

    public <T extends OWLAxiom> T getAxiomWithoutAnnotations();

    default public <T extends OWLAxiom> T getAxiomWithoutAnnotations(Class<T> witness) {
        return this.getAxiomWithoutAnnotations();
    }

    default public <T extends OWLAxiom> T getAnnotatedAxiom(Class<T> witness, Stream<OWLAnnotation> annotations) {
        return this.getAnnotatedAxiom(annotations);
    }

    public <T extends OWLAxiom> T getAnnotatedAxiom(Stream<OWLAnnotation> var1);

    default public <T extends OWLAxiom> T getAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
        return this.getAnnotatedAxiom(annotations.stream());
    }

    default public boolean equalsIgnoreAnnotations(@Nullable OWLAxiom axiom) {
        if (axiom == null) {
            return false;
        }
        if (this == axiom) {
            return true;
        }
        if (this.typeIndex() != axiom.typeIndex()) {
            return false;
        }
        return OWLAPIStreamUtils.equalStreams(this.componentsWithoutAnnotations(), axiom.componentsWithoutAnnotations());
    }

    default public boolean isLogicalAxiom() {
        return false;
    }

    default public boolean isAnnotationAxiom() {
        return false;
    }

    public boolean isAnnotated();

    public AxiomType<?> getAxiomType();

    default public boolean isOfType(AxiomType<?> ... axiomTypes) {
        return this.isOfType(Arrays.stream(axiomTypes));
    }

    default public boolean isOfType(Collection<AxiomType<?>> types) {
        return types.contains(this.getAxiomType());
    }

    default public boolean isOfType(Stream<AxiomType<?>> types) {
        return types.anyMatch(this.getAxiomType()::equals);
    }

    public OWLAxiom getNNF();
}

