/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.semanticweb.owlapi.formats.RioRDFDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.rio.RioRenderer;
import org.semanticweb.owlapi.util.AbstractOWLStorer;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class RioStorer
extends AbstractOWLStorer {
    private final OWLDocumentFormatFactory ontFormat;
    private final Resource[] contexts;
    @Nullable
    private transient RDFHandler rioHandler;

    public RioStorer(OWLDocumentFormatFactory ontologyFormat, RDFHandler rioHandler, Resource ... contexts) {
        this(ontologyFormat, contexts);
        this.rioHandler = rioHandler;
    }

    public RioStorer(OWLDocumentFormatFactory ontologyFormat, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull(contexts);
        this.ontFormat = ontologyFormat;
        this.contexts = contexts;
    }

    protected static RDFHandler getRDFHandlerForOutputStream(@Nullable RDFFormat format, OutputStream outputStream) throws OWLOntologyStorageException {
        if (format == null) {
            return new StatementCollector();
        }
        try {
            return Rio.createWriter(format, outputStream);
        }
        catch (UnsupportedRDFormatException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    @Override
    public boolean canStoreOntology(OWLDocumentFormat ontologyFormat) {
        return this.ontFormat.createFormat().equals(ontologyFormat);
    }

    protected RDFHandler getRDFHandlerForWriter(@Nullable RDFFormat format, Writer writer) throws OWLOntologyStorageException {
        if (format == null) {
            return new StatementCollector();
        }
        try {
            return Rio.createWriter(format, writer);
        }
        catch (UnsupportedRDFormatException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    @Nullable
    public RDFHandler getRioHandler() {
        return this.rioHandler;
    }

    public void setRioHandler(RDFHandler rioHandler) {
        this.rioHandler = rioHandler;
    }

    @Override
    protected void storeOntology(OWLOntology ontology, PrintWriter writer, OWLDocumentFormat format) throws OWLOntologyStorageException {
        if (this.rioHandler == null) {
            if (!(format instanceof RioRDFDocumentFormat)) {
                throw new OWLOntologyStorageException("Unable to use RioOntologyStorer to store this format as it is not recognised as a RioRDFOntologyFormat: " + format);
            }
            RioRDFDocumentFormat rioFormat = (RioRDFDocumentFormat)format;
            if (format.isTextual()) {
                this.rioHandler = this.getRDFHandlerForWriter(rioFormat.getRioFormat(), writer);
            } else {
                throw new OWLOntologyStorageException("Unable to use storeOntology with a Writer as the desired format is not textual. Format was " + format);
            }
        }
        try {
            RioRenderer ren = new RioRenderer(ontology, OWLAPIPreconditions.verifyNotNull(this.rioHandler), format, this.contexts);
            ren.render();
        }
        catch (OWLRuntimeException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    @Override
    protected void storeOntology(OWLOntology ontology, OutputStream outputStream, OWLDocumentFormat format) throws OWLOntologyStorageException {
        if (this.rioHandler == null) {
            if (!(format instanceof RioRDFDocumentFormat)) {
                throw new OWLOntologyStorageException("Unable to use RioOntologyStorer to store this format as it is not recognised as a RioRDFOntologyFormat: " + format);
            }
            RioRDFDocumentFormat rioFormat = (RioRDFDocumentFormat)format;
            if (format.isTextual()) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
                this.rioHandler = this.getRDFHandlerForWriter(rioFormat.getRioFormat(), writer);
            } else {
                this.rioHandler = RioStorer.getRDFHandlerForOutputStream(rioFormat.getRioFormat(), outputStream);
            }
        }
        try {
            RioRenderer ren = new RioRenderer(ontology, OWLAPIPreconditions.verifyNotNull(this.rioHandler), format, this.contexts);
            ren.render();
        }
        catch (OWLRuntimeException e) {
            throw new OWLOntologyStorageException(e);
        }
    }
}

