/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLOntologyWalker;

public class OWLOntologyWalkerVisitorEx<E>
implements OWLObjectVisitorEx<E> {
    private final OWLOntologyWalker walker;

    public OWLOntologyWalkerVisitorEx(OWLOntologyWalker walker) {
        this.walker = OWLAPIPreconditions.checkNotNull(walker, "walker cannot be null");
    }

    @Nullable
    public OWLAxiom getCurrentAxiom() {
        return this.walker.getAxiom();
    }

    public OWLOntology getCurrentOntology() {
        OWLOntology ontology = this.walker.getOntology();
        if (ontology == null) {
            throw new OWLRuntimeException("No current ontology; is the walker being used outside of an ontology visit?");
        }
        return ontology;
    }

    @Nullable
    public OWLAnnotation getCurrentAnnotation() {
        return this.walker.getAnnotation();
    }
}

