/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders;

import java.util.Collection;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapitools.builders.BaseBuilder;

public class BuilderDatatypeDefinition
extends BaseBuilder<OWLDatatypeDefinitionAxiom, BuilderDatatypeDefinition> {
    @Nullable
    private OWLDataRange range = null;
    @Nullable
    private OWLDatatype type = null;

    public BuilderDatatypeDefinition(OWLDatatypeDefinitionAxiom expected, OWLDataFactory df) {
        this(df);
        this.with(expected.getDatatype()).withType(expected.getDataRange()).withAnnotations(expected.annotations());
    }

    @Inject
    public BuilderDatatypeDefinition(OWLDataFactory df) {
        super(df);
    }

    public BuilderDatatypeDefinition withType(OWL2Datatype arg) {
        return this.withType(arg.getDatatype(this.df));
    }

    public BuilderDatatypeDefinition withType(OWLDataRange arg) {
        this.range = arg;
        return this;
    }

    public BuilderDatatypeDefinition with(OWLDatatype arg) {
        this.type = arg;
        return this;
    }

    @Override
    public OWLDatatypeDefinitionAxiom buildObject() {
        return this.df.getOWLDatatypeDefinitionAxiom(OWLAPIPreconditions.verifyNotNull(this.type), this.getRange(), (Collection<OWLAnnotation>)this.annotations);
    }

    public OWLDataRange getRange() {
        return OWLAPIPreconditions.verifyNotNull(this.range);
    }

    @Nullable
    public OWLDatatype getType() {
        return this.type;
    }
}

